/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CubicToQuad {
    private static final double EPSILON = 1.0E-16;

    private Point[] calcPowerCoefficients(Point p1, Point c1, Point c2, Point p2) {
        Point a = p2.sub(p1).add(c1.sub(c2).mul(3.0));
        Point b = p1.add(c2).mul(3.0).sub(c1.mul(6.0));
        Point c = c1.sub(p1).mul(3.0);
        Point d = p1;
        return new Point[]{a, b, c, d};
    }

    private Point calcPoint(Point a, Point b, Point c, Point d, double t) {
        return a.mul(t).add(b).mul(t).add(c).mul(t).add(d);
    }

    private Point calcPointQuad(Point a, Point b, Point c, double t) {
        return a.mul(t).add(b).mul(t).add(c);
    }

    private Point calcPointDerivative(Point a, Point b, Point c, Point d, double t) {
        return a.mul(3.0 * t).add(b.mul(2.0)).mul(t).add(c);
    }

    private double[] quadSolve(double a, double b, double c) {
        if (a == 0.0) {
            double[] dArray;
            if (b == 0.0) {
                dArray = new double[]{};
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = -c / b;
            }
            return dArray;
        }
        double D = b * b - 4.0 * a * c;
        if (Math.abs(D) < 1.0E-16) {
            return new double[0];
        }
        if (D == 0.0) {
            return new double[]{-b / (2.0 * a)};
        }
        double DSqrt = Math.sqrt(D);
        return new double[]{(-b - DSqrt) / (2.0 * a), (-b + DSqrt) / (2.0 * a)};
    }

    private double cubicRoot(double x) {
        return x < 0.0 ? -Math.pow(-x, 0.0) : Math.pow(x, 0.0);
    }

    private double[] cubicSolve(double a, double b, double c, double d) {
        if (a == 0.0) {
            return this.quadSolve(b, c, d);
        }
        double xn = -b / (3.0 * a);
        double yn = ((a * xn + b) * xn + c) * xn + d;
        double deltaSq = (b * b - 3.0 * a * c) / (9.0 * a * a);
        double hSq = 4.0 * a * a * Math.pow(deltaSq, 3.0);
        double D3 = yn * yn - hSq;
        if (D3 > 0.0) {
            double D3Sqrt = Math.sqrt(D3);
            return new double[]{xn + this.cubicRoot((-yn + D3Sqrt) / (2.0 * a)) + this.cubicRoot((-yn - D3Sqrt) / (2.0 * a))};
        }
        if (D3 == 0.0) {
            double delta1 = this.cubicRoot(yn / (2.0 * a));
            return new double[]{xn - 2.0 * delta1, xn + delta1};
        }
        double theta = Math.acos(-yn / Math.sqrt(hSq)) / 3.0;
        double delta = Math.sqrt(deltaSq);
        return new double[]{xn + 2.0 * delta * Math.cos(theta), xn + 2.0 * delta * Math.cos(theta + 2.0943951023931953), xn + 2.0 * delta * Math.cos(theta + 4.1887902047863905)};
    }

    private double minDistanceToQuad(Point point, Point p1, Point c1, Point p2) {
        Point a = p1.add(p2).sub(c1.mul(2.0));
        Point b = c1.sub(p1).mul(2.0);
        Point c = p1;
        double e3 = 2.0 * a.sqr();
        double e2 = 3.0 * a.dot(b);
        double e1 = b.sqr() + 2.0 * a.dot(c.sub(point));
        double e0 = c.sub(point).dot(b);
        double[] solveResult = this.cubicSolve(e3, e2, e1, e0);
        ArrayList<Double> candidates = new ArrayList<Double>();
        for (double t : solveResult) {
            if (!(t > 0.0) || !(t < 1.0)) continue;
            candidates.add(t);
        }
        candidates.add(0.0);
        candidates.add(1.0);
        double minDistance = 1.0E9;
        for (int i = 0; i < candidates.size(); ++i) {
            double distance = this.calcPointQuad(a, b, c, (Double)candidates.get(i)).sub(point).dist();
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    private Point[] processSegment(Point a, Point b, Point c, Point d, double t1, double t2) {
        Point f1 = this.calcPoint(a, b, c, d, t1);
        Point f2 = this.calcPoint(a, b, c, d, t2);
        Point f1_ = this.calcPointDerivative(a, b, c, d, t1);
        Point f2_ = this.calcPointDerivative(a, b, c, d, t2);
        double D = -f1_.x * f2_.y + f2_.x * f1_.y;
        if (Math.abs(D) < 1.0E-8) {
            return new Point[]{f1, f1.add(f2).div(2.0), f2};
        }
        double cx = (f1_.x * (f2.y * f2_.x - f2.x * f2_.y) + f2_.x * (f1.x * f1_.y - f1.y * f1_.x)) / D;
        double cy = (f1_.y * (f2.y * f2_.x - f2.x * f2_.y) + f2_.y * (f1.x * f1_.y - f1.y * f1_.x)) / D;
        return new Point[]{f1, new Point(cx, cy), f2};
    }

    private Point[] calcPowerCoefficientsQuad(Point p1, Point c1, Point p2) {
        Point a = c1.mul(-2.0).add(p1).add(p2);
        Point b = c1.sub(p1).mul(2.0);
        Point c = p1;
        return new Point[]{a, b, c};
    }

    private double minDistanceToLineSq(Point point, Point p1, Point p2) {
        Point p1p2 = p2.sub(p1);
        double dot = point.sub(p1).dot(p1p2);
        double lenSq = p1p2.sqr();
        double param = 0.0;
        if (lenSq != 0.0) {
            param = dot / lenSq;
        }
        Point diff = param <= 0.0 ? point.sub(p1) : (param >= 1.0 ? point.sub(p2) : point.sub(p1.add(p1p2.mul(param))));
        return diff.sqr();
    }

    private boolean isSegmentApproximationClose(Point a, Point b, Point c, Point d, double tmin, double tmax, Point p1, Point c1, Point p2, double errorBound) {
        double distSq;
        int j;
        double minDistSq;
        int n = 10;
        Point[] p = this.calcPowerCoefficientsQuad(p1, c1, p2);
        Point qa = p[0];
        Point qb = p[1];
        Point qc = p[2];
        double errorBoundSq = errorBound * errorBound;
        ArrayList<Point> cubicPoints = new ArrayList<Point>();
        ArrayList<Point> quadPoints = new ArrayList<Point>();
        double dt = (tmax - tmin) / (double)n;
        int i = 0;
        double t = tmin;
        while (i <= n) {
            cubicPoints.add(this.calcPoint(a, b, c, d, t));
            ++i;
            t += dt;
        }
        dt = 1.0 / (double)n;
        i = 0;
        t = 0.0;
        while (i <= n) {
            quadPoints.add(this.calcPointQuad(qa, qb, qc, t));
            ++i;
            t += dt;
        }
        for (i = 1; i < cubicPoints.size() - 1; ++i) {
            minDistSq = Double.MAX_VALUE;
            for (j = 0; j < quadPoints.size() - 1; ++j) {
                distSq = this.minDistanceToLineSq((Point)cubicPoints.get(i), (Point)quadPoints.get(j), (Point)quadPoints.get(j + 1));
                minDistSq = Math.min(minDistSq, distSq);
            }
            if (!(minDistSq > errorBoundSq)) continue;
            return false;
        }
        for (i = 1; i < quadPoints.size() - 1; ++i) {
            minDistSq = Double.MAX_VALUE;
            for (j = 0; j < cubicPoints.size() - 1; ++j) {
                distSq = this.minDistanceToLineSq((Point)quadPoints.get(i), (Point)cubicPoints.get(j), (Point)cubicPoints.get(j + 1));
                minDistSq = Math.min(minDistSq, distSq);
            }
            if (!(minDistSq > errorBoundSq)) continue;
            return false;
        }
        return true;
    }

    private boolean _isApproximationClose(Point a, Point b, Point c, Point d, List<Point[]> quadCurves, double errorBound) {
        double dt = 1.0 / (double)quadCurves.size();
        for (int i = 0; i < quadCurves.size(); ++i) {
            Point p2;
            Point c1;
            Point p1 = quadCurves.get(i)[0];
            if (this.isSegmentApproximationClose(a, b, c, d, (double)i * dt, (double)(i + 1) * dt, p1, c1 = quadCurves.get(i)[1], p2 = quadCurves.get(i)[2], errorBound)) continue;
            return false;
        }
        return true;
    }

    private List<Point[]> fromFlatArray(double[] points) {
        ArrayList<Point[]> result = new ArrayList<Point[]>();
        int segmentsNumber = (points.length - 2) / 4;
        for (int i = 0; i < segmentsNumber; ++i) {
            result.add(new Point[]{new Point(points[4 * i], points[4 * i + 1]), new Point(points[4 * i + 2], points[4 * i + 3]), new Point(points[4 * i + 4], points[4 * i + 5])});
        }
        return result;
    }

    private List<Double> toFlatArray(List<Point[]> quadsList) {
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(quadsList.get((int)0)[0].x);
        result.add(quadsList.get((int)0)[0].y);
        for (int i = 0; i < quadsList.size(); ++i) {
            result.add(quadsList.get((int)i)[1].x);
            result.add(quadsList.get((int)i)[1].y);
            result.add(quadsList.get((int)i)[2].x);
            result.add(quadsList.get((int)i)[2].y);
        }
        return result;
    }

    private boolean isApproximationClose(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y, double[] quads, double errorBound) {
        Point[] pc = this.calcPowerCoefficients(new Point(p1x, p1y), new Point(c1x, c1y), new Point(c2x, c2y), new Point(p2x, p2y));
        return this._isApproximationClose(pc[0], pc[1], pc[2], pc[3], this.fromFlatArray(quads), errorBound);
    }

    private double[][] subdivideCubic(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double t) {
        double u = 1.0 - t;
        double v = t;
        double bx = x1 * u + x2 * v;
        double sx = x2 * u + x3 * v;
        double fx = x3 * u + x4 * v;
        double cx = bx * u + sx * v;
        double ex = sx * u + fx * v;
        double dx = cx * u + ex * v;
        double by = y1 * u + y2 * v;
        double sy = y2 * u + y3 * v;
        double fy = y3 * u + y4 * v;
        double cy = by * u + sy * v;
        double ey = sy * u + fy * v;
        double dy = cy * u + ey * v;
        return new double[][]{{x1, y1, bx, by, cx, cy, dx, dy}, {dx, dy, ex, ey, fx, fy, x4, y4}};
    }

    public List<Double> cubicToQuad(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y, double errorBound) {
        List<Double> quad;
        List<Double> inflections = this.solveInflections(p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y);
        if (inflections.isEmpty()) {
            return this._cubicToQuad(p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y, errorBound);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        double[] curve = new double[]{p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y};
        double prevPoint = 0.0;
        for (int inflectionIdx = 0; inflectionIdx < inflections.size(); ++inflectionIdx) {
            double[][] split = this.subdivideCubic(curve[0], curve[1], curve[2], curve[3], curve[4], curve[5], curve[6], curve[7], 1.0 - (1.0 - inflections.get(inflectionIdx)) / (1.0 - prevPoint));
            quad = this._cubicToQuad(split[0][0], split[0][1], split[0][2], split[0][3], split[0][4], split[0][5], split[0][6], split[0][7], errorBound);
            result.addAll(quad.subList(0, quad.size() - 2));
            curve = split[1];
            prevPoint = inflections.get(inflectionIdx);
        }
        quad = this._cubicToQuad(curve[0], curve[1], curve[2], curve[3], curve[4], curve[5], curve[6], curve[7], errorBound);
        result.addAll(quad);
        return result;
    }

    private List<Double> _cubicToQuad(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y, double errorBound) {
        Point p1 = new Point(p1x, p1y);
        Point c1 = new Point(c1x, c1y);
        Point c2 = new Point(c2x, c2y);
        Point p2 = new Point(p2x, p2y);
        Point[] pc = this.calcPowerCoefficients(p1, c1, c2, p2);
        Point a = pc[0];
        Point b = pc[1];
        Point c = pc[2];
        Point d = pc[3];
        ArrayList<Point[]> approximation = new ArrayList<Point[]>();
        for (int segmentsCount = 1; segmentsCount <= 8; ++segmentsCount) {
            approximation.clear();
            for (double t = 0.0; t < 1.0; t += 1.0 / (double)segmentsCount) {
                approximation.add(this.processSegment(a, b, c, d, t, t + 1.0 / (double)segmentsCount));
            }
            if ((segmentsCount != 1 || !(((Point[])approximation.get(0))[1].sub(p1).dot(c1.sub(p1)) < 0.0) && !(((Point[])approximation.get(0))[1].sub(p2).dot(c2.sub(p2)) < 0.0)) && this._isApproximationClose(a, b, c, d, approximation, errorBound)) break;
        }
        return this.toFlatArray(approximation);
    }

    private List<Double> solveInflections(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double p = -(x4 * (y1 - 2.0 * y2 + y3)) + x3 * (2.0 * y1 - 3.0 * y2 + y4) + x1 * (y2 - 2.0 * y3 + y4) - x2 * (y1 - 3.0 * y3 + 2.0 * y4);
        double q = x4 * (y1 - y2) + 3.0 * x3 * (-y1 + y2) + x2 * (2.0 * y1 - 3.0 * y3 + y4) - x1 * (2.0 * y2 - 3.0 * y3 + y4);
        double r = x3 * (y1 - y2) + x1 * (y2 - y3) + x2 * (-y1 + y3);
        double[] arr = this.quadSolve(p, q, r);
        ArrayList<Double> inf = new ArrayList<Double>();
        for (double t : arr) {
            if (!(t > 1.0E-8) || !(t < 0.99999999)) continue;
            inf.add(t);
        }
        Collections.sort(inf);
        return inf;
    }

    public static void main(String[] args) {
        List<Double> quadCoordinates = new CubicToQuad().cubicToQuad(7217.0, 4004.0, 7155.32, 4019.7800000000007, 6403.46, 3544.120000000001, 6280.699999999999, 3559.46, 0.1);
        int r = 0;
        for (Double d : quadCoordinates) {
            System.err.println("" + r + ": " + d);
            ++r;
        }
    }

    class Point {
        public double x;
        public double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point add(Point point) {
            return new Point(this.x + point.x, this.y + point.y);
        }

        public Point sub(Point point) {
            return new Point(this.x - point.x, this.y - point.y);
        }

        public Point mul(double value) {
            return new Point(this.x * value, this.y * value);
        }

        public Point div(double value) {
            return new Point(this.x / value, this.y / value);
        }

        public double dist() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        public double sqr() {
            return this.x * this.x + this.y * this.y;
        }

        public double dot(Point point) {
            return this.x * point.x + this.y * point.y;
        }

        public String toString() {
            return "[" + this.x + ", " + this.y + "]";
        }
    }
}

