/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import com.jpexs.decompiler.flash.math.Polynomial;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Intersections {
    private static final double FLATNESS = 0.01;

    private static Point2D min(Point2D p1, Point2D p2) {
        return new Point2D.Double(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()));
    }

    private static Point2D max(Point2D p1, Point2D p2) {
        return new Point2D.Double(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()));
    }

    private static Point2D multiply(Point2D p, double scalar) {
        return new Point2D.Double(p.getX() * scalar, p.getY() * scalar);
    }

    private static Point2D add(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY());
    }

    private static Point2D lerp(Point2D p1, Point2D p2, double t) {
        double omt = 1.0 - t;
        return new Point2D.Double(p1.getX() * omt + p2.getX() * t, p1.getY() * omt + p2.getY() * t);
    }

    private static List<Point2D> intersectLinePolyline(Point2D a1, Point2D a2, List<Point2D> points) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 0; i < points.size() - 1; ++i) {
            Point2D b1 = points.get(i);
            Point2D b2 = points.get(i + 1);
            List<Point2D> inter = Intersections.intersectLineLine(a1, a2, b1, b2, false);
            for (Point2D p : inter) {
                if (result.contains(p)) continue;
                result.add(p);
            }
        }
        return result;
    }

    private static List<Point2D> intersectPolylinePolyline(List<Point2D> points1, List<Point2D> points2) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 0; i < points1.size() - 1; ++i) {
            Point2D a1 = points1.get(i);
            Point2D a2 = points1.get(i + 1);
            List<Point2D> inter = Intersections.intersectLinePolyline(a1, a2, points2);
            result.addAll(inter);
        }
        return result;
    }

    private static Point2D vectorFromPoints(Point2D p1, Point2D p2) {
        return new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    private static Point2D subtract(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    private static Point2D project(Point2D p1, Point2D that) {
        double percent = Intersections.dot(p1, that) / Intersections.dot(that, that);
        return Intersections.multiply(that, percent);
    }

    private static Point2D perpendicular(Point2D p1, Point2D that) {
        return Intersections.subtract(p1, Intersections.project(p1, that));
    }

    private static double vectorLength(Point2D p) {
        return Math.sqrt(p.getX() * p.getX() + p.getY() * p.getY());
    }

    private static void tesselateInterior(double flatness, Point2D zeroVector, Point2D p1, Point2D p2, Point2D p3, List<Point2D> points) {
        Point2D p4 = Intersections.lerp(p1, p2, 0.5);
        Point2D p5 = Intersections.lerp(p2, p3, 0.5);
        Point2D p6 = Intersections.lerp(p4, p5, 0.5);
        Point2D baseline = Intersections.vectorFromPoints(p1, p3);
        Point2D tangent = Intersections.vectorFromPoints(p1, p2);
        double dmax = 0.0;
        if (!zeroVector.equals(tangent)) {
            Point2D perpendicular = Intersections.perpendicular(baseline, tangent);
            dmax = Intersections.vectorLength(perpendicular);
        }
        if (dmax > flatness) {
            Intersections.tesselateInterior(flatness, zeroVector, p1, p4, p6, points);
            points.add(new Point2D.Double(p6.getX(), p6.getY()));
            Intersections.tesselateInterior(flatness, zeroVector, p6, p5, p3, points);
        } else {
            points.add(new Point2D.Double(p6.getX(), p6.getY()));
        }
    }

    public static List<Point2D> quadraticBezierToToPolyline(Point2D p1, Point2D p2, Point2D p3) {
        return Intersections.quadraticBezierToToPolyline(p1, p2, p3, null);
    }

    public static List<Point2D> quadraticBezierToToPolyline(Point2D p1, Point2D p2, Point2D p3, Double flatness) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Point2D.Double zeroVector = new Point2D.Double(0.0, 0.0);
        flatness = flatness != null ? flatness : 1.0;
        points.add(p1);
        Intersections.tesselateInterior(flatness, zeroVector, p1, p2, p3, points);
        points.add(p3);
        return points;
    }

    public static List<Point2D> intersectBezier2Bezier2Slow(Point2D a1, Point2D a2, Point2D a3, Point2D b1, Point2D b2, Point2D b3) {
        List<Point2D> a = Intersections.quadraticBezierToToPolyline(a1, a2, a3, 0.01);
        List<Point2D> b = Intersections.quadraticBezierToToPolyline(b1, b2, b3, 0.01);
        return Intersections.intersectPolylinePolyline(a, b);
    }

    public static boolean rectIntersection(Rectangle2D r1, Rectangle2D r2) {
        double xmax2;
        double xmin = Math.max(r1.getX(), r2.getX());
        double xmax1 = r1.getX() + r1.getWidth();
        double xmax = Math.min(xmax1, xmax2 = r2.getX() + r2.getWidth());
        if (Double.compare(xmax, xmin) >= 0) {
            double ymax2;
            double ymin = Math.max(r1.getY(), r2.getY());
            double ymax1 = r1.getY() + r1.getHeight();
            double ymax = Math.min(ymax1, ymax2 = r2.getY() + r2.getHeight());
            if (Double.compare(ymax, ymin) >= 0) {
                return true;
            }
        }
        return false;
    }

    public static Rectangle2D getBBox(Point2D ... points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point2D p : points) {
            if (p.getX() < minX) {
                minX = p.getX();
            }
            if (p.getX() > maxX) {
                maxX = p.getX();
            }
            if (p.getY() < minY) {
                minY = p.getY();
            }
            if (!(p.getY() > maxY)) continue;
            maxY = p.getY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static List<Point2D> intersectBezier2Bezier2(Point2D a1, Point2D a2, Point2D a3, Point2D b1, Point2D b2, Point2D b3) {
        List<Double> roots;
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        Point2D pa = Intersections.multiply(a2, -2.0);
        Point2D x = Intersections.add(pa, a3);
        Point2D c12 = Intersections.add(a1, x);
        pa = Intersections.multiply(a1, -2.0);
        Point2D pb = Intersections.multiply(a2, 2.0);
        Point2D c11 = Intersections.add(pa, pb);
        Point2D.Double c10 = new Point2D.Double(a1.getX(), a1.getY());
        pa = Intersections.multiply(b2, -2.0);
        Point2D c22 = Intersections.add(b1, Intersections.add(pa, b3));
        pa = Intersections.multiply(b1, -2.0);
        pb = Intersections.multiply(b2, 2.0);
        Point2D c21 = Intersections.add(pa, pb);
        Point2D.Double c20 = new Point2D.Double(b1.getX(), b1.getY());
        double a = c12.getX() * c11.getY() - c11.getX() * c12.getY();
        double b = c22.getX() * c11.getY() - c11.getX() * c22.getY();
        double c = c21.getX() * c11.getY() - c11.getX() * c21.getY();
        double d = c11.getX() * (((Point2D)c10).getY() - ((Point2D)c20).getY()) + c11.getY() * (-((Point2D)c10).getX() + ((Point2D)c20).getX());
        double e = c22.getX() * c12.getY() - c12.getX() * c22.getY();
        double f = c21.getX() * c12.getY() - c12.getX() * c21.getY();
        double g = c12.getX() * (((Point2D)c10).getY() - ((Point2D)c20).getY()) + c12.getY() * (-((Point2D)c10).getX() + ((Point2D)c20).getX());
        Polynomial poly = new Polynomial(Arrays.asList(-e * e, -2.0 * e * f, a * b - f * f - 2.0 * e * g, a * c - 2.0 * f * g, a * d - g * g));
        try {
            roots = poly.getRoots();
        }
        catch (RuntimeException rex) {
            roots = new ArrayList<Double>();
        }
        block2: for (double s : roots) {
            if (!(0.0 <= s) || !(s <= 1.0)) continue;
            Polynomial xp = new Polynomial(Arrays.asList(c12.getX(), c11.getX(), ((Point2D)c10).getX() - ((Point2D)c20).getX() - s * c21.getX() - s * s * c22.getX()));
            xp.simplifyEquals();
            List<Double> xRoots = xp.getRoots();
            Polynomial yp = new Polynomial(Arrays.asList(c12.getY(), c11.getY(), ((Point2D)c10).getY() - ((Point2D)c20).getY() - s * c21.getY() - s * s * c22.getY()));
            yp.simplifyEquals();
            List<Double> yRoots = yp.getRoots();
            if (xRoots.isEmpty() || yRoots.isEmpty()) continue;
            double TOLERANCE = 1.0E-4;
            for (double xRoot : xRoots) {
                if (!(0.0 <= xRoot) || !(xRoot <= 1.0)) continue;
                for (int k = 0; k < yRoots.size(); ++k) {
                    if (!(Math.abs(xRoot - yRoots.get(k)) < TOLERANCE)) continue;
                    Point2D res = Intersections.add(Intersections.multiply(c22, s * s), Intersections.add(Intersections.multiply(c21, s), c20));
                    if (result.contains(res)) continue block2;
                    result.add(res);
                    continue block2;
                }
            }
        }
        if (a1.equals(b1) && !result.contains(a1)) {
            result.add(0, a1);
        }
        if (a3.equals(b3) && !result.contains(a3)) {
            result.add(a3);
        }
        if (a1.equals(b3) && !result.contains(a1)) {
            result.add(0, a1);
        }
        if (a3.equals(b1) && !result.contains(a3)) {
            result.add(0, a3);
        }
        return result;
    }

    private static double dot(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }

    public static List<Point2D> intersectBezier2LineSlow(Point2D p1, Point2D p2, Point2D p3, Point2D a1, Point2D a2) {
        List<Point2D> p = Intersections.quadraticBezierToToPolyline(p1, p2, p3, 0.01);
        return Intersections.intersectLinePolyline(a1, a2, p);
    }

    public static List<Point2D> intersectBezier2Line(Point2D p1, Point2D p2, Point2D p3, Point2D a1, Point2D a2) {
        Point2D min = Intersections.min(a1, a2);
        Point2D max = Intersections.max(a1, a2);
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        Point2D a = Intersections.multiply(p2, -2.0);
        Point2D c2 = Intersections.add(p1, Intersections.add(a, p3));
        a = Intersections.multiply(p1, -2.0);
        Point2D b = Intersections.multiply(p2, 2.0);
        Point2D c1 = Intersections.add(a, b);
        Point2D.Double c0 = new Point2D.Double(p1.getX(), p1.getY());
        Point2D.Double n = new Point2D.Double(a1.getY() - a2.getY(), a2.getX() - a1.getX());
        double cl = a1.getX() * a2.getY() - a2.getX() * a1.getY();
        List<Double> roots = new Polynomial(Arrays.asList(Intersections.dot(n, c2), Intersections.dot(n, c1), Intersections.dot(n, c0) + cl)).getRoots();
        for (double t : roots) {
            if (!(0.0 <= t) || !(t <= 1.0)) continue;
            Point2D p4 = Intersections.lerp(p1, p2, t);
            Point2D p5 = Intersections.lerp(p2, p3, t);
            Point2D p6 = Intersections.lerp(p4, p5, t);
            if (a1.getX() == a2.getX()) {
                if (!(min.getY() <= p6.getY()) || !(p6.getY() <= max.getY())) continue;
                result.add(p6);
                continue;
            }
            if (a1.getY() == a2.getY()) {
                if (!(min.getX() <= p6.getX()) || !(p6.getX() <= max.getX())) continue;
                result.add(p6);
                continue;
            }
            if (!(min.getX() <= p6.getX()) || !(p6.getX() <= max.getX()) || !(min.getY() <= p6.getY()) || !(p6.getY() <= max.getY())) continue;
            result.add(p6);
        }
        if (a1.equals(p1) && !result.contains(a1)) {
            result.add(0, a1);
        }
        if (a2.equals(p3) && !result.contains(a2)) {
            result.add(a2);
        }
        if (a1.equals(p3) && !result.contains(a1)) {
            result.add(0, a1);
        }
        if (a2.equals(p1) && !result.contains(a2)) {
            result.add(0, a2);
        }
        return result;
    }

    public static List<Point2D> intersectLineLine(Point2D a1, Point2D a2, Point2D b1, Point2D b2, boolean addCoincident) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        double ua_t = (b2.getX() - b1.getX()) * (a1.getY() - b1.getY()) - (b2.getY() - b1.getY()) * (a1.getX() - b1.getX());
        double ub_t = (a2.getX() - a1.getX()) * (a1.getY() - b1.getY()) - (a2.getY() - a1.getY()) * (a1.getX() - b1.getX());
        double u_b = (b2.getY() - b1.getY()) * (a2.getX() - a1.getX()) - (b2.getX() - b1.getX()) * (a2.getY() - a1.getY());
        if (u_b != 0.0) {
            double ua = ua_t / u_b;
            double ub = ub_t / u_b;
            if (0.0 <= ua && ua <= 1.0 && 0.0 <= ub && ub <= 1.0) {
                result.add(new Point2D.Double(a1.getX() + ua * (a2.getX() - a1.getX()), a1.getY() + ua * (a2.getY() - a1.getY())));
            }
        } else if (ua_t == 0.0 || ub_t == 0.0) {
            double td;
            double b2v;
            double b1v;
            double a2v;
            double a1v;
            if (!addCoincident) {
                return result;
            }
            if (a1.getX() != b1.getX() || a2.getX() != b2.getX() || a1.getX() != a2.getX()) {
                a1v = a1.getX();
                a2v = a2.getX();
                b1v = b1.getX();
                b2v = b2.getX();
            } else {
                a1v = a1.getY();
                a2v = a2.getY();
                b1v = b1.getY();
                b2v = b2.getY();
            }
            if (a1v > a2v) {
                td = a1v;
                a1v = a2v;
                a2v = td;
            }
            if (b1v > b2v) {
                td = b1v;
                b1v = b2v;
                b2v = td;
            }
            if (b1v < a1v) {
                Point2D t = b1;
                b1 = a1;
                a1 = t;
                t = b2;
                b2 = a2;
                a2 = t;
                double td2 = b1v;
                b1v = a1v;
                a1v = td2;
                td2 = b2v;
                b2v = a2v;
                a2v = td2;
            }
            if (a2v < b1v) {
                return result;
            }
            if (a2v == b1v) {
                return result;
            }
            result.add(b1);
            result.add(a2);
        }
        return result;
    }
}

