/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.search;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.cache.ScriptDecompiledListener;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.search.ABCSearchResult;
import com.jpexs.decompiler.flash.search.ActionSearchResult;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.flash.search.ScriptSearchListener;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.helpers.CancellableWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ActionScriptSearch {
    public List<ActionSearchResult> searchAs2(SWF swf, String txt, boolean ignoreCase, boolean regexp, final boolean pcode, final ScriptSearchListener listener, Map<String, ASMSource> scope) {
        if (txt != null && !txt.isEmpty()) {
            final Map<String, ASMSource> asms = scope == null ? swf.getASMs(false) : scope;
            final ArrayList<ActionSearchResult> found = new ArrayList<ActionSearchResult>();
            final Pattern pat = regexp ? Pattern.compile(txt, ignoreCase ? 66 : 0) : Pattern.compile(Pattern.quote(txt), ignoreCase ? 66 : 0);
            int pos = 0;
            ArrayList<Future<HighlightedText>> futures = new ArrayList<Future<HighlightedText>>();
            try {
                for (final Map.Entry<String, ASMSource> item : asms.entrySet()) {
                    ++pos;
                    final ASMSource aSMSource = item.getValue();
                    if (pcode) {
                        if (listener != null) {
                            listener.onSearch(pos, asms.size(), item.getKey());
                        }
                        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                        aSMSource.getASMSource(ScriptExportMode.PCODE, writer, null);
                        writer.finishHilights();
                        String string = writer.toString();
                        if (pat.matcher(string).find()) {
                            found.add(new ActionSearchResult(aSMSource, pcode, item.getKey()));
                        }
                    } else {
                        final int fpos = pos;
                        Future<HighlightedText> future = SWF.getCachedFuture(aSMSource, null, new ScriptDecompiledListener<HighlightedText>(){

                            @Override
                            public void onStart() {
                                if (listener != null) {
                                    listener.onDecompile(fpos, asms.size(), (String)item.getKey());
                                }
                            }

                            @Override
                            public void onComplete(HighlightedText result) {
                                if (listener != null) {
                                    listener.onSearch(fpos, asms.size(), (String)item.getKey());
                                }
                                if (pat.matcher(result.text).find()) {
                                    ActionSearchResult searchResult = new ActionSearchResult(aSMSource, pcode, (String)item.getKey());
                                    found.add(searchResult);
                                }
                            }
                        });
                        futures.add(future);
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (CancellationException ex) {
                            throw new InterruptedException();
                        }
                        catch (ExecutionException ex) {
                            if (ex.getCause() instanceof InterruptedException) {
                                throw (InterruptedException)ex.getCause();
                            }
                            Logger.getLogger(ActionScriptSearch.class.getName()).log(Level.SEVERE, "Execution exception during search", ex);
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
            return found;
        }
        return null;
    }

    public List<ABCSearchResult> searchAs3(Openable openable, String txt, boolean ignoreCase, boolean regexp, boolean pcode, final ScriptSearchListener listener, List<ScriptPack> scope) {
        if (txt != null && !txt.isEmpty()) {
            List<ScriptPack> fscope;
            ArrayList<String> ignoredClasses = new ArrayList<String>();
            ArrayList<String> ignoredNss = new ArrayList<String>();
            if (Configuration._ignoreAdditionalFlexClasses.get().booleanValue() && openable instanceof SWF) {
                ((SWF)openable).getFlexMainClass(ignoredClasses, ignoredNss);
            }
            final List<ABCSearchResult> found = Collections.synchronizedList(new ArrayList());
            if (scope == null) {
                if (openable instanceof SWF) {
                    fscope = ((SWF)openable).getAS3Packs();
                } else {
                    ABC abc = (ABC)openable;
                    ArrayList<ABC> allAbcs = new ArrayList<ABC>();
                    allAbcs.add(abc);
                    fscope = abc.getScriptPacks(null, allAbcs);
                }
            } else {
                fscope = scope;
            }
            final Pattern pat = regexp ? Pattern.compile(txt, ignoreCase ? 66 : 0) : Pattern.compile(Pattern.quote(txt), ignoreCase ? 66 : 0);
            int pos = 0;
            ArrayList<Future<HighlightedText>> futures = new ArrayList<Future<HighlightedText>>();
            try {
                block5: for (final ScriptPack scriptPack : fscope) {
                    ++pos;
                    if (!scriptPack.isSimple && Configuration.ignoreCLikePackages.get().booleanValue()) continue;
                    if (Configuration._ignoreAdditionalFlexClasses.get().booleanValue()) {
                        String string = scriptPack.getClassPath().packageStr.add(scriptPack.getClassPath().className, scriptPack.getClassPath().namespaceSuffix).toRawString();
                        if (ignoredClasses.contains(string)) continue;
                        for (String ns : ignoredNss) {
                            if (!string.startsWith(ns + ".")) continue;
                            continue block5;
                        }
                    }
                    if (pcode) {
                        if (listener != null) {
                            listener.onSearch(pos, fscope.size(), scriptPack.getClassPath().toString());
                        }
                        ArrayList<MethodId> arrayList = new ArrayList<MethodId>();
                        scriptPack.getMethodInfos(arrayList);
                        ABC abc = scriptPack.abc;
                        for (MethodId methodInfo : arrayList) {
                            int bodyIndex = abc.findBodyIndex(methodInfo.getMethodIndex());
                            if (bodyIndex == -1) continue;
                            MethodBody body = abc.bodies.get(bodyIndex);
                            HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                            abc.bodies.get(bodyIndex).getCode().toASMSource(abc, abc.constants, abc.method_info.get(body.method_info), body, ScriptExportMode.PCODE, writer);
                            writer.finishHilights();
                            String text = writer.toString();
                            if (!pat.matcher(text).find()) continue;
                            ABCSearchResult searchResult = new ABCSearchResult(scriptPack, methodInfo.getClassIndex(), methodInfo.getTraitId());
                            found.add(searchResult);
                        }
                        continue;
                    }
                    final int n = pos;
                    Future<HighlightedText> text = SWF.getCachedFuture(scriptPack, new ScriptDecompiledListener<HighlightedText>(){

                        @Override
                        public void onStart() {
                            if (CancellableWorker.isInterrupted()) {
                                return;
                            }
                            if (listener != null) {
                                listener.onDecompile(n, fscope.size(), scriptPack.getClassPath().toString());
                            }
                        }

                        @Override
                        public void onComplete(HighlightedText result) {
                            if (!CancellableWorker.isInterrupted() && listener != null) {
                                listener.onSearch(n, fscope.size(), scriptPack.getClassPath().toString());
                            }
                            if (pat.matcher(result.text).find()) {
                                ABCSearchResult searchResult = new ABCSearchResult(scriptPack);
                                found.add(searchResult);
                            }
                        }
                    });
                    futures.add(text);
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (CancellationException cancellationException) {
                        throw new InterruptedException();
                    }
                    catch (ExecutionException executionException) {
                        if (executionException.getCause() instanceof InterruptedException) {
                            throw (InterruptedException)executionException.getCause();
                        }
                        Logger.getLogger(ActionScriptSearch.class.getName()).log(Level.SEVERE, "Execution exception during search", executionException);
                    }
                }
            }
            catch (InterruptedException ex) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
            return found;
        }
        return null;
    }
}

