/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.simpleparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Path {
    private List<String> parts;
    private static final String PART_PARENTHESIS = "--FFDEC-()--";
    private static final String PART_BRACKETS = "--FFDEC-[]--";
    public static Path PATH_PARENTHESIS = new Path("--FFDEC-()--");
    public static Path PATH_BRACKETS = new Path("--FFDEC-[]--");
    private Integer cachedHashCode = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < this.parts.size(); ++i) {
            String part;
            if (i > 0) {
                sb.append(".");
            }
            switch (part = this.parts.get(i)) {
                case "--FFDEC-()--": {
                    sb.append("()");
                    continue block8;
                }
                case "--FFDEC-[]--": {
                    sb.append("[]");
                    continue block8;
                }
                default: {
                    sb.append(part);
                }
            }
        }
        return sb.toString();
    }

    public Path(String ... name) {
        this.parts = new ArrayList<String>();
        for (String n : name) {
            this.parts.add(n);
        }
    }

    public Path(List<String> parent, String name) {
        this(parent);
        this.parts.add(name);
    }

    public Path(List<String> parts) {
        this.parts = new ArrayList<String>(parts);
    }

    public Path(Path path) {
        this.parts = new ArrayList<String>(path.parts);
    }

    public Path add(Path path) {
        Path ret = new Path(this);
        ret.parts.addAll(path.parts);
        return ret;
    }

    public Path add(String ... name) {
        Path ret = new Path(this);
        for (String n : name) {
            ret.parts.add(n);
        }
        return ret;
    }

    public Path add(List<String> names) {
        Path ret = new Path(this);
        ret.parts.addAll(names);
        return ret;
    }

    public Path getLast() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return new Path(this.parts.get(this.parts.size() - 1));
    }

    public Path getFirst() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return new Path(this.parts.get(0));
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public boolean hasParent() {
        return this.parts.size() >= 2;
    }

    public Path getParent() {
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        if (!copy.isEmpty()) {
            copy.remove(copy.size() - 1);
        }
        return new Path(copy);
    }

    public int hashCode() {
        if (this.cachedHashCode != null) {
            return this.cachedHashCode;
        }
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.parts);
        this.cachedHashCode = hash;
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.parts, other.parts);
    }

    public List<String> getParts() {
        return new ArrayList<String>(this.parts);
    }

    public int size() {
        return this.parts.size();
    }

    public Path get(int index) {
        return new Path(this.parts.get(index));
    }
}

