/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.RequiresNormalizedFonts;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.dynamictext.AdvancedTextRecord;
import com.jpexs.decompiler.flash.tags.dynamictext.CharacterWithStyle;
import com.jpexs.decompiler.flash.tags.dynamictext.DynamicTextModel;
import com.jpexs.decompiler.flash.tags.dynamictext.GlyphCharacter;
import com.jpexs.decompiler.flash.tags.dynamictext.Paragraph;
import com.jpexs.decompiler.flash.tags.dynamictext.SameStyleTextRecord;
import com.jpexs.decompiler.flash.tags.dynamictext.TextStyle;
import com.jpexs.decompiler.flash.tags.dynamictext.Word;
import com.jpexs.decompiler.flash.tags.enums.TextRenderMode;
import com.jpexs.decompiler.flash.tags.text.ParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextLexer;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.decompiler.flash.tags.text.xml.XmlException;
import com.jpexs.decompiler.flash.tags.text.xml.XmlLexer;
import com.jpexs.decompiler.flash.tags.text.xml.XmlParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.xml.XmlSymbolType;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.DynamicTextGlyphEntry;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SWFVersion(from=4)
public class DefineEditTextTag
extends TextTag {
    public static final int ID = 37;
    public static final String NAME = "DefineEditText";
    @SWFType(value=BasicType.UI16)
    public int characterID;
    public RECT bounds;
    public boolean hasText;
    public boolean wordWrap;
    public boolean multiline;
    public boolean password;
    public boolean readOnly;
    public boolean hasTextColor;
    public boolean hasMaxLength;
    public boolean hasFont;
    public boolean hasFontClass;
    public boolean autoSize;
    public boolean hasLayout;
    public boolean noSelect;
    public boolean border;
    public boolean wasStatic;
    public boolean html;
    public boolean useOutlines;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasFont"})
    public int fontId;
    @Conditional(value={"hasFontClass"})
    public String fontClass;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasFont|hasFontClass"})
    public int fontHeight;
    @Conditional(value={"hasTextColor"})
    public RGBA textColor;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasMaxLength"})
    public int maxLength;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"hasLayout"})
    @EnumValues(value={@EnumValue(value=0, text="Left"), @EnumValue(value=1, text="Right"), @EnumValue(value=2, text="Center"), @EnumValue(value=3, text="Justify")})
    public int align;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int leftMargin;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int rightMargin;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int indent;
    @SWFType(value=BasicType.SI16)
    @Conditional(value={"hasLayout"})
    public int leading;
    @DottedIdentifier
    public String variableName;
    @Conditional(value={"hasText"})
    @Multiline
    public String initialText;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUSTIFY = 3;

    public DefineEditTextTag(SWF swf) {
        super(swf, 37, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.bounds = new RECT();
        this.variableName = "";
    }

    public DefineEditTextTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 37, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public void removeCharacterGlyph(int glyphPos) {
        List<TEXTRECORD> recs = this.getTextRecords(this.getSwf());
        int pos = 0;
        for (TEXTRECORD r : recs) {
            if (!(r instanceof AdvancedTextRecord)) continue;
            AdvancedTextRecord atr = (AdvancedTextRecord)r;
            for (int htmlSourcePos : atr.htmlSourcePositions) {
                if (pos == glyphPos) {
                    int semiPos;
                    char character = this.initialText.charAt(htmlSourcePos);
                    if (character == '&' && (semiPos = this.initialText.indexOf(";", htmlSourcePos)) != -1) {
                        this.initialText = this.initialText.substring(0, htmlSourcePos) + this.initialText.substring(semiPos + 1);
                        return;
                    }
                    this.initialText = this.initialText.substring(0, htmlSourcePos) + this.initialText.substring(htmlSourcePos + 1);
                    this.packHtml();
                    this.setModified(true);
                    return;
                }
                ++pos;
            }
        }
    }

    private void packHtml() {
        try {
            XmlLexer lexer = new XmlLexer(new StringReader(this.initialText));
            XmlParsedSymbol s = lexer.yylex();
            String tagName = null;
            StringBuilder result = new StringBuilder();
            StringBuilder cached = new StringBuilder();
            boolean hasCharacter = false;
            while (s.type != XmlSymbolType.EOF) {
                if (s.type == XmlSymbolType.TAG_OPEN) {
                    if (tagName != null) {
                        result.append(cached.toString());
                    }
                    tagName = (String)s.value;
                    cached = new StringBuilder();
                    cached.append(s.rawText);
                    hasCharacter = false;
                } else if (s.type == XmlSymbolType.TAG_CLOSE) {
                    if (tagName != null) {
                        if (!"font".equals(tagName) || hasCharacter) {
                            cached.append(s.rawText);
                            result.append(cached.toString());
                        }
                    } else {
                        result.append(s.rawText);
                    }
                    tagName = null;
                } else if (s.type == XmlSymbolType.ATTRIBUTE || s.type == XmlSymbolType.ATTRIBUTE_VALUE || s.type == XmlSymbolType.TAG_OPEN_END) {
                    if (tagName != null) {
                        cached.append(s.rawText);
                    } else {
                        result.append(s.rawText);
                    }
                } else if (s.type == XmlSymbolType.CHARACTER) {
                    hasCharacter = true;
                    if (tagName != null) {
                        cached.append(s.rawText);
                    } else {
                        result.append(s.rawText);
                    }
                } else if (tagName != null) {
                    cached.append(s.rawText);
                } else {
                    result.append(s.rawText);
                }
                s = lexer.yylex();
            }
            this.initialText = result.toString();
        }
        catch (XmlException | IOException exception) {
            // empty catch block
        }
    }

    @Override
    public void insertCharacterGlyph(int glyphPos, char character) {
        int semiPos;
        List<TEXTRECORD> recs = this.getTextRecords(this.getSwf());
        int pos = 0;
        String str = "" + character;
        switch (character) {
            case '&': {
                str = "&amp;";
                break;
            }
            case '<': {
                str = "&lt;";
                break;
            }
            case '>': {
                str = "&gt;";
                break;
            }
            case '\u00a0': {
                str = "&nbsp;";
            }
        }
        int lastHtmlSourcePos = -1;
        for (TEXTRECORD r : recs) {
            if (!(r instanceof AdvancedTextRecord)) continue;
            AdvancedTextRecord atr = (AdvancedTextRecord)r;
            for (int htmlSourcePos : atr.htmlSourcePositions) {
                if (pos == glyphPos) {
                    this.initialText = this.initialText.substring(0, htmlSourcePos) + str + this.initialText.substring(htmlSourcePos);
                    this.setModified(true);
                    return;
                }
                lastHtmlSourcePos = htmlSourcePos;
                ++pos;
            }
        }
        if (lastHtmlSourcePos == -1) {
            this.initialText = str + this.initialText;
            return;
        }
        int newHtmlSourcePos = lastHtmlSourcePos + 1;
        char prevCharacter = this.initialText.charAt(lastHtmlSourcePos);
        if (character == '&' && (semiPos = this.initialText.indexOf(";", lastHtmlSourcePos)) != -1) {
            newHtmlSourcePos = semiPos + 1;
        }
        this.initialText = this.initialText.substring(0, newHtmlSourcePos) + str + this.initialText.substring(newHtmlSourcePos);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bounds = sis.readRECT("bounds");
        this.hasText = sis.readUB(1, "hasText") == 1L;
        this.wordWrap = sis.readUB(1, "wordWrap") == 1L;
        this.multiline = sis.readUB(1, "multiline") == 1L;
        this.password = sis.readUB(1, "password") == 1L;
        this.readOnly = sis.readUB(1, "readOnly") == 1L;
        this.hasTextColor = sis.readUB(1, "hasTextColor") == 1L;
        this.hasMaxLength = sis.readUB(1, "hasMaxLength") == 1L;
        this.hasFont = sis.readUB(1, "hasFont") == 1L;
        this.hasFontClass = sis.readUB(1, "hasFontClass") == 1L;
        this.autoSize = sis.readUB(1, "autoSize") == 1L;
        this.hasLayout = sis.readUB(1, "hasLayout") == 1L;
        this.noSelect = sis.readUB(1, "noSelect") == 1L;
        this.border = sis.readUB(1, "border") == 1L;
        this.wasStatic = sis.readUB(1, "wasStatic") == 1L;
        this.html = sis.readUB(1, "html") == 1L;
        boolean bl = this.useOutlines = sis.readUB(1, "useOutlines") == 1L;
        if (this.hasFont) {
            this.fontId = sis.readUI16("fontId");
        }
        if (this.hasFontClass) {
            this.fontClass = sis.readString("fontClass");
        }
        if (this.hasFont || this.hasFontClass) {
            this.fontHeight = sis.readUI16("fontHeight");
        }
        if (this.hasTextColor) {
            this.textColor = sis.readRGBA("textColor");
        }
        if (this.hasMaxLength) {
            this.maxLength = sis.readUI16("maxLength");
        }
        if (this.hasLayout) {
            this.align = sis.readUI8("align");
            this.leftMargin = sis.readUI16("leftMargin");
            this.rightMargin = sis.readUI16("rightMargin");
            this.indent = sis.readUI16("indent");
            this.leading = sis.readSI16("leading");
        }
        this.variableName = sis.readString("variableName");
        if (this.hasText) {
            this.initialText = sis.readString("initialText");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeRECT(this.bounds);
        sos.writeUB(1, this.hasText ? 1L : 0L);
        sos.writeUB(1, this.wordWrap ? 1L : 0L);
        sos.writeUB(1, this.multiline ? 1L : 0L);
        sos.writeUB(1, this.password ? 1L : 0L);
        sos.writeUB(1, this.readOnly ? 1L : 0L);
        sos.writeUB(1, this.hasTextColor ? 1L : 0L);
        sos.writeUB(1, this.hasMaxLength ? 1L : 0L);
        sos.writeUB(1, this.hasFont ? 1L : 0L);
        sos.writeUB(1, this.hasFontClass ? 1L : 0L);
        sos.writeUB(1, this.autoSize ? 1L : 0L);
        sos.writeUB(1, this.hasLayout ? 1L : 0L);
        sos.writeUB(1, this.noSelect ? 1L : 0L);
        sos.writeUB(1, this.border ? 1L : 0L);
        sos.writeUB(1, this.wasStatic ? 1L : 0L);
        sos.writeUB(1, this.html ? 1L : 0L);
        sos.writeUB(1, this.useOutlines ? 1L : 0L);
        if (this.hasFont) {
            sos.writeUI16(this.fontId);
        }
        if (this.hasFontClass) {
            sos.writeString(this.fontClass);
        }
        if (this.hasFont || this.hasFontClass) {
            sos.writeUI16(this.fontHeight);
        }
        if (this.hasTextColor) {
            sos.writeRGBA(this.textColor);
        }
        if (this.hasMaxLength) {
            sos.writeUI16(this.maxLength);
        }
        if (this.hasLayout) {
            sos.writeUI8(this.align);
            sos.writeUI16(this.leftMargin);
            sos.writeUI16(this.rightMargin);
            sos.writeUI16(this.indent);
            sos.writeSI16(this.leading);
        }
        sos.writeString(this.variableName);
        if (this.hasText) {
            sos.writeString(this.initialText);
        }
    }

    @Override
    public RECT getBounds() {
        return this.bounds;
    }

    @Override
    public MATRIX getTextMatrix() {
        MATRIX matrix = new MATRIX();
        matrix.translateX = this.bounds.Xmin;
        matrix.translateY = this.bounds.Ymin;
        return matrix;
    }

    @Override
    public void setBounds(RECT r) {
        this.bounds = r;
    }

    private String stripTags(String inp) {
        boolean intag = false;
        String outp = "";
        inp = inp.replaceAll("<br ?/?>", "\r\n");
        for (int i = 0; i < inp.length(); ++i) {
            if (!intag && inp.charAt(i) == '<') {
                intag = true;
                continue;
            }
            if (intag && inp.charAt(i) == '>') {
                intag = false;
                continue;
            }
            if (intag) continue;
            outp = outp + inp.charAt(i);
        }
        return outp;
    }

    private String entitiesReplace(String s) {
        s = s.replace("&lt;", "<");
        s = s.replace("&gt;", ">");
        s = s.replace("&amp;", "&");
        s = s.replace("&quot;", "\"");
        return s;
    }

    @Override
    public List<String> getTexts() {
        String ret = "";
        if (this.hasText) {
            ret = this.initialText;
        }
        if (this.html) {
            ret = this.stripTags(ret);
            ret = this.entitiesReplace(ret);
        }
        return Arrays.asList(ret);
    }

    /*
     * Unable to fully structure code
     */
    private List<CharacterWithStyle> getTextWithStyle() {
        block64: {
            block65: {
                if (this.swf == null) {
                    return new ArrayList<CharacterWithStyle>();
                }
                str = "";
                style = new TextStyle();
                style.font = this.fontClass != null ? this.swf.getFontByClass(this.fontClass) : this.swf.getFont(this.fontId);
                style.fontHeight = this.fontHeight;
                style.fontLeading = this.leading;
                if (this.hasTextColor) {
                    style.textColor = this.textColor;
                }
                if (this.hasText) {
                    str = this.initialText;
                }
                style.leftMargin = this.leftMargin;
                ret = new ArrayList<CharacterWithStyle>();
                if (!this.html) break block65;
                styles = new Stack<TextStyle>();
                styles.add(style);
                lexer = new XmlLexer(new StringReader(str));
                try {
                    s = lexer.yylex();
                    inOpenTag = false;
                    attributeName = null;
                    tagName = null;
                    attributes = new LinkedHashMap<String, String>();
                    block47: while (s.type != XmlSymbolType.EOF) {
                        switch (1.$SwitchMap$com$jpexs$decompiler$flash$tags$text$xml$XmlSymbolType[s.type.ordinal()]) {
                            case 1: {
                                inOpenTag = true;
                                attributeName = null;
                                tagName = (String)s.value;
                                attributes.clear();
                                ** GOTO lbl196
                            }
                            case 2: {
                                attributeName = (String)s.value;
                                ** GOTO lbl196
                            }
                            case 3: {
                                if (attributeName == null) break;
                                attributes.put(attributeName, this.unescape((String)s.value));
                                ** GOTO lbl196
                            }
                            case 4: {
                                style = (TextStyle)styles.peek();
                                var11_13 = tagName;
                                var12_14 = -1;
                                switch (var11_13.hashCode()) {
                                    case 112: {
                                        if (!var11_13.equals("p")) break;
                                        var12_14 = 0;
                                        break;
                                    }
                                    case 97: {
                                        if (!var11_13.equals("a")) break;
                                        var12_14 = 1;
                                        break;
                                    }
                                    case 98: {
                                        if (!var11_13.equals("b")) break;
                                        var12_14 = 2;
                                        break;
                                    }
                                    case 105: {
                                        if (!var11_13.equals("i")) break;
                                        var12_14 = 3;
                                        break;
                                    }
                                    case 117: {
                                        if (!var11_13.equals("u")) break;
                                        var12_14 = 4;
                                        break;
                                    }
                                    case 3148879: {
                                        if (!var11_13.equals("font")) break;
                                        var12_14 = 5;
                                        break;
                                    }
                                    case 3152: {
                                        if (!var11_13.equals("br")) break;
                                        var12_14 = 6;
                                        break;
                                    }
                                    case 113667: {
                                        if (!var11_13.equals("sbr")) break;
                                        var12_14 = 7;
                                    }
                                }
                                switch (var12_14) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        style = style.clone();
                                        style.bold = true;
                                        styles.add(style);
                                        break;
                                    }
                                    case 3: {
                                        style = style.clone();
                                        style.italic = true;
                                        styles.add(style);
                                        break;
                                    }
                                    case 4: {
                                        style = style.clone();
                                        style.underlined = true;
                                        styles.add(style);
                                        break;
                                    }
                                    case 5: {
                                        style = style.clone();
                                        color = (String)attributes.get("color");
                                        if (color != null && color.startsWith("#")) {
                                            try {
                                                if (color.length() == 7) {
                                                    style.textColor = new RGBA(Color.decode(color));
                                                } else if (color.length() == 9) {
                                                    style.textColor = RGBA.fromHexARGB(color);
                                                    style.textColor.alpha = 255;
                                                }
                                            }
                                            catch (NumberFormatException var14_19) {
                                                // empty catch block
                                            }
                                        }
                                        if ((size = (String)attributes.get("size")) != null && size.length() > 0) {
                                            try {
                                                firstChar = size.charAt(0);
                                                if (firstChar != '+' && firstChar != '-') {
                                                    fontSize = Integer.parseInt(size);
                                                    style.fontHeight = (int)Math.round((double)fontSize * 20.0);
                                                } else {
                                                    fontSizeDelta = (int)Math.round((double)Integer.parseInt(size.substring(1)) * 20.0);
                                                    style.fontHeight = firstChar == '+' ? (style.fontHeight += fontSizeDelta) : (style.fontHeight -= fontSizeDelta);
                                                }
                                                style.fontLeading = this.leading;
                                            }
                                            catch (NumberFormatException firstChar) {
                                                // empty catch block
                                            }
                                        }
                                        if ((face = (String)attributes.get("face")) != null && face.length() > 0) {
                                            style.fontFace = face;
                                        }
                                        if ((letterspacing = (String)attributes.get("letterSpacing")) != null && letterspacing.length() > 0) {
                                            try {
                                                style.letterSpacing = Double.parseDouble(letterspacing);
                                            }
                                            catch (NumberFormatException var17_26) {
                                                // empty catch block
                                            }
                                        }
                                        if ((kerning = (String)attributes.get("kerning")) != null && kerning.length() > 0) {
                                            style.kerning = kerning.equals("1");
                                        }
                                        styles.add(style);
                                        break;
                                    }
                                    case 6: 
                                    case 7: {
                                        cs = new CharacterWithStyle();
                                        cs.character = (char)10;
                                        cs.style = style;
                                        ret.add(cs);
                                    }
                                }
                                tagName = null;
                                ** GOTO lbl196
                            }
                            case 5: {
                                var11_13 = tagName = (String)s.value;
                                var12_15 = -1;
                                switch (var11_13.hashCode()) {
                                    case 98: {
                                        if (!var11_13.equals("b")) break;
                                        var12_15 = 0;
                                        break;
                                    }
                                    case 105: {
                                        if (!var11_13.equals("i")) break;
                                        var12_15 = 1;
                                        break;
                                    }
                                    case 117: {
                                        if (!var11_13.equals("u")) break;
                                        var12_15 = 2;
                                        break;
                                    }
                                    case 3148879: {
                                        if (!var11_13.equals("font")) break;
                                        var12_15 = 3;
                                        break;
                                    }
                                    case 112: {
                                        if (!var11_13.equals("p")) break;
                                        var12_15 = 4;
                                    }
                                }
                                switch (var12_15) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        styles.pop();
                                        break;
                                    }
                                    case 4: {
                                        style = (TextStyle)styles.peek();
                                        cs = new CharacterWithStyle();
                                        cs.character = (char)10;
                                        cs.style = style;
                                        ret.add(cs);
                                    }
                                }
                                tagName = null;
                                ** GOTO lbl196
                            }
                            case 6: 
                            case 7: {
                                txt = (String)s.value;
                                if (s.type == XmlSymbolType.ENTITY) {
                                    txt = this.unescape("&" + txt + ";");
                                }
                                style = (TextStyle)styles.peek();
                                if (style.fontFace != null && this.useOutlines) {
                                    ct = this.swf.getCharacterByExportName(style.fontFace);
                                    style.font = ct != null && ct instanceof FontTag != false ? (FontTag)ct : this.swf.getFontByNameInTag(style.fontFace, style.bold, style.italic);
                                    if (style.font == null) {
                                        style.fontFace = null;
                                    }
                                }
                                this.addCharacters(ret, txt, style, s.position);
                            }
lbl196:
                            // 7 sources

                            default: {
                                s = lexer.yylex();
                                continue block47;
                            }
                        }
                    }
                    break block64;
                }
                catch (IOException var6_7) {
                }
                catch (XmlException var6_8) {}
                break block64;
            }
            this.addCharacters(ret, str, style, 0);
        }
        return ret;
    }

    private void addCharacters(List<CharacterWithStyle> list, String str, TextStyle style, int position) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            CharacterWithStyle cs = new CharacterWithStyle();
            cs.character = ch;
            cs.style = style;
            if (position > -1) {
                cs.htmlSourcePosition = position + i;
            }
            list.add(cs);
        }
    }

    @Override
    public List<Integer> getFontIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(this.fontId);
        return ret;
    }

    @Override
    public HighlightedText getFormattedText(boolean ignoreLetterSpacing) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        writer.append("[");
        String[] alignNames = new String[]{"left", "right", "center", "justify"};
        String alignment = this.align < alignNames.length ? alignNames[this.align] : "unknown";
        writer.newLine();
        writer.append("xmin ").append(this.bounds.Xmin).newLine();
        writer.append("ymin ").append(this.bounds.Ymin).newLine();
        writer.append("xmax ").append(this.bounds.Xmax).newLine();
        writer.append("ymax ").append(this.bounds.Ymax).newLine();
        if (this.wordWrap) {
            writer.append("wordwrap 1").newLine();
        }
        if (this.multiline) {
            writer.append("multiline 1").newLine();
        }
        if (this.password) {
            writer.append("password 1").newLine();
        }
        if (this.readOnly) {
            writer.append("readonly 1").newLine();
        }
        if (this.autoSize) {
            writer.append("autosize 1").newLine();
        }
        if (this.noSelect) {
            writer.append("noselect 1").newLine();
        }
        if (this.border) {
            writer.append("border 1").newLine();
        }
        if (this.wasStatic) {
            writer.append("wasstatic 1").newLine();
        }
        if (this.html) {
            writer.append("html 1").newLine();
        }
        if (this.useOutlines) {
            writer.append("useoutlines 1").newLine();
        }
        if (this.hasFont) {
            writer.append("font ").append(this.fontId).newLine();
            writer.append("height ").append(this.fontHeight).newLine();
        }
        if (this.hasTextColor) {
            writer.append("color ").append(this.textColor.toHexARGB()).newLine();
        }
        if (this.hasFontClass) {
            writer.append("fontclass ").append(this.fontClass).newLine();
        }
        if (this.hasMaxLength) {
            writer.append("maxlength ").append(this.maxLength).newLine();
        }
        writer.append("align ").append(alignment).newLine();
        if (this.hasLayout) {
            writer.append("leftmargin ").append(this.leftMargin).newLine();
            writer.append("rightmargin ").append(this.rightMargin).newLine();
            writer.append("indent ").append(this.indent).newLine();
            writer.append("leading ").append(this.leading).newLine();
        }
        if (!this.variableName.isEmpty()) {
            writer.append("variablename ").append("\"").append(Helper.escapePCodeString(this.variableName)).append("\"").newLine();
        }
        writer.append("]");
        if (this.hasText) {
            String text = this.initialText.replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]");
            writer.hilightSpecial(text, HighlightSpecialType.TEXT);
        }
        writer.finishHilights();
        return new HighlightedText(writer);
    }

    @Override
    public boolean setFormattedText(MissingCharacterHandler missingCharHandler, String formattedText, String[] texts) throws TextParseException {
        try {
            ParsedSymbol s;
            TextLexer lexer = new TextLexer(new StringReader(formattedText));
            formattedText = "";
            RECT bounds = new RECT(this.bounds);
            boolean wordWrap = false;
            boolean multiline = false;
            boolean password = false;
            boolean readOnly = false;
            boolean autoSize = false;
            boolean noSelect = false;
            boolean border = false;
            boolean wasStatic = false;
            boolean html = false;
            boolean useOutlines = false;
            int fontId = -1;
            int fontHeight = -1;
            String fontClass = null;
            RGBA textColor = null;
            int maxLength = -1;
            int align = -1;
            int leftMargin = -1;
            int rightMargin = -1;
            int indent = -1;
            int leading = -1;
            String variableName = null;
            int textIdx = 0;
            block94: while ((s = lexer.yylex()) != null) {
                block12 : switch (s.type) {
                    case PARAMETER_IDENTIFIER: {
                        String paramName = (String)s.value;
                        s = lexer.yylex();
                        String paramValue = (String)s.value;
                        switch (paramName) {
                            case "xmin": {
                                try {
                                    bounds.Xmin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymin": {
                                try {
                                    bounds.Ymin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmax": {
                                try {
                                    bounds.Xmax = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmax value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymax": {
                                try {
                                    bounds.Ymax = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymax value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "wordwrap": {
                                if (!paramValue.equals("1")) continue block94;
                                wordWrap = true;
                                break block12;
                            }
                            case "multiline": {
                                if (!paramValue.equals("1")) continue block94;
                                multiline = true;
                                break block12;
                            }
                            case "password": {
                                if (!paramValue.equals("1")) continue block94;
                                password = true;
                                break block12;
                            }
                            case "readonly": {
                                if (!paramValue.equals("1")) continue block94;
                                readOnly = true;
                                break block12;
                            }
                            case "autosize": {
                                if (!paramValue.equals("1")) continue block94;
                                autoSize = true;
                                break block12;
                            }
                            case "noselect": {
                                if (!paramValue.equals("1")) continue block94;
                                noSelect = true;
                                break block12;
                            }
                            case "border": {
                                if (!paramValue.equals("1")) continue block94;
                                border = true;
                                break block12;
                            }
                            case "wasstatic": {
                                if (!paramValue.equals("1")) continue block94;
                                wasStatic = true;
                                break block12;
                            }
                            case "html": {
                                if (!paramValue.equals("1")) continue block94;
                                html = true;
                                break block12;
                            }
                            case "useoutlines": {
                                if (!paramValue.equals("1")) continue block94;
                                useOutlines = true;
                                break block12;
                            }
                            case "font": {
                                try {
                                    fontId = Integer.parseInt(paramValue);
                                    FontTag ft = this.swf.getFont(fontId);
                                    if (ft == null) {
                                        throw new TextParseException("Font not found.", lexer.yyline());
                                    }
                                    this.hasFont = true;
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid font value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "fontclass": {
                                fontClass = paramValue;
                                break block12;
                            }
                            case "height": {
                                try {
                                    fontHeight = Integer.parseInt(paramValue);
                                    this.hasFont = true;
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid height value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "color": {
                                Matcher m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                if (m.matches()) {
                                    textColor = new RGBA(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
                                    break block12;
                                }
                                throw new TextParseException("Invalid color. Valid format is #aarrggbb. Found: " + paramValue, lexer.yyline());
                            }
                            case "maxlength": {
                                try {
                                    maxLength = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid maxLength value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "align": {
                                switch (paramValue) {
                                    case "left": {
                                        align = 0;
                                        break block12;
                                    }
                                    case "right": {
                                        align = 1;
                                        break block12;
                                    }
                                    case "center": {
                                        align = 2;
                                        break block12;
                                    }
                                    case "justify": {
                                        align = 3;
                                        break block12;
                                    }
                                }
                                throw new TextParseException("Invalid align value. Expected one of: left,right,center or justify. Found: " + paramValue, lexer.yyline());
                            }
                            case "leftmargin": {
                                try {
                                    leftMargin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid leftmargin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rightmargin": {
                                try {
                                    rightMargin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid rightmargin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "indent": {
                                try {
                                    indent = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid indent value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "leading": {
                                try {
                                    leading = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid leading value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "variablename": {
                                variableName = paramValue;
                                break block12;
                            }
                            default: {
                                throw new TextParseException("Unrecognized parameter name: " + paramName, lexer.yyline());
                            }
                        }
                    }
                    case TEXT: {
                        String s2 = (String)s.value;
                        if (s2 == null) {
                            s2 = "";
                        }
                        formattedText = formattedText + (texts == null || textIdx >= texts.length ? s2 : texts[textIdx++]);
                        formattedText = formattedText.replace("\r\n", "\r");
                    }
                }
            }
            this.setModified(true);
            this.bounds = bounds;
            if (formattedText.length() > 0) {
                this.initialText = formattedText;
                this.hasText = true;
            } else {
                this.hasText = false;
            }
            this.wordWrap = wordWrap;
            this.multiline = multiline;
            this.password = password;
            this.readOnly = readOnly;
            this.noSelect = noSelect;
            this.border = border;
            this.wasStatic = wasStatic;
            this.html = html;
            this.useOutlines = useOutlines;
            if (textColor != null) {
                this.hasTextColor = true;
                this.textColor = textColor;
            } else {
                this.hasTextColor = false;
            }
            if (maxLength > -1) {
                this.maxLength = maxLength;
                this.hasMaxLength = true;
            } else {
                this.hasMaxLength = false;
            }
            if (fontId > -1) {
                this.fontId = fontId;
            }
            if (fontHeight > -1) {
                this.fontHeight = fontHeight;
            }
            if (fontClass != null) {
                this.fontClass = fontClass;
                this.hasFontClass = true;
            } else {
                this.hasFontClass = false;
            }
            this.autoSize = autoSize;
            this.align = align;
            if (leftMargin > -1 || rightMargin > -1 || indent > -1 || leading > -1) {
                this.leftMargin = leftMargin;
                this.rightMargin = rightMargin;
                this.indent = indent;
                this.leading = leading;
                this.hasLayout = true;
            } else {
                this.hasLayout = false;
            }
            if (variableName == null) {
                variableName = "";
            }
            this.variableName = variableName;
        }
        catch (IOException ex) {
            Logger.getLogger(DefineEditTextTag.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    @Override
    public void updateTextBounds() {
    }

    @Override
    public boolean alignText(TextAlign textAlign) {
        return true;
    }

    @Override
    public boolean translateText(int diff) {
        return true;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.bounds;
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        if (this.hasFont) {
            needed.add(this.fontId);
        }
        if (this.hasFontClass) {
            neededClasses.add(this.fontClass);
        }
        if (this.html && this.hasText) {
            List<CharacterWithStyle> chs = this.getTextWithStyle();
            for (CharacterWithStyle ch : chs) {
                if (ch.style.font == null) continue;
                int subFontId = swf.getCharacterId(ch.style.font);
                if (subFontId != -1) {
                    needed.add(subFontId);
                    continue;
                }
                neededClasses.addAll(ch.style.font.getClassNames());
            }
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        if (this.fontId == oldCharacterId) {
            this.fontId = newCharacterId;
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        if (this.fontId == characterId) {
            this.hasFont = false;
            this.fontId = 0;
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        this.render(TextRenderMode.BITMAP, image, null, null, transformation, colorTransform, 1.0, renderContext.selectionText == this ? renderContext.selectionStart : 0, renderContext.selectionText == this ? renderContext.selectionEnd : 0, aaScale);
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) {
        int realTextId = this.getSwf().getCharacterId(this);
        if (exporter.getNormalizedTexts().containsKey(realTextId) && exporter.getNormalizedTexts().get(realTextId) instanceof DefineEditTextTag) {
            DefineEditTextTag normalizedText = (DefineEditTextTag)exporter.getNormalizedTexts().get(realTextId);
            normalizedText.render(TextRenderMode.SVG, null, exporter, null, new Matrix(), colorTransform, 1.0, 0, 0, 1);
            return;
        }
        this.render(TextRenderMode.SVG, null, exporter, null, new Matrix(), colorTransform, 1.0, 0, 0, 1);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        this.render(TextRenderMode.HTML5_CANVAS, null, null, result, new Matrix(), null, unitDivisor, 0, 0, 1);
    }

    private void render(TextRenderMode renderMode, SerializableImage image, SVGExporter svgExporter, StringBuilder htmlCanvasBuilder, Matrix transformation, ColorTransform colorTransform, double zoom, int selectionStart, int selectionEnd, int aaScale) {
        int realTextId;
        RequiresNormalizedFonts g;
        Map<Integer, TextTag> normalizedTexts;
        if (image != null && image.getGraphics() instanceof RequiresNormalizedFonts && (normalizedTexts = (g = (RequiresNormalizedFonts)((Object)image.getGraphics())).getNormalizedTexts()).containsKey(realTextId = this.getSwf().getCharacterId(this)) && normalizedTexts.get(realTextId) instanceof DefineEditTextTag && normalizedTexts.get(realTextId) != this) {
            DefineEditTextTag normalizedText = (DefineEditTextTag)normalizedTexts.get(realTextId);
            normalizedText.render(renderMode, image, svgExporter, htmlCanvasBuilder, transformation, colorTransform, zoom, selectionStart, selectionEnd, aaScale);
            return;
        }
        if (this.border) {
            RGBA borderColor = new RGBA(Color.black);
            RGBA fillColor = new RGBA(Color.white);
            switch (renderMode) {
                case BITMAP: {
                    DefineEditTextTag.drawBorder(this.swf, image, borderColor, fillColor, this.getRect(), this.getTextMatrix(), transformation, colorTransform, aaScale);
                    break;
                }
                case HTML5_CANVAS: {
                    DefineEditTextTag.drawBorderHtmlCanvas(this.swf, htmlCanvasBuilder, borderColor, fillColor, this.getRect(), this.getTextMatrix(), colorTransform, zoom);
                    break;
                }
                case SVG: {
                    DefineEditTextTag.drawBorderSVG(this.swf, svgExporter, borderColor, fillColor, this.getRect(), this.getTextMatrix(), transformation, colorTransform, zoom);
                }
            }
        }
        if (this.hasText) {
            List<TEXTRECORD> allTextRecords = this.getTextRecords(this.swf);
            switch (renderMode) {
                case BITMAP: {
                    DefineEditTextTag.staticTextToImage(this.swf, allTextRecords, 2, image, this.getTextMatrix(), transformation, colorTransform, selectionStart, selectionEnd, aaScale);
                    break;
                }
                case HTML5_CANVAS: {
                    DefineEditTextTag.staticTextToHtmlCanvas(zoom, this.swf, allTextRecords, 2, htmlCanvasBuilder, this.getBounds(), this.getTextMatrix(), colorTransform);
                    break;
                }
                case SVG: {
                    DefineEditTextTag.staticTextToSVG(this.swf, allTextRecords, 2, svgExporter, this.getBounds(), this.getTextMatrix(), colorTransform, zoom, transformation);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<TEXTRECORD> getTextRecords(SWF swf) {
        ArrayList line;
        ArrayList lines;
        DynamicTextModel textModel = new DynamicTextModel();
        List<CharacterWithStyle> txt = this.getTextWithStyle();
        TextStyle lastStyle = null;
        char prevChar = '\u0000';
        boolean lastWasWhiteSpace = false;
        for (int i = 0; i < txt.size(); ++i) {
            CharacterWithStyle cs = txt.get(i);
            char c = cs.character;
            if (c != '\r' && c != '\n') {
                void var10_12;
                int fontStyle;
                if (lastWasWhiteSpace && !Character.isWhitespace(c)) {
                    textModel.newWord();
                    lastWasWhiteSpace = false;
                }
                if (cs.style != lastStyle) {
                    textModel.style = lastStyle = cs.style;
                    textModel.newRecord();
                }
                Object var10_13 = null;
                if (i + 1 < txt.size()) {
                    Character c2 = Character.valueOf(txt.get((int)(i + 1)).character);
                }
                FontTag font = lastStyle.font;
                DynamicTextGlyphEntry ge = new DynamicTextGlyphEntry();
                ge.fontFace = lastStyle.fontFace;
                if (ge.fontFace == null && font != null) {
                    ge.fontFace = font.getFontNameIntag();
                }
                ge.fontStyle = (lastStyle.bold ? 1 : 0) | (lastStyle.italic ? 2 : 0);
                ge.character = c;
                ge.glyphIndex = this.useOutlines && font != null ? font.charToGlyph(c) : -1;
                String fontName = ge.fontFace != null ? ge.fontFace : FontTag.getDefaultFontName();
                int n = fontStyle = font == null ? ge.fontStyle : font.getFontStyle();
                ge.glyphAdvance = ge.glyphIndex == -1 ? (int)Math.round(20.0 * (double)FontTag.getSystemFontAdvance(fontName, fontStyle, (int)((double)lastStyle.fontHeight / 20.0), Character.valueOf(c), lastStyle.kerning ? var10_12 : null)) : (int)Math.round(font.getGlyphAdvance(ge.glyphIndex) / font.getDivider() * (double)lastStyle.fontHeight / 1024.0);
                ge.glyphAdvance = (int)((double)ge.glyphAdvance + lastStyle.letterSpacing * 20.0);
                if (this.useOutlines && lastStyle.kerning && font != null && font.hasLayout() && var10_12 != null) {
                    ge.glyphAdvance = (int)((double)ge.glyphAdvance + (double)font.getCharKerningAdjustment(c, var10_12.charValue()) / font.getDivider());
                }
                textModel.addGlyph(c, ge, cs.htmlSourcePosition);
                if (Character.isWhitespace(c)) {
                    lastWasWhiteSpace = true;
                }
            } else if (this.multiline) {
                textModel.newParagraph();
            }
            prevChar = c;
        }
        textModel.calculateTextWidths();
        HashSet<Integer> noIndentLineIndices = new HashSet<Integer>();
        if (this.multiline && this.wordWrap) {
            lines = new ArrayList();
            for (Paragraph paragraph : textModel.paragraphs) {
                line = new ArrayList();
                int lineLength = 0;
                for (Word word : paragraph.words) {
                    int indentVal = noIndentLineIndices.contains(lines.size()) ? 0 : this.indent;
                    int maxLineWidth = this.bounds.getWidth() - this.leftMargin - indentVal;
                    if (word.width > maxLineWidth) {
                        ArrayList<SameStyleTextRecord> recs = new ArrayList<SameStyleTextRecord>();
                        for (int i = 0; i < word.records.size(); ++i) {
                            SameStyleTextRecord rec = word.records.get(i);
                            for (int g = 0; g < rec.glyphEntries.size(); ++g) {
                                GlyphCharacter gc = rec.glyphEntries.get(g);
                                int ga = gc.glyphEntry.glyphAdvance;
                                indentVal = noIndentLineIndices.contains(lines.size()) ? 0 : this.indent;
                                maxLineWidth = this.bounds.getWidth() - this.leftMargin - indentVal;
                                if (lineLength + ga > maxLineWidth) {
                                    recs.add(rec);
                                    line.addAll(recs);
                                    lines.add(line);
                                    recs = new ArrayList();
                                    SameStyleTextRecord rec2 = new SameStyleTextRecord();
                                    rec2.style = rec.style.clone();
                                    rec2.glyphEntries = new ArrayList<GlyphCharacter>();
                                    int glen = rec.glyphEntries.size();
                                    for (int g2 = g; g2 < glen; ++g2) {
                                        rec2.glyphEntries.add(rec.glyphEntries.remove(g));
                                    }
                                    rec2.calculateTextWidths();
                                    rec.calculateTextWidths();
                                    rec = rec2;
                                    g = 0;
                                    noIndentLineIndices.add(lines.size());
                                    line = new ArrayList();
                                    lineLength = 0;
                                }
                                lineLength += ga;
                            }
                            recs.add(rec);
                        }
                        if (recs.isEmpty()) continue;
                        line.addAll(recs);
                        continue;
                    }
                    if (lineLength + word.width <= maxLineWidth) {
                        line.addAll(word.records);
                        lineLength += word.width;
                        continue;
                    }
                    lines.add(line);
                    noIndentLineIndices.add(lines.size());
                    line = new ArrayList();
                    line.addAll(word.records);
                    lineLength = 0;
                }
                if (line.isEmpty()) continue;
                lines.add(line);
            }
        } else {
            lines = new ArrayList();
            for (Paragraph paragraph : textModel.paragraphs) {
                line = new ArrayList();
                for (Word word : paragraph.words) {
                    for (SameStyleTextRecord tr : word.records) {
                        line.add(tr);
                    }
                }
                lines.add(line);
            }
        }
        for (List list : lines) {
            boolean removed = true;
            while (removed) {
                removed = false;
                while (list.size() > 0 && ((SameStyleTextRecord)list.get((int)(list.size() - 1))).glyphEntries.isEmpty()) {
                    list.remove(list.size() - 1);
                    removed = true;
                }
                if (list.size() <= 0) continue;
                SameStyleTextRecord lastRecord = (SameStyleTextRecord)list.get(list.size() - 1);
                while (lastRecord.glyphEntries.size() > 0 && Character.isWhitespace(lastRecord.glyphEntries.get((int)(lastRecord.glyphEntries.size() - 1)).character)) {
                    lastRecord.glyphEntries.remove(lastRecord.glyphEntries.size() - 1);
                    removed = true;
                }
            }
        }
        textModel.calculateTextWidths();
        ArrayList<TEXTRECORD> allTextRecords = new ArrayList<TEXTRECORD>();
        boolean bl = false;
        int yOffset = 0;
        boolean firstLine = true;
        for (int k = 0; k < lines.size(); ++k) {
            int n;
            List line3 = (List)lines.get(k);
            int width = 0;
            int currentOffset = 0;
            if (line3.isEmpty()) {
                currentOffset = n;
            } else {
                for (SameStyleTextRecord tr : line3) {
                    int lineHeight;
                    width += tr.width;
                    int n2 = lineHeight = this.useOutlines && tr.style.font != null && tr.style.font.hasLayout() ? (int)Math.round((double)(tr.style.fontHeight * tr.style.font.getAscent()) / tr.style.font.getDivider() / 1024.0) + tr.style.fontLeading : tr.style.fontHeight + tr.style.fontLeading;
                    if (this.useOutlines && tr.style.font != null && !firstLine && tr.style.font.hasLayout()) {
                        lineHeight += (int)Math.round((double)(tr.style.fontHeight * tr.style.font.getDescent()) / tr.style.font.getDivider() / 1024.0);
                    }
                    n = lineHeight;
                    if (lineHeight <= currentOffset) continue;
                    currentOffset = lineHeight;
                }
            }
            firstLine = false;
            yOffset += currentOffset;
            int alignOffset = 0;
            int currentIndent = 0;
            if (!noIndentLineIndices.contains(k)) {
                currentIndent = this.indent;
            }
            switch (this.align) {
                case 0: {
                    alignOffset = 0;
                    break;
                }
                case 1: {
                    alignOffset = this.bounds.getWidth() - width - this.leftMargin - currentIndent;
                    break;
                }
                case 2: {
                    alignOffset = (this.bounds.getWidth() - width - this.leftMargin - currentIndent) / 2;
                    break;
                }
            }
            for (SameStyleTextRecord tr : line3) {
                tr.xOffset = alignOffset;
                alignOffset += tr.width;
            }
            for (SameStyleTextRecord tr : line3) {
                tr.xOffset = (int)((double)tr.xOffset + tr.style.leftMargin);
                tr.xOffset += currentIndent;
            }
            for (SameStyleTextRecord tr : line3) {
                AdvancedTextRecord tr2 = new AdvancedTextRecord();
                int fid = this.fontId;
                if (this.fontClass != null) {
                    tr2.fontClass = this.fontClass;
                }
                if (tr.style.font != null) {
                    fid = swf.getCharacterId(tr.style.font);
                }
                tr2.styleFlagsHasFont = fid != 0;
                tr2.fontId = fid;
                tr2.textHeight = tr.style.fontHeight;
                if (tr.style.textColor != null) {
                    tr2.styleFlagsHasColor = true;
                    tr2.textColorA = tr.style.textColor;
                }
                tr2.styleFlagsHasXOffset = true;
                tr2.xOffset = tr.xOffset;
                if (yOffset != 0) {
                    tr2.styleFlagsHasYOffset = true;
                    tr2.yOffset = yOffset;
                }
                tr2.glyphEntries = new ArrayList(tr.glyphEntries.size());
                tr2.htmlSourcePositions = new ArrayList<Integer>(tr.glyphEntries.size());
                for (GlyphCharacter ge : tr.glyphEntries) {
                    tr2.glyphEntries.add(ge.glyphEntry);
                    tr2.htmlSourcePositions.add(ge.htmlSourcePosition);
                }
                allTextRecords.add(tr2);
            }
        }
        return allTextRecords;
    }

    @Override
    public ExportRectangle calculateTextBounds() {
        return null;
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    private String unescape(String txt) {
        if (txt == null) {
            return null;
        }
        txt = txt.replace("&nbsp;", "\u00a0");
        txt = txt.replace("&lt;", "<");
        txt = txt.replace("&gt;", ">");
        txt = txt.replace("&quot;", "\"");
        txt = txt.replace("&amp;", "&");
        txt = txt.replace("&apos;", "'");
        return txt;
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        if (this.variableName != null && !this.variableName.isEmpty()) {
            ret.put("vn", "\"" + Helper.escapePCodeString(this.variableName) + "\"");
        }
        return ret;
    }

    @Override
    public Dimension getFilterDimensions() {
        return new Dimension(0, 0);
    }

    @Override
    public RECT getRectWithFilters() {
        return this.getRect();
    }
}

