/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;

@SWFVersion(from=9)
public class DefineSceneAndFrameLabelDataTag
extends Tag {
    public static final int ID = 86;
    public static final String NAME = "DefineSceneAndFrameLabelData";
    @SWFType(value=BasicType.EncodedU32)
    @SWFArray(value="offset", countField="sceneCount")
    @Table(value="scenes", itemName="scene")
    public long[] sceneOffsets;
    @SWFArray(value="name", countField="sceneCount")
    @Table(value="scenes", itemName="scene")
    public String[] sceneNames;
    @SWFType(value=BasicType.EncodedU32)
    @SWFArray(value="frameNum", countField="frameLabelCount")
    @Table(value="frames", itemName="frame")
    public long[] frameNums;
    @SWFArray(countField="frameLabelCount")
    @Table(value="frames", itemName="frame")
    public String[] frameNames;

    public DefineSceneAndFrameLabelDataTag(SWF swf) {
        super(swf, 86, NAME, null);
        this.sceneOffsets = new long[0];
        this.sceneNames = new String[0];
        this.frameNums = new long[0];
        this.frameNames = new String[0];
    }

    public DefineSceneAndFrameLabelDataTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 86, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        int sceneCount = (int)sis.readEncodedU32("sceneCount");
        this.sceneOffsets = new long[sceneCount];
        this.sceneNames = new String[sceneCount];
        for (int i = 0; i < sceneCount; ++i) {
            this.sceneOffsets[i] = sis.readEncodedU32("sceneOffset");
            this.sceneNames[i] = sis.readString("sceneName");
        }
        int frameLabelCount = (int)sis.readEncodedU32("frameLabelCount");
        this.frameNums = new long[frameLabelCount];
        this.frameNames = new String[frameLabelCount];
        for (int i = 0; i < frameLabelCount; ++i) {
            this.frameNums[i] = sis.readEncodedU32("frameNum");
            this.frameNames[i] = sis.readString("frameName");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        int sceneCount = this.sceneOffsets.length;
        sos.writeEncodedU32(sceneCount);
        for (int i = 0; i < sceneCount; ++i) {
            sos.writeEncodedU32(this.sceneOffsets[i]);
            sos.writeString(this.sceneNames[i]);
        }
        int frameLabelCount = this.frameNums.length;
        sos.writeEncodedU32(frameLabelCount);
        for (int i = 0; i < frameLabelCount; ++i) {
            sos.writeEncodedU32(this.frameNums[i]);
            sos.writeString(this.frameNames[i]);
        }
    }
}

