/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SWFVersion(from=3)
public class GenCommandTag
extends Tag {
    public static final int ID = 49;
    public static final String NAME = "GenCommand";
    public static final int TYPE_MOVIE = 1;
    public static final int TYPE_BUTTON = 2;
    public static final int TYPE_GRAPHICS = 4;
    public static final int TYPE_GLOBAL = 8;
    public static final int FLAG_LOOP = 16;
    public static final int FLAG_PLAY_ONCE = 32;
    public static final int FLAG_SINGLE_FRAME = 64;
    public boolean typeMovie = false;
    public boolean typeButton = false;
    public boolean typeGraphics = false;
    public boolean typeGlobal = false;
    @SWFType(value=BasicType.UI16)
    public int depth = 0;
    @Conditional(value={"typeGraphics"})
    public boolean flagLoop = false;
    @Conditional(value={"typeGraphics"})
    public boolean flagPlayOnce = false;
    @Conditional(value={"typeGraphics"})
    public boolean flagSingleFrame = false;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"typeGraphics"})
    public int frameNum = 0;
    public String command = "NoCommand";
    @SWFArray(value="name", countField="paramCount")
    @Table(value="parameters", itemName="parameter")
    public List<String> parameterNames = new ArrayList<String>();
    @SWFArray(value="value", countField="paramCount")
    @Table(value="parameters", itemName="parameter")
    public List<String> commandValues = new ArrayList<String>();

    public GenCommandTag(SWF swf) {
        super(swf, 49, NAME, null);
    }

    public GenCommandTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 49, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        String fullCommandStr;
        int type = sis.readUI16("type");
        this.typeMovie = (type & 1) > 0;
        this.typeButton = (type & 2) > 0;
        this.typeGraphics = (type & 4) > 0;
        this.typeGlobal = (type & 8) > 0;
        this.depth = sis.readUI16("depth");
        if (this.typeGraphics) {
            int flags = sis.readUI16("flags");
            this.flagLoop = (flags & 0x10) > 0;
            this.flagPlayOnce = (flags & 0x20) > 0;
            this.flagSingleFrame = (flags & 0x40) > 0;
            this.frameNum = sis.readUI16("frameNum");
        }
        if (!(fullCommandStr = sis.readString("command")).contains(" ")) {
            this.command = fullCommandStr;
            return;
        }
        this.command = fullCommandStr.substring(0, fullCommandStr.indexOf(" "));
        boolean inValue = false;
        StringBuilder sb = new StringBuilder();
        String name = "";
        for (int i = fullCommandStr.indexOf(" ") + 1; i < fullCommandStr.length(); ++i) {
            Character cNext;
            Character c = Character.valueOf(fullCommandStr.charAt(i));
            Character c2 = cNext = i == fullCommandStr.length() - 1 ? null : Character.valueOf(fullCommandStr.charAt(i + 1));
            if (inValue) {
                if (c.charValue() == '/' && cNext.charValue() == 'n') {
                    sb.append('\n');
                    ++i;
                    continue;
                }
                if (c.charValue() == '/' && cNext.charValue() == 'r') {
                    sb.append('\r');
                    ++i;
                    continue;
                }
                if (c.charValue() == '\\' && cNext != null) {
                    sb.append(cNext);
                    ++i;
                    continue;
                }
                if (c.charValue() == '\"') {
                    String value = sb.toString();
                    this.parameterNames.add(name);
                    this.commandValues.add(value);
                    sb = new StringBuilder();
                    inValue = false;
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c.charValue() == '=' && cNext.charValue() == '\"') {
                inValue = true;
                name = sb.toString();
                sb = new StringBuilder();
                ++i;
                continue;
            }
            sb.append(c);
        }
    }

    public String getCommandString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.command);
        sb.append(" ");
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            String name = this.parameterNames.get(i);
            String value = this.commandValues.get(i);
            sb.append(name);
            sb.append("=\"");
            sb.append(value.replace("\n", "/n").replace("\r", "/r").replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append("\"");
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        int type = 0;
        if (this.typeMovie) {
            type |= 1;
        }
        if (this.typeButton) {
            type |= 2;
        }
        if (this.typeGraphics) {
            type |= 4;
        }
        if (this.typeGlobal) {
            type |= 8;
        }
        sos.writeUI16(type);
        sos.writeUI16(this.depth);
        if (this.typeGraphics) {
            int flags = 0;
            if (this.flagLoop) {
                flags |= 0x10;
            }
            if (this.flagPlayOnce) {
                flags |= 0x20;
            }
            if (this.flagSingleFrame) {
                flags |= 0x40;
            }
            sos.writeUI16(flags);
            sos.writeUI16(this.frameNum);
        }
        sos.writeString(this.getCommandString());
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        String shortCommand = this.command;
        if (shortCommand.contains(".")) {
            shortCommand = shortCommand.substring(shortCommand.lastIndexOf(".") + 1);
        }
        ret.put("cmd", shortCommand);
        ret.put("dpt", "" + this.depth);
        return ret;
    }
}

