/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class ButtonTag
extends DrawableTag
implements Timelined {
    public static final int FRAME_UP = 0;
    public static final int FRAME_OVER = 1;
    public static final int FRAME_DOWN = 2;
    public static final int FRAME_HITTEST = 3;
    private transient Timeline timeline;
    private boolean isSingleFrameInitialized;
    private boolean isSingleFrame;

    public ButtonTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract List<BUTTONRECORD> getRecords();

    public abstract boolean trackAsMenu();

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        for (BUTTONRECORD r : this.getRecords()) {
            needed.add(r.characterId);
        }
    }

    @Override
    public RECT getRect() {
        return this.getRect(new HashSet<BoundedTag>());
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    @Override
    public int getUsedParameters() {
        return 7;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return this.getTimeline().getOutline(fast, frame, time, renderContext, transformation, stroked, viewRect, unzoom);
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        this.getTimeline().toImage(frame, time, renderContext, image, fullImage, isClip, transformation, strokeTransformation, absoluteTransformation, colorTransform, unzoom, sameImage, viewRect, viewRectRaw, fullTransformation, scaleStrokes, drawMode, blendMode, canUseSmoothing, new ArrayList<Integer>(), aaScale);
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        this.getTimeline().toSVG(0, 0, null, 0, exporter, colorTransform, level + 1, transformation, strokeTransformation);
    }

    public DefineButtonSoundTag getSounds() {
        if (this.swf == null) {
            return null;
        }
        return (DefineButtonSoundTag)this.swf.getCharacterIdTag(this.getCharacterId(), 17);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        this.getTimeline().toHtmlCanvas(result, unitDivisor, Arrays.asList(0));
    }

    @Override
    public boolean isSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            this.initializeIsSingleFrame();
        }
        return this.isSingleFrame;
    }

    private synchronized void initializeIsSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            this.isSingleFrame = this.getTimeline().isSingleFrame();
            this.isSingleFrameInitialized = true;
        }
    }

    @Override
    public Timeline getTimeline() {
        if (this.timeline != null) {
            return this.timeline;
        }
        this.timeline = new Timeline(this.swf, this, this.getCharacterId(), this.getRect(), this.getFilterDimensions());
        this.initTimeline(this.timeline);
        return this.timeline;
    }

    @Override
    public void resetTimeline() {
        if (this.timeline != null) {
            this.timeline.reset(this.swf, this, this.getCharacterId(), this.getRect());
            this.initTimeline(this.timeline);
        }
    }

    protected abstract void initTimeline(Timeline var1);

    @Override
    public synchronized ReadOnlyTagList getTags() {
        return ReadOnlyTagList.EMPTY;
    }

    @Override
    public void removeTag(int index) {
    }

    @Override
    public void removeTag(Tag tag) {
    }

    @Override
    public void addTag(Tag tag) {
    }

    @Override
    public void addTag(int index, Tag tag) {
    }

    @Override
    public int indexOfTag(Tag tag) {
        return -1;
    }

    @Override
    public void replaceTag(int index, Tag newTag) {
        this.removeTag(index);
        this.addTag(index, newTag);
    }

    @Override
    public void replaceTag(Tag oldTag, Tag newTag) {
        this.setModified(true);
        int index = this.indexOfTag(oldTag);
        if (index != -1) {
            this.replaceTag(index, newTag);
        }
    }

    @Override
    public void setSwf(SWF swf, boolean deep) {
        this.swf = swf;
        for (BUTTONRECORD record : this.getRecords()) {
            record.setSourceTag(this);
        }
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        for (BUTTONRECORD record : this.getRecords()) {
            record.setModified(value);
        }
    }

    public BUTTONRECORD getButtonRecordAt(int frame, int depth, boolean addIfNotExists) {
        for (BUTTONRECORD rec : this.getRecords()) {
            if (rec.placeDepth != depth) continue;
            switch (frame) {
                case 0: {
                    if (!rec.buttonStateUp) break;
                    return rec;
                }
                case 1: {
                    if (!rec.buttonStateOver) break;
                    return rec;
                }
                case 2: {
                    if (!rec.buttonStateDown) break;
                    return rec;
                }
                case 3: {
                    if (!rec.buttonStateHitTest) break;
                    return rec;
                }
            }
        }
        if (addIfNotExists) {
            BUTTONRECORD newRecord = new BUTTONRECORD(this.swf, this);
            switch (frame) {
                case 0: {
                    newRecord.buttonStateUp = true;
                    break;
                }
                case 1: {
                    newRecord.buttonStateOver = true;
                    break;
                }
                case 2: {
                    newRecord.buttonStateDown = true;
                    break;
                }
                case 3: {
                    newRecord.buttonStateHitTest = true;
                }
            }
            newRecord.placeDepth = depth;
            this.getRecords().add(newRecord);
            return newRecord;
        }
        return null;
    }

    public void packRecords() {
        ArrayList records = new ArrayList();
        for (int i = records.size() - 1; i >= 0; --i) {
            BUTTONRECORD rec = (BUTTONRECORD)records.get(i);
            if (!rec.isEmpty()) continue;
            records.remove(i);
        }
    }

    public Set<Integer> getEmptyFrames() {
        LinkedHashSet<Integer> ret = new LinkedHashSet<Integer>();
        ret.add(0);
        ret.add(1);
        ret.add(2);
        ret.add(3);
        for (BUTTONRECORD rec : this.getRecords()) {
            if (rec.buttonStateUp) {
                ret.remove(0);
            }
            if (rec.buttonStateOver) {
                ret.remove(1);
            }
            if (rec.buttonStateDown) {
                ret.remove(2);
            }
            if (!rec.buttonStateHitTest) continue;
            ret.remove(3);
        }
        return ret;
    }

    public boolean isFrameEmpty(int frame) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRecordFromPlaceObject(int frame, PlaceObjectTypeTag placeTag) {
        BUTTONRECORD selectedRecord = null;
        List<BUTTONRECORD> records = this.getRecords();
        block12: for (BUTTONRECORD rec : records) {
            if (rec.placeDepth != placeTag.getDepth()) continue;
            switch (frame) {
                case 0: {
                    if (!rec.buttonStateUp) break;
                    selectedRecord = rec;
                    break block12;
                }
                case 1: {
                    if (!rec.buttonStateOver) break;
                    selectedRecord = rec;
                    break block12;
                }
                case 2: {
                    if (!rec.buttonStateDown) break;
                    selectedRecord = rec;
                    break block12;
                }
                case 3: {
                    if (!rec.buttonStateHitTest) break;
                    selectedRecord = rec;
                    break block12;
                }
            }
        }
        if (selectedRecord == null) {
            selectedRecord = new BUTTONRECORD(this.swf, this);
            switch (frame) {
                case 0: {
                    selectedRecord.buttonStateUp = true;
                    break;
                }
                case 1: {
                    selectedRecord.buttonStateOver = true;
                    break;
                }
                case 2: {
                    selectedRecord.buttonStateDown = true;
                    break;
                }
                case 3: {
                    selectedRecord.buttonStateHitTest = true;
                    break;
                }
            }
            records.add(selectedRecord);
        }
        selectedRecord.fromPlaceObject(placeTag);
    }

    @Override
    public Dimension getFilterDimensions() {
        int totalDeltaX = 0;
        int totalDeltaY = 0;
        for (BUTTONRECORD rec : this.getRecords()) {
            int chId = rec.characterId;
            CharacterTag ch = null;
            if (chId != -1) {
                ch = this.swf.getCharacter(chId);
            }
            if (ch instanceof DrawableTag) {
                Dimension filterDimension = ((DrawableTag)ch).getFilterDimensions();
                totalDeltaX = Math.max(totalDeltaX, filterDimension.width);
                totalDeltaY = Math.max(totalDeltaY, filterDimension.height);
            }
            double deltaXMax = 0.0;
            double deltaYMax = 0.0;
            if (rec.filterList == null || rec.filterList.isEmpty()) continue;
            for (FILTER filter : rec.filterList) {
                if (!filter.enabled) continue;
                double x = filter.getDeltaX();
                double y = filter.getDeltaY();
                deltaXMax += x;
                deltaYMax += y;
            }
            totalDeltaX = Math.max(totalDeltaX, (int)(Math.ceil(deltaXMax) * 20.0));
            totalDeltaY = Math.max(totalDeltaY, (int)(Math.ceil(deltaYMax) * 20.0));
        }
        return new Dimension(totalDeltaX, totalDeltaY);
    }
}

