/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.PathExporter;
import com.jpexs.decompiler.flash.exporters.shape.SVGShapeExporter;
import com.jpexs.decompiler.flash.helpers.LazyObject;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ShapeTag
extends DrawableTag
implements LazyObject {
    @SWFType(value=BasicType.UI16)
    public int shapeId;
    public RECT shapeBounds;
    public SHAPEWITHSTYLE shapes;
    protected ByteArrayRange shapeData;
    private final int markerSize = 10;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NONZERO = 1;

    public ShapeTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    @Override
    public void load() {
        this.getShapes();
    }

    public abstract int getWindingRule();

    public abstract int getShapeNum();

    public synchronized SHAPEWITHSTYLE getShapes() {
        if (this.shapes == null && this.shapeData != null) {
            try {
                SWFInputStream sis = new SWFInputStream(this.swf, this.shapeData.getArray(), 0L, this.shapeData.getPos() + this.shapeData.getLength());
                sis.seek(this.shapeData.getPos());
                this.shapes = sis.readSHAPEWITHSTYLE(this.getShapeNum(), false, "shapes");
                this.shapeData = null;
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeTag.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.shapes;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        SHAPEWITHSTYLE shapes = this.getShapes();
        if (shapes != null) {
            this.getShapes().getNeededCharacters(needed, neededClasses, swf);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = this.getShapes().replaceCharacter(oldCharacterId, newCharacterId);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = this.getShapes().removeCharacter(characterId);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.shapeBounds;
    }

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    @Override
    public RECT getRectWithStrokes() {
        int maxWidth = 0;
        ArrayList ilineStyles = new ArrayList();
        if (this.getShapeNum() == 4) {
            for (ILINESTYLE iLINESTYLE : this.getShapes().lineStyles.lineStyles2) {
                if (iLINESTYLE.getWidth() <= maxWidth) continue;
                maxWidth = iLINESTYLE.getWidth();
            }
        } else {
            for (ILINESTYLE iLINESTYLE : this.getShapes().lineStyles.lineStyles) {
                if (iLINESTYLE.getWidth() <= maxWidth) continue;
                maxWidth = iLINESTYLE.getWidth();
            }
        }
        for (SHAPERECORD sr : this.getShapes().shapeRecords) {
            if (!(sr instanceof StyleChangeRecord)) continue;
            StyleChangeRecord scr = (StyleChangeRecord)sr;
            if (!scr.stateNewStyles) continue;
            if (this.getShapeNum() == 4) {
                for (LINESTYLE2 lINESTYLE2 : scr.lineStyles.lineStyles2) {
                    if (lINESTYLE2.getWidth() <= maxWidth) continue;
                    maxWidth = lINESTYLE2.getWidth();
                }
                continue;
            }
            for (LINESTYLE lINESTYLE : scr.lineStyles.lineStyles) {
                if (lINESTYLE.getWidth() <= maxWidth) continue;
                maxWidth = lINESTYLE.getWidth();
            }
        }
        RECT r = new RECT(this.getRect());
        r.Xmin -= maxWidth;
        r.Ymin -= maxWidth;
        r.Xmax += maxWidth;
        r.Ymax += maxWidth;
        return r;
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return transformation.toTransform().createTransformedShape(this.getShapes().getOutline(fast, this.getShapeNum(), this.swf, stroked));
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, int aaScale) {
        BitmapExporter.export(this.getWindingRule(), this.getShapeNum(), this.getSwf(), this.getShapes(), null, image, unzoom, transformation, strokeTransformation, colorTransform, scaleStrokes, canUseSmoothing, aaScale);
        if (Configuration._debugMode.get().booleanValue()) {
            List<GeneralPath> paths = PathExporter.export(this.getWindingRule(), this.getShapeNum(), this.swf, this.getShapes());
            double[] coords = new double[6];
            AffineTransform at = transformation.toTransform();
            at.preConcatenate(AffineTransform.getScaleInstance(0.05, 0.05));
            Graphics2D graphics = (Graphics2D)image.getBufferedImage().getGraphics();
            graphics.setPaint(Color.black);
            for (GeneralPath path : paths) {
                PathIterator iterator = path.getPathIterator(at);
                while (!iterator.isDone()) {
                    int type = iterator.currentSegment(coords);
                    double x = coords[0];
                    double y = coords[1];
                    switch (type) {
                        case 0: {
                            graphics.drawRect((int)(x - 5.0), (int)(y - 5.0), 10, 10);
                            break;
                        }
                        case 1: {
                            graphics.drawRect((int)(x - 5.0), (int)(y - 5.0), 10, 10);
                            break;
                        }
                        case 2: {
                            graphics.drawRect((int)(x - 5.0), (int)(y - 5.0), 10, 10);
                            x = coords[2];
                            y = coords[3];
                            graphics.drawRect((int)(x - 5.0), (int)(y - 5.0), 10, 10);
                            break;
                        }
                        case 3: {
                            System.out.print("CUBICTO NOT SUPPORTED. ");
                            break;
                        }
                        case 4: {
                            System.out.print("CLOSE NOT SUPPORTED. ");
                        }
                    }
                    iterator.next();
                }
            }
        }
    }

    @Override
    public void toSVG(int frame, int time, SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        SVGShapeExporter shapeExporter = new SVGShapeExporter(this.getWindingRule(), this.getShapeNum(), this.swf, this.getShapes(), this.getCharacterId(), exporter, null, colorTransform, 1.0, exporter.getZoom(), strokeTransformation);
        shapeExporter.export();
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        CanvasShapeExporter cse = new CanvasShapeExporter(this.getWindingRule(), this.getShapeNum(), null, unitDivisor, this.swf, this.getShapes(), null, 0, 0);
        cse.export();
        result.append(cse.getShapeData());
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public int getCharacterId() {
        return this.shapeId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.shapeId = characterId;
    }

    public void updateBounds() {
        this.shapes.clearCachedOutline();
        this.shapeBounds = SHAPERECORD.getBounds(this.shapes.shapeRecords, this.shapes.lineStyles, this.getShapeNum(), false);
    }

    @Override
    public Dimension getFilterDimensions() {
        return new Dimension(0, 0);
    }
}

