/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.gfx.TgaSupport;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.helpers.ByteArrayRange;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.npe.dds.DDSReader;

public abstract class AbstractGfxImageTag
extends ImageTag {
    public AbstractGfxImageTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    private BufferedImage loadDds(byte[] imageData) {
        int[] pixels = DDSReader.read((byte[])imageData, (DDSReader.Order)DDSReader.ARGB, (int)0);
        BufferedImage bufImage = new BufferedImage(DDSReader.getWidth((byte[])imageData), DDSReader.getHeight((byte[])imageData), 2);
        bufImage.getRaster().setDataElements(0, 0, bufImage.getWidth(), bufImage.getHeight(), pixels);
        return bufImage;
    }

    protected BufferedImage getExternalBufferedImage(String fileName, int bitmapFormat) {
        byte[] imageData;
        Path imagePath = null;
        fileName = fileName.replace("\\", "/");
        try {
            imagePath = this.getSwf().getFile() == null ? null : Paths.get(this.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(fileName, new String[0]));
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        if (imagePath == null || !imagePath.toFile().exists()) {
            SwfSpecificCustomConfiguration cc = Configuration.getSwfSpecificCustomConfiguration(this.getSwf().getShortPathTitle());
            if (cc == null) {
                return null;
            }
            String paths = cc.getCustomData("pathResolving", "");
            if (paths.trim().isEmpty()) {
                return null;
            }
            String[] rows = paths.trim().split("\r\n");
            boolean found = false;
            for (String row : rows) {
                Path newImagePath;
                String searchPath;
                String prefix = "";
                if (row.contains("|")) {
                    prefix = row.substring(0, row.indexOf("|"));
                    searchPath = row.substring(row.indexOf("|") + 1);
                } else {
                    searchPath = row;
                }
                String fileNameNoPrefix = fileName;
                if (!prefix.isEmpty() && fileName.startsWith(prefix)) {
                    fileNameNoPrefix = fileName.substring(prefix.length());
                }
                if (searchPath.isEmpty() || !(newImagePath = Paths.get(searchPath, new String[0]).resolve(fileNameNoPrefix)).toFile().exists()) continue;
                found = true;
                imagePath = newImagePath;
                break;
            }
            if (!found) {
                return null;
            }
        }
        try {
            imageData = Files.readAllBytes(imagePath);
        }
        catch (IOException ex) {
            return null;
        }
        if (imageData.length >= 4 && imageData[0] == 68 && imageData[1] == 68 && imageData[2] == 83 && imageData[3] == 32) {
            return this.loadDds(imageData);
        }
        if (fileName.toLowerCase().endsWith(".tga") || bitmapFormat == 13) {
            TgaSupport.init();
        }
        try {
            return ImageIO.read(imagePath.toFile());
        }
        catch (IOException ex) {
            return null;
        }
    }
}

