/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.gfx.AbstractGfxImageTag;
import com.jpexs.decompiler.flash.tags.gfx.enums.FileFormatType;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class DefineExternalImage
extends AbstractGfxImageTag {
    public static final int ID = 1001;
    public static final String NAME = "DefineExternalImage";
    public int bitmapFormat;
    public int targetWidth;
    public int targetHeight;
    public boolean shortFormat = false;
    public String exportName;
    @Conditional(value={"shortFormat"}, revert=true)
    public String fileName;
    @HideInRawEdit
    private SerializableImage serImage;
    @HideInRawEdit
    private String cachedImageFilename = null;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI16(this.bitmapFormat);
        sos.writeUI16(this.targetWidth);
        sos.writeUI16(this.targetHeight);
        sos.writeNetString(this.exportName);
        if (!this.shortFormat) {
            sos.writeNetString(this.fileName);
        }
    }

    public DefineExternalImage(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1001, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public DefineExternalImage(SWF swf) {
        super(swf, 1001, NAME, null);
        this.shortFormat = false;
        this.exportName = "";
        this.fileName = "";
        this.targetWidth = 1;
        this.targetHeight = 1;
        this.bitmapFormat = 14;
        this.createFailedImage();
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bitmapFormat = sis.readUI16("bitmapFormat");
        this.targetWidth = sis.readUI16("targetWidth");
        this.targetHeight = sis.readUI16("targetHeight");
        this.exportName = sis.readNetString("exportName");
        if (sis.available() > 0) {
            this.fileName = sis.readNetString("fileName");
            this.shortFormat = false;
        } else {
            this.shortFormat = true;
        }
    }

    private void createFailedImage() {
        if (this.targetWidth <= 0 || this.targetHeight <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        this.serImage = new SerializableImage(this.targetWidth, this.targetHeight, 3);
        Graphics g = this.serImage.getGraphics();
        g.setColor(SWF.ERROR_COLOR);
        g.fillRect(0, 0, this.targetWidth, this.targetHeight);
        this.cachedImageFilename = null;
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        this.serImage = new SerializableImage(ImageHelper.read(data));
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        this.initImage();
        return this.serImage;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.targetWidth, this.targetHeight);
    }

    private String getFilename() {
        if (this.shortFormat) {
            return this.exportName + "." + FileFormatType.fileFormatExtension(this.bitmapFormat);
        }
        return this.fileName;
    }

    private void initImage() {
        String fname = this.getFilename();
        if (Objects.equals(this.cachedImageFilename, fname) && this.serImage != null && this.serImage.getWidth() == this.targetWidth && this.serImage.getHeight() == this.targetHeight) {
            return;
        }
        if (this.targetWidth <= 0 || this.targetHeight <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        BufferedImage bufImage = this.getExternalBufferedImage(fname, this.bitmapFormat);
        if (bufImage == null) {
            this.createFailedImage();
            return;
        }
        Image scaled = bufImage.getScaledInstance(this.targetWidth, this.targetHeight, 1);
        bufImage = new BufferedImage(this.targetWidth, this.targetHeight, 2);
        bufImage.getGraphics().drawImage(scaled, 0, 0, null);
        this.serImage = new SerializableImage(bufImage);
        this.cachedImageFilename = fname;
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        tagInfo.addInfo("general", "exportName", this.exportName);
        if (!this.shortFormat) {
            tagInfo.addInfo("general", "fileName", this.fileName);
        }
        String bitmapFormatStr = "0x" + Integer.toHexString(this.bitmapFormat);
        String fileFormatStr = FileFormatType.fileFormatToString(this.bitmapFormat);
        if (fileFormatStr != null) {
            bitmapFormatStr = fileFormatStr + " (" + this.bitmapFormat + ")";
        }
        tagInfo.addInfo("general", "bitmapFormat", bitmapFormatStr);
    }
}

