/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.gfx.enums.FileFormatType;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExporterInfo
extends Tag {
    public static final int ID = 1000;
    public static final String NAME = "ExporterInfo";
    public int version;
    public long flags;
    public int bitmapFormat;
    public String prefix;
    public String swfName;
    public List<Long> codeOffsets;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.version);
        if (this.version >= 266) {
            sos.writeUI32(this.flags);
        }
        sos.writeUI16(this.bitmapFormat);
        sos.writeNetString(this.prefix);
        sos.writeNetString(this.swfName);
        if (this.codeOffsets != null) {
            sos.writeUI16(this.codeOffsets.size());
            for (long l : this.codeOffsets) {
                sos.writeUI32(l);
            }
        }
    }

    public ExporterInfo(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1000, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public ExporterInfo(SWF swf) {
        super(swf, 1000, NAME, null);
        this.prefix = "";
        this.swfName = "";
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.version = sis.readUI16("version");
        if (this.version >= 266) {
            this.flags = sis.readUI32("flags");
        }
        this.bitmapFormat = sis.readUI16("bitmapFormat");
        this.prefix = sis.readNetString("prefix");
        this.swfName = sis.readNetString("swfName");
        if (sis.available() > 0) {
            this.codeOffsets = new ArrayList<Long>();
            int numCodeOffsets = sis.readUI16("numCodeOffsets");
            for (int i = 0; i < numCodeOffsets; ++i) {
                this.codeOffsets.add(sis.readUI32("codeOffset"));
            }
        }
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        tagInfo.addInfo("general", "version", this.version);
        tagInfo.addInfo("general", "flags", "0x" + Long.toHexString(this.flags));
        String bitmapFormatStr = "0x" + Integer.toHexString(this.bitmapFormat);
        String fileFormatStr = FileFormatType.fileFormatToString(this.bitmapFormat);
        if (fileFormatStr != null) {
            bitmapFormatStr = fileFormatStr + " (" + this.bitmapFormat + ")";
        }
        tagInfo.addInfo("general", "bitmapFormat", bitmapFormatStr);
        tagInfo.addInfo("general", "prefix", this.prefix);
        tagInfo.addInfo("general", "swfName", this.swfName);
        if (this.codeOffsets != null) {
            ArrayList<String> codeOffsetsStr = new ArrayList<String>();
            for (long codeOffset : this.codeOffsets) {
                codeOffsetsStr.add("" + codeOffset);
            }
            tagInfo.addInfo("general", "codeOffsets", String.join((CharSequence)", ", codeOffsetsStr));
        }
    }

    public boolean hasFlagShapesStrippedFromDefineFont() {
        return (this.flags & 0x10L) == 16L;
    }
}

