/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CLIPEVENTFLAGS;
import com.jpexs.decompiler.flash.types.HasSwfAndTag;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class CLIPACTIONRECORD
implements ASMSource,
Serializable,
HasSwfAndTag {
    private String scriptName = "-";
    private String exportedScriptName = "-";
    private CLIPACTIONS parentClipActions;
    public static final String[] KEYNAMES = new String[]{null, "<Left>", "<Right>", "<Home>", "<End>", "<Insert>", "<Delete>", null, "<Backspace>", null, null, null, null, "<Enter>", "<Up>", "<Down>", "<PageUp>", "<PageDown>", "<Tab>", "<Escape>", null, null, null, null, null, null, null, null, null, null, null, null, "<Space>"};
    public CLIPEVENTFLAGS eventFlags;
    @Conditional(value={"eventFlags.clipEventKeyPress"})
    public int keyCode;
    @HideInRawEdit
    public ByteArrayRange actionBytes;
    @Internal
    private SWF swf;
    @Internal
    private Tag tag;
    List<DisassemblyListener> listeners = new ArrayList<DisassemblyListener>();

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    public CLIPACTIONS getParentClipActions() {
        return this.parentClipActions;
    }

    public static String keyToString(int key) {
        if (key < KEYNAMES.length && key > 0 && KEYNAMES[key] != null) {
            return KEYNAMES[key];
        }
        return "" + (char)key;
    }

    public static Integer stringToKey(String str) {
        for (int i = 0; i < KEYNAMES.length; ++i) {
            if (KEYNAMES[i] == null || !str.equals(KEYNAMES[i])) continue;
            return i;
        }
        if (str.length() == 1) {
            return str.charAt(0);
        }
        return null;
    }

    public CLIPACTIONRECORD() {
        this.swf = null;
        this.tag = null;
        this.eventFlags = new CLIPEVENTFLAGS();
        this.actionBytes = ByteArrayRange.EMPTY;
    }

    public CLIPACTIONRECORD(SWF swf, Tag tag) {
        this.swf = swf;
        this.tag = tag;
        this.eventFlags = new CLIPEVENTFLAGS();
        this.actionBytes = ByteArrayRange.EMPTY;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setParentClipActions(CLIPACTIONS parentClipActions) {
        this.parentClipActions = parentClipActions;
    }

    @Override
    public void setSourceTag(Tag tag) {
        this.swf = tag.getSwf();
        this.tag = tag;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    public CLIPACTIONRECORD(SWF swf, SWFInputStream sis, Tag tag, CLIPACTIONS parentClipActions) throws IOException {
        this.swf = swf;
        this.tag = tag;
        this.eventFlags = sis.readCLIPEVENTFLAGS("eventFlags");
        if (this.eventFlags.isClear()) {
            return;
        }
        long actionRecordSize = sis.readUI32("actionRecordSize");
        if (this.eventFlags.clipEventKeyPress) {
            this.keyCode = sis.readUI8("keyCode");
            --actionRecordSize;
        }
        this.actionBytes = sis.readByteRangeEx(actionRecordSize, "actionBytes", DumpInfoSpecialType.ACTION_BYTES, sis.getPos());
        this.parentClipActions = parentClipActions;
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    @Override
    public SWF getSwf() {
        return this.swf;
    }

    public String toString() {
        return "CLIPACTIONRECORD " + this.eventFlags.getHeader(this.keyCode, false);
    }

    public String getHeader() {
        String ret = this.eventFlags.toString();
        if (this.eventFlags.clipEventKeyPress) {
            ret = ret.replace("keyPress", "keyPress<" + this.keyCode + ">");
        }
        return ret;
    }

    @Override
    public GraphTextWriter getASMSource(ScriptExportMode exportMode, GraphTextWriter writer, ActionList actions) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToString(this.listeners, 0L, actions, this.swf.version, exportMode, writer);
    }

    @Override
    public GraphTextWriter getActionScriptSource(GraphTextWriter writer, ActionList actions) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToSource(new HashMap<String, Map<String, Trait>>(), this, actions, this.getScriptName(), writer, actions.getCharset());
    }

    @Override
    public GraphTextWriter getActionScriptSource(GraphTextWriter writer, ActionList actions, List<ActionTreeOperation> treeOperations) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToSource(new HashMap<String, Map<String, Trait>>(), this, actions, this.getScriptName(), writer, actions.getCharset(), treeOperations);
    }

    @Override
    public boolean containsSource() {
        return true;
    }

    @Override
    public ActionList getActions() throws InterruptedException {
        return SWF.getCachedActionList(this, this.listeners);
    }

    @Override
    public void setActions(List<Action> actions) {
        this.actionBytes = Action.actionsToByteArrayRange(actions, true, this.swf.version);
    }

    @Override
    public ByteArrayRange getActionBytes() {
        return this.actionBytes;
    }

    @Override
    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = new ByteArrayRange(actionBytes);
        SWF.uncache(this);
    }

    @Override
    public void setConstantPools(List<List<String>> constantPools) throws ConstantPoolTooBigException {
        Action.setConstantPools(this, constantPools, false);
    }

    @Override
    public void setModified() {
        if (this.tag != null) {
            this.tag.setModified(true);
        }
    }

    @Override
    public boolean isModified() {
        if (this.tag != null) {
            return this.tag.isModified();
        }
        return false;
    }

    @Override
    public GraphTextWriter getActionBytesAsHex(GraphTextWriter writer) {
        return Helper.byteArrayToHexWithHeader(writer, this.actionBytes.getRangeData());
    }

    @Override
    public void addDisassemblyListener(DisassemblyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDisassemblyListener(DisassemblyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public GraphTextWriter getActionSourcePrefix(GraphTextWriter writer) {
        writer.appendNoHilight(this.eventFlags.getHeader(this.keyCode, false));
        writer.appendNoHilight("{").newLine();
        return writer.indent();
    }

    @Override
    public GraphTextWriter getActionSourceSuffix(GraphTextWriter writer) {
        writer.unindent();
        return writer.appendNoHilight("}").newLine();
    }

    @Override
    public int getPrefixLineCount() {
        return 1;
    }

    @Override
    public String removePrefixAndSuffix(String source) {
        return Helper.unindentRows(1, 1, source);
    }

    @Override
    public String getExportFileName() {
        return "CLIPACTIONRECORD " + this.eventFlags.getHeader(this.keyCode, true);
    }

    @Override
    public Tag getSourceTag() {
        return this.tag;
    }

    @Override
    public List<GraphTargetItem> getActionsToTree() {
        try {
            return Action.actionsToTree(new LinkedHashSet<String>(), false, new HashMap<String, Map<String, Trait>>(), false, false, this.getActions(), this.swf.version, 0, this.getScriptName(), this.swf.getCharset());
        }
        catch (InterruptedException ex) {
            return new ArrayList<GraphTargetItem>();
        }
    }

    @Override
    public String getExportedScriptName() {
        return this.exportedScriptName;
    }

    @Override
    public void setExportedScriptName(String scriptName) {
        this.exportedScriptName = scriptName;
    }
}

