/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHFOCALGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.Helper;
import java.io.Serializable;
import java.util.Arrays;

public class GRADIENT
implements Serializable {
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Pad"), @EnumValue(value=1, text="Reflect"), @EnumValue(value=2, text="Repeat")})
    public int spreadMode;
    public static final int SPREAD_PAD_MODE = 0;
    public static final int SPREAD_REFLECT_MODE = 1;
    public static final int SPREAD_REPEAT_MODE = 2;
    public static final int SPREAD_RESERVED = 3;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Normal RGB"), @EnumValue(value=1, text="Linear RGB")})
    public int interpolationMode;
    public static final int INTERPOLATION_RGB_MODE = 0;
    public static final int INTERPOLATION_LINEAR_RGB_MODE = 1;
    public static final int INTERPOLATION_RESERVED1 = 2;
    public static final int INTERPOLATION_RESERVED2 = 3;
    @SWFArray(value="record")
    public GRADRECORD[] gradientRecords = new GRADRECORD[0];

    public boolean isCompatibleGradient(GRADIENT otherGradient) {
        if (this.interpolationMode != otherGradient.interpolationMode) {
            return false;
        }
        if (this.spreadMode != otherGradient.spreadMode) {
            return false;
        }
        return this.gradientRecords.length == otherGradient.gradientRecords.length;
    }

    public MORPHGRADIENT toMorphGradient() {
        MORPHGRADIENT morphGradient = new MORPHGRADIENT();
        morphGradient.interpolationMode = this.interpolationMode;
        morphGradient.spreadMode = this.spreadMode;
        morphGradient.gradientRecords = new MORPHGRADRECORD[this.gradientRecords.length];
        for (int i = 0; i < this.gradientRecords.length; ++i) {
            morphGradient.gradientRecords[i] = this.gradientRecords[i].toMorphGradRecord();
        }
        return morphGradient;
    }

    public MORPHGRADIENT toMorphGradient(GRADIENT endGradient) {
        if (!this.isCompatibleGradient(endGradient)) {
            return null;
        }
        MORPHGRADIENT morphGradient = endGradient instanceof FOCALGRADIENT ? new MORPHFOCALGRADIENT() : new MORPHGRADIENT();
        morphGradient.interpolationMode = this.interpolationMode;
        morphGradient.spreadMode = this.spreadMode;
        morphGradient.gradientRecords = new MORPHGRADRECORD[this.gradientRecords.length];
        for (int i = 0; i < this.gradientRecords.length; ++i) {
            morphGradient.gradientRecords[i] = this.gradientRecords[i].toMorphGradRecord(endGradient.gradientRecords[i]);
        }
        if (endGradient instanceof FOCALGRADIENT) {
            morphGradient.startFocalPoint = 0.0f;
            morphGradient.endFocalPoint = ((FOCALGRADIENT)endGradient).focalPoint;
        }
        return morphGradient;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.spreadMode;
        hash = 97 * hash + this.interpolationMode;
        hash = 97 * hash + Arrays.deepHashCode(this.gradientRecords);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GRADIENT other = (GRADIENT)obj;
        if (this.spreadMode != other.spreadMode) {
            return false;
        }
        if (this.interpolationMode != other.interpolationMode) {
            return false;
        }
        return Arrays.deepEquals(this.gradientRecords, other.gradientRecords);
    }

    public GRADIENT toShapeNum(int shapeNum) {
        GRADIENT result = Helper.deepCopy(this);
        if (shapeNum < 4) {
            result.spreadMode = 0;
            result.interpolationMode = 0;
            if (this.gradientRecords.length > 8) {
                result.gradientRecords = Arrays.copyOfRange(result.gradientRecords, 0, 8);
            }
        }
        for (GRADRECORD rec : result.gradientRecords) {
            rec.color = shapeNum < 3 ? new RGB(rec.color) : new RGBA(rec.color);
        }
        return result;
    }

    public int getMinShapeNum() {
        if (this.gradientRecords.length > 8) {
            return 4;
        }
        if (this.spreadMode > 0) {
            return 4;
        }
        if (this.interpolationMode > 0) {
            return 4;
        }
        for (GRADRECORD rec : this.gradientRecords) {
            if (!(rec.color instanceof RGBA)) continue;
            RGBA col = (RGBA)rec.color;
            if (col.alpha == 255) continue;
            return 3;
        }
        return 1;
    }
}

