/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public class LINESTYLE2
implements NeedsCharacters,
Serializable,
ILINESTYLE {
    @SWFType(value=BasicType.UI16)
    public int width;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round cap"), @EnumValue(value=1, text="No cap"), @EnumValue(value=2, text="Square cap")})
    public int startCapStyle;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round join"), @EnumValue(value=1, text="Bevel join"), @EnumValue(value=2, text="Miter join")})
    public int joinStyle;
    public static final int ROUND_CAP = 0;
    public static final int NO_CAP = 1;
    public static final int SQUARE_CAP = 2;
    public static final int ROUND_JOIN = 0;
    public static final int BEVEL_JOIN = 1;
    public static final int MITER_JOIN = 2;
    public boolean hasFillFlag;
    public boolean noHScaleFlag;
    public boolean noVScaleFlag;
    public boolean pixelHintingFlag;
    @Reserved
    @SWFType(value=BasicType.UB, count=5)
    public int reserved;
    public boolean noClose;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round cap"), @EnumValue(value=1, text="No cap"), @EnumValue(value=2, text="Square cap")})
    public int endCapStyle;
    @SWFType(value=BasicType.UFIXED8)
    @Conditional(value={"joinStyle"}, options={2})
    public float miterLimitFactor;
    @Conditional(value={"!hasFillFlag"})
    public RGBA color;
    @Conditional(value={"hasFillFlag"})
    public FILLSTYLE fillType;

    @Override
    public void getNeededCharacters(Set<Integer> needed, Set<String> neededClasses, SWF swf) {
        if (this.hasFillFlag) {
            this.fillType.getNeededCharacters(needed, neededClasses, swf);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        if (this.fillType != null) {
            return this.fillType.replaceCharacter(oldCharacterId, newCharacterId);
        }
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        if (this.fillType != null) {
            return this.fillType.removeCharacter(characterId);
        }
        return false;
    }

    @Override
    public int getNum() {
        return 2;
    }

    @Override
    public RGB getColor() {
        if (this.hasFillFlag) {
            return null;
        }
        return this.color;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setColor(RGB color) {
        if (color instanceof RGBA) {
            this.color = (RGBA)color;
        }
        this.color = new RGBA(color.toColor());
        this.hasFillFlag = false;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isCompatibleLineStyle(LINESTYLE2 otherLineStyle, SWF swf) {
        if (this.startCapStyle != otherLineStyle.startCapStyle) {
            return false;
        }
        if (this.endCapStyle != otherLineStyle.endCapStyle) {
            return false;
        }
        if (this.joinStyle != otherLineStyle.joinStyle) {
            return false;
        }
        if (this.hasFillFlag != otherLineStyle.hasFillFlag) {
            return false;
        }
        if (this.noVScaleFlag != otherLineStyle.noVScaleFlag) {
            return false;
        }
        if (this.pixelHintingFlag != otherLineStyle.pixelHintingFlag) {
            return false;
        }
        if (this.noClose != otherLineStyle.noClose) {
            return false;
        }
        if (this.miterLimitFactor != otherLineStyle.miterLimitFactor) {
            return false;
        }
        return !this.hasFillFlag || this.fillType.isCompatibleFillStyle(otherLineStyle.fillType, swf);
    }

    public MORPHLINESTYLE2 toMorphLineStyle2() {
        MORPHLINESTYLE2 morphLineStyle2 = new MORPHLINESTYLE2();
        morphLineStyle2.startWidth = this.width;
        morphLineStyle2.endWidth = this.width;
        morphLineStyle2.startCapStyle = this.startCapStyle;
        morphLineStyle2.joinStyle = this.joinStyle;
        morphLineStyle2.hasFillFlag = this.hasFillFlag;
        morphLineStyle2.noHScaleFlag = this.noHScaleFlag;
        morphLineStyle2.noVScaleFlag = this.noVScaleFlag;
        morphLineStyle2.pixelHintingFlag = this.pixelHintingFlag;
        morphLineStyle2.noClose = this.noClose;
        morphLineStyle2.endCapStyle = this.endCapStyle;
        morphLineStyle2.miterLimitFactor = this.miterLimitFactor;
        if (this.color != null) {
            morphLineStyle2.startColor = new RGBA(this.color);
            morphLineStyle2.endColor = new RGBA(this.color);
        }
        if (this.fillType != null) {
            morphLineStyle2.fillType = this.fillType.toMorphStyle();
        }
        return morphLineStyle2;
    }

    public MORPHLINESTYLE2 toMorphLineStyle2(LINESTYLE2 endLineStyle, SWF swf) {
        if (!this.isCompatibleLineStyle(endLineStyle, swf)) {
            return null;
        }
        MORPHLINESTYLE2 morphLineStyle2 = new MORPHLINESTYLE2();
        morphLineStyle2.startWidth = this.width;
        morphLineStyle2.endWidth = endLineStyle.width;
        morphLineStyle2.startCapStyle = this.startCapStyle;
        morphLineStyle2.joinStyle = this.joinStyle;
        morphLineStyle2.hasFillFlag = this.hasFillFlag;
        morphLineStyle2.noHScaleFlag = this.noHScaleFlag;
        morphLineStyle2.noVScaleFlag = this.noVScaleFlag;
        morphLineStyle2.pixelHintingFlag = this.pixelHintingFlag;
        morphLineStyle2.noClose = this.noClose;
        morphLineStyle2.endCapStyle = this.endCapStyle;
        morphLineStyle2.miterLimitFactor = this.miterLimitFactor;
        if (this.color != null) {
            morphLineStyle2.startColor = new RGBA(this.color);
        }
        if (endLineStyle.color != null) {
            morphLineStyle2.endColor = new RGBA(endLineStyle.color);
        }
        if (this.hasFillFlag) {
            morphLineStyle2.fillType = this.fillType.toMorphStyle(endLineStyle.fillType, swf);
        }
        return morphLineStyle2;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.width;
        hash = 83 * hash + this.startCapStyle;
        hash = 83 * hash + this.joinStyle;
        hash = 83 * hash + (this.hasFillFlag ? 1 : 0);
        hash = 83 * hash + (this.noHScaleFlag ? 1 : 0);
        hash = 83 * hash + (this.noVScaleFlag ? 1 : 0);
        hash = 83 * hash + (this.pixelHintingFlag ? 1 : 0);
        hash = 83 * hash + this.reserved;
        hash = 83 * hash + (this.noClose ? 1 : 0);
        hash = 83 * hash + this.endCapStyle;
        hash = 83 * hash + Float.floatToIntBits(this.miterLimitFactor);
        hash = 83 * hash + Objects.hashCode(this.color);
        hash = 83 * hash + Objects.hashCode(this.fillType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LINESTYLE2 other = (LINESTYLE2)obj;
        if (this.width != other.width) {
            return false;
        }
        if (this.startCapStyle != other.startCapStyle) {
            return false;
        }
        if (this.joinStyle != other.joinStyle) {
            return false;
        }
        if (this.hasFillFlag != other.hasFillFlag) {
            return false;
        }
        if (this.noHScaleFlag != other.noHScaleFlag) {
            return false;
        }
        if (this.noVScaleFlag != other.noVScaleFlag) {
            return false;
        }
        if (this.pixelHintingFlag != other.pixelHintingFlag) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        if (this.noClose != other.noClose) {
            return false;
        }
        if (this.endCapStyle != other.endCapStyle) {
            return false;
        }
        if (Float.floatToIntBits(this.miterLimitFactor) != Float.floatToIntBits(other.miterLimitFactor)) {
            return false;
        }
        if (!Objects.equals(this.color, other.color)) {
            return false;
        }
        return Objects.equals(this.fillType, other.fillType);
    }

    public LINESTYLE toLineStyle1(int shapeNum) {
        LINESTYLE result = new LINESTYLE();
        result.color = this.hasFillFlag ? (shapeNum >= 3 ? new RGBA(Color.black) : new RGB(Color.black)) : this.color;
        result.width = this.width;
        return result;
    }

    public int getMinShapeNum() {
        boolean shapeNum = true;
        if (this.hasFillFlag) {
            return 4;
        }
        if (this.startCapStyle != 0) {
            return 4;
        }
        if (this.endCapStyle != 0) {
            return 4;
        }
        if (this.joinStyle != 0) {
            return 4;
        }
        if (this.noClose) {
            return 4;
        }
        if (this.noHScaleFlag) {
            return 4;
        }
        if (this.noVScaleFlag) {
            return 4;
        }
        if (this.pixelHintingFlag) {
            return 4;
        }
        if (this.color.alpha != 255) {
            return 3;
        }
        return 1;
    }
}

