/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

public class ColorMatrixConvertor {
    private static double[] contrastMap = new double[]{0.0, 0.01, 0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 0.1, 0.11, 0.12, 0.14, 0.15, 0.16, 0.17, 0.18, 0.2, 0.21, 0.22, 0.24, 0.25, 0.27, 0.28, 0.3, 0.32, 0.34, 0.36, 0.38, 0.4, 0.42, 0.44, 0.46, 0.48, 0.5, 0.53, 0.56, 0.59, 0.62, 0.65, 0.68, 0.71, 0.74, 0.77, 0.8, 0.83, 0.86, 0.89, 0.92, 0.95, 0.98, 1.0, 1.06, 1.12, 1.18, 1.24, 1.3, 1.36, 1.42, 1.48, 1.54, 1.6, 1.66, 1.72, 1.78, 1.84, 1.9, 1.96, 2.0, 2.12, 2.25, 2.37, 2.5, 2.62, 2.75, 2.87, 3.0, 3.2, 3.4, 3.6, 3.8, 4.0, 4.3, 4.7, 4.9, 5.0, 5.5, 6.0, 6.5, 6.8, 7.0, 7.3, 7.5, 7.8, 8.0, 8.4, 8.7, 9.0, 9.4, 9.6, 9.8, 10.0};
    private float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private int brightness = 0;
    private int saturation = 0;
    private int contrast = 0;
    private int hue = 0;

    public ColorMatrixConvertor(float[] matrix) {
        this.matrix = matrix;
        this.convertFromMatrix();
    }

    public ColorMatrixConvertor() {
    }

    public int getBrightness() {
        return this.brightness;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getContrast() {
        return this.contrast;
    }

    public int getHue() {
        return this.hue;
    }

    public void setBrightness(int brightness) {
        if (brightness < -100) {
            brightness = -100;
        }
        if (brightness > 100) {
            brightness = 100;
        }
        this.brightness = brightness;
        this.convertToMatrix();
    }

    public void setContrast(int contrast) {
        if (contrast < -100) {
            contrast = -100;
        }
        if (contrast > 100) {
            contrast = 100;
        }
        this.contrast = contrast;
        this.convertToMatrix();
    }

    public void setHue(int hue) {
        if (hue < -180) {
            hue = -180;
        }
        if (hue > 180) {
            hue = 180;
        }
        this.hue = hue;
        this.convertToMatrix();
    }

    public void setSaturation(int saturation) {
        if (saturation < -100) {
            saturation = -100;
        }
        if (saturation > 100) {
            saturation = 100;
        }
        this.saturation = saturation;
        this.convertToMatrix();
    }

    public void setMatrix(float[] matrix) {
        this.matrix = matrix;
        this.convertFromMatrix();
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    private void convertToMatrix() {
        float b = this.brightness;
        float c = this.contrast == 0 ? 1.0f : (this.contrast > 0 ? (float)contrastMap[this.contrast] + 1.0f : (float)this.contrast / 100.0f + 1.0f);
        float s = this.saturation == 0 ? 1.0f : (this.saturation > 0 ? 1.0f + (float)(3 * this.saturation) / 100.0f : (float)this.saturation / 100.0f + 1.0f);
        float h = (float)Math.toRadians(this.hue);
        float[][] mBrightness = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, b}, {0.0f, 1.0f, 0.0f, 0.0f, b}, {0.0f, 0.0f, 1.0f, 0.0f, b}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f}};
        float t = 0.5f * (1.0f - c) * 127.0f;
        float[][] mContrast = new float[][]{{c, 0.0f, 0.0f, 0.0f, t}, {0.0f, c, 0.0f, 0.0f, t}, {0.0f, 0.0f, c, 0.0f, t}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f}};
        float lumSatR = 0.3086f;
        float lumSatG = 0.6094f;
        float lumSatB = 0.082f;
        float[][] mSaturation = new float[][]{{s + (1.0f - s) * lumSatR, (1.0f - s) * lumSatG, (1.0f - s) * lumSatB, 0.0f, 0.0f}, {(1.0f - s) * lumSatR, s + (1.0f - s) * lumSatG, (1.0f - s) * lumSatB, 0.0f, 0.0f}, {(1.0f - s) * lumSatR, (1.0f - s) * lumSatG, s + (1.0f - s) * lumSatB, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f}};
        float lumHueR = 0.213f;
        float lumHueG = 0.715f;
        float lumHueB = 0.072f;
        float cosH = (float)Math.cos(h);
        float sinH = (float)Math.sin(h);
        float[][] mHue = new float[][]{{lumHueR + cosH * (1.0f - lumHueR) + sinH * -lumHueR, lumHueG + cosH * -lumHueG + sinH * -lumHueG, lumHueB + cosH * -lumHueB + sinH * (1.0f - lumHueB), 0.0f, 0.0f}, {lumHueR + cosH * -lumHueR + sinH * 0.143f, lumHueG + cosH * (1.0f - lumHueG) + sinH * 0.14f, lumHueB + cosH * -lumHueB + sinH * -0.283f, 0.0f, 0.0f}, {lumHueR + cosH * -lumHueR + sinH * -(1.0f - lumHueR), lumHueG + cosH * -lumHueG + sinH * lumHueG, lumHueB + cosH * (1.0f - lumHueB) + sinH * lumHueB, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f}};
        float[][] result2d = ColorMatrixConvertor.multiplyMatrices(mContrast, mBrightness);
        result2d = ColorMatrixConvertor.multiplyMatrices(mSaturation, result2d);
        result2d = ColorMatrixConvertor.multiplyMatrices(mHue, result2d);
        float[] result = new float[20];
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                result[i] = result2d[y][x];
                ++i;
            }
        }
        this.matrix = result;
    }

    public static float[][] multiplyMatrices(float[][] a, float[][] b) {
        float[][] result = new float[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                result[i][j] = 0.0f;
                for (int k = 0; k < 5; ++k) {
                    float[] fArray = result[i];
                    int n = j;
                    fArray[n] = fArray[n] + a[i][k] * b[k][j];
                }
            }
        }
        return result;
    }

    private static int normHue(double h) {
        int ret;
        if (Double.isNaN(h)) {
            h = -Math.PI;
        }
        for (ret = (int)Math.round(h * 180.0 / Math.PI); ret > 180; ret -= 360) {
        }
        while (ret < -180) {
            ret += 360;
        }
        return ret;
    }

    private static int normBrightness(double b) {
        if (Double.isNaN(b)) {
            b = -100.0;
        }
        return (int)Math.round(b);
    }

    private static int normSaturation(double s) {
        if (Double.isNaN(s)) {
            return -100;
        }
        if (s == 1.0) {
            return 0;
        }
        if (s - 1.0 < 0.0) {
            return (int)Math.round((s - 1.0) * 100.0);
        }
        return (int)Math.round((s - 1.0) * 100.0 / 3.0);
    }

    private static int normContrast(double c) {
        if (c == 127.0) {
            return 0;
        }
        if (c - 127.0 < 0.0) {
            return (int)Math.round((c - 127.0) * 100.0 / 127.0);
        }
        c = (c - 127.0) / 127.0;
        c = (double)Math.round(c * 100.0) / 100.0;
        for (int i = 0; i < contrastMap.length; ++i) {
            if (!(contrastMap[i] >= c)) continue;
            return i;
        }
        return contrastMap.length - 1;
    }

    private static boolean sameDouble(double a, double b) {
        double EPSILON = 1.0E-5;
        return a == b ? true : Math.abs(a - b) < 1.0E-5;
    }

    private void convertFromMatrix() {
        float[][] matrix2d = new float[5][5];
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                matrix2d[j][i] = this.matrix[index];
                ++index;
            }
        }
        double a11 = matrix2d[0][0];
        double a12 = matrix2d[0][1];
        double a13 = matrix2d[0][2];
        double a21 = matrix2d[1][0];
        double a22 = matrix2d[1][1];
        double a23 = matrix2d[1][2];
        double a31 = matrix2d[2][0];
        double a32 = matrix2d[2][1];
        double a33 = matrix2d[2][2];
        double a41 = matrix2d[4][0];
        double b = (2.4872168661075E13 * a11 * a11 - 1.51430415740925E14 * a12 + 3.41095051289483E14 * a12 * a12 - 1.530209478945E13 * a13 + 8.2428663495404E13 * a12 * a13 - 4.592294873812E12 * a13 * a13 + 4.355625147E10 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 2.38473095655E12 * a12 * a41 + 2.409778707E11 * a13 * a41 - 6.8592522E8 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) * a41 + 465.0 * a11 * (4.66201717582E11 * a12 + 5.5756962908E10 * a13 + 7.64132175E8 * (-127.0 + 2.0 * a41))) / (3.9168769545E11 * a11 * a11 + 5.371575610858E12 * a12 * a12 + 1.298089188904E12 * a12 * a13 - 7.2319604312E10 * a13 * a13 + 1860.0 * a11 * (1.835439833E9 * a12 + 2.19515602E8 * a13));
        double c = 127.0 * (495225.0 * a11 + 1661845.0 * a12 + 167930.0 * a13 + 478.0 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13))) / 717495.0;
        double h = 2.0 * (Math.atan((-465.0 * a11 + 287.0 * a12 + 178.0 * a13 + Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13))) / (500.0 * (a12 - a13))) + Math.PI);
        double s = 1543.0 * (-1.0335555E8 * a11 * a11 - 1.58872382E8 * a12 * a12 + 1.90161784E8 * a12 * a13 - 1.34644952E8 * a13 * a13 + 1661845.0 * a12 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 167930.0 * a13 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 465.0 * a11 * (274372.0 * a12 + 170168.0 * a13 + 1065.0 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)))) / (1.95843847725E11 * a11 * a11 + 2.685787805429E12 * a12 * a12 + 6.49044594452E11 * a12 * a13 - 3.6159802156E10 * a13 * a13 + 930.0 * a11 * (1.835439833E9 * a12 + 2.19515602E8 * a13));
        if (ColorMatrixConvertor.sameDouble(410.0 * a12, 1543.0 * a31) && ColorMatrixConvertor.sameDouble(410.0 * a12, 1543.0 * a32) && ColorMatrixConvertor.sameDouble(3047.0 * a12, 1543.0 * a21) && ColorMatrixConvertor.sameDouble(3047.0 * a12, 1543.0 * a23) && ColorMatrixConvertor.sameDouble(a22, a11 + 1504.0 * a12 / 1543.0) && ColorMatrixConvertor.sameDouble(1133.0 * a12 / 1543.0 + a33, a11) && !ColorMatrixConvertor.sameDouble(a11, a12) && !ColorMatrixConvertor.sameDouble(1543.0 * a11 + 3457.0 * a12, 0.0)) {
            h = 0.0;
        }
        this.brightness = ColorMatrixConvertor.normBrightness(b);
        this.contrast = ColorMatrixConvertor.normContrast(c);
        this.saturation = ColorMatrixConvertor.normSaturation(s);
        this.hue = ColorMatrixConvertor.normHue(h);
    }

    public String toString() {
        return "[brightness: " + this.brightness + ", contrast:" + this.contrast + ", saturation:" + this.saturation + ", hue: " + this.hue + "]";
    }
}

