/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.types.sound.MP3FRAME;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.MarkingBufferedInputStream;
import javazoom.jl.decoder.MarkingPushbackInputStream;

public class MP3SOUNDDATA {
    public int seekSamples;
    public List<MP3FRAME> frames;

    public MP3SOUNDDATA(SWFInputStream sis, boolean raw) throws IOException {
        if (!raw) {
            this.seekSamples = sis.readSI16("seekSamples");
        }
        this.frames = new ArrayList<MP3FRAME>();
        Decoder decoder = new Decoder();
        byte[] data = sis.readBytesEx(sis.available(), "soundStream");
        MarkingBufferedInputStream mis = new MarkingBufferedInputStream((InputStream)new ByteArrayInputStream(data));
        Bitstream bitstream = new Bitstream(mis);
        long initLen = mis.getPosition();
        MarkingPushbackInputStream mpis = bitstream.getSource();
        while (true) {
            long posBefore = initLen + mpis.getPosition();
            MP3FRAME frame = MP3FRAME.readFrame(bitstream, decoder);
            if (frame == null) break;
            long posAfter = initLen + mpis.getPosition();
            frame.setFullData(Arrays.copyOfRange(data, (int)posBefore, (int)posAfter));
            this.frames.add(frame);
        }
    }

    public int sampleCount() {
        int r = 0;
        for (MP3FRAME f : this.frames) {
            r += f.getSamples().getBufferLength();
        }
        return r;
    }
}

