/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import java.io.IOException;
import java.io.OutputStream;

public class BinDataOutputStream
extends OutputStream {
    private final OutputStream os;

    public BinDataOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void write(int ... values) throws IOException {
        for (int i : values) {
            this.os.write(i);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void writeUI16(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public void writeUI32(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
    }

    public void writeUI64(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
        this.write((int)(value >> 32 & 0xFFL));
        this.write((int)(value >> 40 & 0xFFL));
        this.write((int)(value >> 48 & 0xFFL));
        this.write((int)(value >> 56 & 0xFFL));
    }

    public void writeFloat(float val) throws IOException {
        this.writeUI32(Float.floatToIntBits(val));
    }

    public void writeDouble(double val) throws IOException {
        this.writeUI64(Double.doubleToLongBits(val));
    }
}

