/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.flv.AUDIODATA;
import com.jpexs.decompiler.flash.flv.FLVInputStream;
import com.jpexs.decompiler.flash.flv.FLVTAG;
import com.jpexs.decompiler.flash.flv.SCRIPTDATA;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAVARIABLE;
import com.jpexs.decompiler.flash.flv.VIDEODATA;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.decompiler.flash.xfl.BinDataOutputStream;
import com.jpexs.helpers.Reference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class MovieBinDataGenerator {
    public byte[] generateEmptyBinData() {
        return new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -96, 0, 0, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 64, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, -1, 0, 0, 0, 0, 0};
    }

    public void generateBinData(InputStream is, OutputStream os, float fps) throws IOException {
        VIDEODATA vd;
        BinDataOutputStream df = new BinDataOutputStream(os);
        FLVInputStream flvIs = new FLVInputStream(is);
        int width = 0;
        int height = 0;
        Reference<Boolean> audioPresent = new Reference<Boolean>(false);
        Reference<Boolean> videoPresent = new Reference<Boolean>(false);
        flvIs.readHeader(audioPresent, videoPresent);
        List<FLVTAG> flvTags = flvIs.readTags();
        long lastOffset = 0L;
        long videoFrameCount = 0L;
        int soundFormat = 0;
        int samplingRate = 0;
        boolean stereo = false;
        int videoCodec = 0;
        boolean hasAudio = false;
        long maxTimestamp = 0L;
        for (FLVTAG tag : flvTags) {
            if (tag.timeStamp > maxTimestamp) {
                maxTimestamp = tag.timeStamp;
            }
            if (tag.data instanceof VIDEODATA) {
                ++videoFrameCount;
                VIDEODATA vd2 = (VIDEODATA)tag.data;
                videoCodec = vd2.codecId;
            }
            if (!(tag.data instanceof AUDIODATA)) continue;
            AUDIODATA ad = (AUDIODATA)tag.data;
            soundFormat = ad.soundFormat;
            samplingRate = ad.soundRate;
            stereo = ad.soundType;
            hasAudio = true;
        }
        long videoDataIndex = 0L;
        for (FLVTAG fLVTAG : flvTags) {
            if (fLVTAG.data instanceof SCRIPTDATA) {
                SCRIPTDATA sd = (SCRIPTDATA)fLVTAG.data;
                if (sd.name.type != 2 || !"onMetaData".equals(sd.name.value) || sd.value.type != 8) continue;
                List subVals = (List)sd.value.value;
                for (Object o : subVals) {
                    if (!(o instanceof SCRIPTDATAVARIABLE)) continue;
                    SCRIPTDATAVARIABLE v = (SCRIPTDATAVARIABLE)o;
                    if ("width".equals(v.variableName)) {
                        width = (int)((Double)v.variableData.value).doubleValue();
                    }
                    if (!"height".equals(v.variableName)) continue;
                    height = (int)((Double)v.variableData.value).doubleValue();
                }
                df.write(3, videoCodec, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 64, 0, 0, 0, 0);
                if (hasAudio) {
                    df.write(128, 136, 229, 64, 16);
                } else {
                    df.write(0, 0, 0, 0, 0);
                }
                df.write(0, 0, 0);
                if (hasAudio) {
                    if (stereo) {
                        df.write(2);
                    } else {
                        df.write(1);
                    }
                } else {
                    df.write(0);
                }
                df.write(0, 0, 0);
                df.writeUI32(width);
                df.writeUI32(height);
                df.writeDouble((float)videoFrameCount / fps);
                df.write(0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 64, 24, 0, 0, 0, 0, 0, 0, 0, 1);
            }
            if (!(fLVTAG.data instanceof VIDEODATA)) continue;
            vd = (VIDEODATA)fLVTAG.data;
            long startOffset = lastOffset;
            df.writeUI32(startOffset);
            df.writeUI32(vd.videoData.length);
            lastOffset = startOffset + (long)vd.videoData.length;
            df.write(1, 0, 0, 0, 4 + (vd.frameType == 1 ? 1 : 0), 0, 0, 0);
            if (videoDataIndex < videoFrameCount - 1L) {
                df.write(1);
            } else {
                df.write(0);
            }
            ++videoDataIndex;
        }
        df.writeUI32(lastOffset);
        for (FLVTAG fLVTAG : flvTags) {
            if (!(fLVTAG.data instanceof VIDEODATA)) continue;
            vd = (VIDEODATA)fLVTAG.data;
            df.write(vd.videoData);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (FLVTAG tag : flvTags) {
            if (!(tag.data instanceof AUDIODATA)) continue;
            AUDIODATA ad = (AUDIODATA)tag.data;
            baos.write(ad.soundData);
        }
        df.writeUI32(1L);
        if (hasAudio) {
            SoundFormat soundFormat2 = new SoundFormat(soundFormat, samplingRate, stereo);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            soundFormat2.decode(new SWFInputStream(new ByteArrayInputStream(baos.toByteArray())), baos2);
            df.writeUI32(1L);
            df.write(0);
            df.writeUI32(baos2.size());
            df.writeUI32(1L);
            df.writeUI32(0L);
            df.write(0);
            df.writeUI32(baos2.size());
            df.write(baos2.toByteArray());
        } else {
            df.writeUI32(0L);
            df.write(0);
        }
        df.write(0, 0, 0, 0, 255, 254, 255, 0, 0, 0, 0, 0);
    }
}

