/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.decompiler.flash.math.BezierEdge;
import com.jpexs.decompiler.flash.math.Distances;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeFixer;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class MorphShapeFixer
extends ShapeFixer {
    @Override
    protected void beforeHandle(int shapeNum, List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers, FILLSTYLEARRAY baseFillStyles, LINESTYLEARRAY baseLineStyles, List<FILLSTYLEARRAY> fillStyleLayers, List<LINESTYLEARRAY> lineStyleLayers) {
        this.removeEmptyEdges(shapes);
        this.mergeSimilar(shapeNum, shapes, fillStyles0, lineStyles, layers, baseFillStyles, baseLineStyles, fillStyleLayers, lineStyleLayers);
        this.mergeWithSamePrefix(shapes, fillStyles0, fillStyles1, lineStyles);
        this.clearDuplicatePathsNextToEachOther(shapes, fillStyles0, lineStyles);
        this.fixHolesAndAntiClockwise(shapes, fillStyles0, fillStyles1, lineStyles, layers);
        this.mergeSamePathsWithOppositeFillstyles(shapes, fillStyles0, fillStyles1, lineStyles, layers);
    }

    private void mergeSamePathsWithOppositeFillstyles(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers) {
        for (int i1 = 0; i1 < shapes.size(); ++i1) {
            for (int i2 = 0; i2 < shapes.size(); ++i2) {
                if (i1 == i2 || layers.get(i1) != layers.get(i2) || lineStyles.get(i1) != lineStyles.get(i2) || !shapes.get(i1).equals(shapes.get(i2))) continue;
                boolean doRemove = false;
                if (fillStyles0.get(i1) != 0 && fillStyles1.get(i1) == 0 && fillStyles1.get(i2) != 0 && fillStyles0.get(i2) == 0) {
                    fillStyles1.set(i1, fillStyles1.get(i2));
                    doRemove = true;
                } else if (fillStyles1.get(i1) != 0 && fillStyles0.get(i1) == 0 && fillStyles0.get(i2) != 0 && fillStyles1.get(i2) == 0) {
                    fillStyles0.set(i1, fillStyles0.get(i2));
                    doRemove = true;
                }
                if (!doRemove) continue;
                shapes.remove(i2);
                fillStyles0.remove(i2);
                fillStyles1.remove(i2);
                lineStyles.remove(i2);
                layers.remove(i2);
                --i2;
            }
        }
    }

    private boolean isEmptyPath(List<BezierEdge> path) {
        for (BezierEdge be : path) {
            if (be.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void fixHolesAndAntiClockwise(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles, List<Integer> layers) {
        int i;
        ArrayList closedShapes = new ArrayList();
        ArrayList<Integer> closedFillStyle = new ArrayList<Integer>();
        ArrayList<Integer> closedShapesI = new ArrayList<Integer>();
        ArrayList<Integer> closedShapesJ = new ArrayList<Integer>();
        LinkedHashSet<Integer> closedHolesI = new LinkedHashSet<Integer>();
        for (i = 0; i < shapes.size(); ++i) {
            Point2D lastMoveTo = null;
            BezierEdge lastEdge = null;
            int moveToIndex = 0;
            ArrayList<BezierEdge> batch = new ArrayList<BezierEdge>();
            for (int j = 0; j < shapes.get(i).size(); ++j) {
                BezierEdge be = shapes.get(i).get(j);
                batch.add(be);
                if (lastMoveTo != null && be.getEndPoint().equals(lastMoveTo)) {
                    closedFillStyle.add(fillStyles0.get(i));
                    closedShapes.add(batch);
                    closedShapesI.add(i);
                    closedShapesJ.add(moveToIndex);
                    moveToIndex = j + 1;
                    lastMoveTo = be.getEndPoint();
                    batch = new ArrayList();
                }
                if (lastEdge != null) {
                    if (!lastEdge.getEndPoint().equals(be.getBeginPoint())) {
                        lastMoveTo = be.getBeginPoint();
                        moveToIndex = j;
                    }
                } else {
                    lastMoveTo = be.getBeginPoint();
                }
                lastEdge = be;
            }
        }
        for (i = 0; i < closedShapes.size(); ++i) {
            List list = (List)closedShapes.get(i);
            if (list.isEmpty()) continue;
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            points.add(((BezierEdge)list.get(0)).getBeginPoint());
            for (BezierEdge be : list) {
                if (be.points.size() == 3) {
                    points.add(be.points.get(1));
                }
                points.add(be.getEndPoint());
            }
            double sum = 0.0;
            for (int j = 0; j < points.size(); ++j) {
                Point2D p1 = (Point2D)points.get(j);
                Point2D p2 = (Point2D)points.get((j + 1) % points.size());
                sum += p1.getX() * p2.getY() - p2.getX() * p1.getY();
            }
            if (!(sum < 0.0)) continue;
            ArrayList<BezierEdge> rev = new ArrayList<BezierEdge>();
            for (int j = 0; j < list.size(); ++j) {
                rev.add(((BezierEdge)list.get(list.size() - 1 - j)).reverse());
            }
            int shapeI = (Integer)closedShapesI.get(i);
            int shapeJ = (Integer)closedShapesJ.get(i);
            for (int j = 0; j < list.size(); ++j) {
                shapes.get(shapeI).set(shapeJ + j, (BezierEdge)rev.get(j));
            }
        }
        LinkedHashMap fillStyleToClosed = new LinkedHashMap();
        for (int i2 = 0; i2 < closedShapes.size(); ++i2) {
            int fs = (Integer)closedFillStyle.get(i2);
            if (fs == 0) continue;
            if (!fillStyleToClosed.containsKey(fs)) {
                fillStyleToClosed.put(fs, new ArrayList());
            }
            ((List)fillStyleToClosed.get(fs)).add(i2);
        }
        Iterator i2 = fillStyleToClosed.keySet().iterator();
        while (i2.hasNext()) {
            int i3;
            int fs = (Integer)i2.next();
            GeneralPath path = new GeneralPath(0);
            LinkedHashMap<Integer, GeneralPath> closedPaths = new LinkedHashMap<Integer, GeneralPath>();
            Iterator<Object> rev = ((List)fillStyleToClosed.get(fs)).iterator();
            while (rev.hasNext()) {
                i3 = (Integer)rev.next();
                List closed = (List)closedShapes.get(i3);
                if (closed.isEmpty()) continue;
                GeneralPath closedPath = new GeneralPath(0);
                closedPath.moveTo(((BezierEdge)closed.get(0)).getBeginPoint().getX(), ((BezierEdge)closed.get(0)).getBeginPoint().getY());
                path.moveTo(((BezierEdge)closed.get(0)).getBeginPoint().getX(), ((BezierEdge)closed.get(0)).getBeginPoint().getY());
                boolean isEmpty = true;
                for (BezierEdge be : closed) {
                    if (be.isEmpty()) continue;
                    isEmpty = false;
                    if (be.points.size() == 3) {
                        closedPath.quadTo(be.points.get(1).getX(), be.points.get(1).getY(), be.getEndPoint().getX(), be.getEndPoint().getY());
                        path.quadTo(be.points.get(1).getX(), be.points.get(1).getY(), be.getEndPoint().getX(), be.getEndPoint().getY());
                        continue;
                    }
                    closedPath.lineTo(be.getEndPoint().getX(), be.getEndPoint().getY());
                    path.lineTo(be.getEndPoint().getX(), be.getEndPoint().getY());
                }
                closedPath.closePath();
                path.closePath();
                if (isEmpty) continue;
                closedPaths.put(i3, closedPath);
            }
            rev = closedPaths.keySet().iterator();
            while (rev.hasNext()) {
                i3 = (Integer)rev.next();
                GeneralPath region = (GeneralPath)closedPaths.get(i3);
                PathIterator pi = region.getPathIterator(null);
                Rectangle2D bounds = region.getBounds2D();
                double centerX = bounds.getCenterX();
                double centerY = bounds.getCenterY();
                int numPoints = 0;
                int numContains = 0;
                int numNotContains = 0;
                double x = 0.0;
                double y = 0.0;
                while (!pi.isDone()) {
                    double[] points = new double[6];
                    int type = pi.currentSegment(points);
                    switch (type) {
                        case 0: 
                        case 1: {
                            x = points[0];
                            y = points[1];
                            break;
                        }
                        case 2: {
                            x = points[2];
                            y = points[3];
                        }
                    }
                    ++numPoints;
                    double p = Math.sqrt((centerX - x) * (centerX - x) + (centerY - y) * (centerY - y));
                    double x1 = (centerX - x) * 0.1 / p;
                    double y1 = (centerY - y) * 0.1 / p;
                    if (path.contains(x + x1, y + y1)) {
                        ++numContains;
                    } else {
                        ++numNotContains;
                    }
                    if (numPoints == 4) break;
                    pi.next();
                }
                if (numNotContains <= numContains) continue;
                closedHolesI.add(i3);
            }
        }
        for (int i4 = closedShapes.size() - 1; i4 >= 0; --i4) {
            if (!closedHolesI.contains(i4)) continue;
            int to = (Integer)closedShapesJ.get(i4) + ((List)closedShapes.get(i4)).size() - 1;
            int from = (Integer)closedShapesJ.get(i4);
            List<BezierEdge> list = shapes.get((Integer)closedShapesI.get(i4));
            for (int j = to; j >= from; --j) {
                list.remove(j);
            }
            int shapeI = (Integer)closedShapesI.get(i4);
            shapes.add(shapeI + 1, (List<BezierEdge>)closedShapes.get(i4));
            closedShapes.set(i4, new ArrayList());
            fillStyles0.add(shapeI + 1, 0);
            fillStyles1.add(shapeI + 1, fillStyles0.get(shapeI));
            lineStyles.add(shapeI + 1, lineStyles.get(shapeI));
            layers.add(shapeI + 1, layers.get(shapeI));
        }
    }

    private void clearDuplicatePathsNextToEachOther(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> lineStyles) {
        List<BezierEdge> prevList = null;
        int prevI = -1;
        for (int i = 0; i < shapes.size(); ++i) {
            List<BezierEdge> list = shapes.get(i);
            if (list.isEmpty()) continue;
            if (prevList != null && fillStyles0.get(i) == fillStyles0.get(prevI) && lineStyles.get(i) == lineStyles.get(prevI) && list.equals(prevList)) {
                prevList.clear();
            }
            prevI = i;
            prevList = list;
        }
    }

    private void mergeWithSamePrefix(List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> fillStyles1, List<Integer> lineStyles) {
        List<BezierEdge> prevList = null;
        int prevI = -1;
        for (int i = 0; i < shapes.size(); ++i) {
            List<BezierEdge> list = shapes.get(i);
            if (list.isEmpty()) continue;
            if (prevList != null) {
                int j;
                boolean isPrefix;
                int prevFillStyle0 = fillStyles0.get(i - 1);
                int prevFillStyle1 = fillStyles1.get(i - 1);
                int prevLineStyle = lineStyles.get(i - 1);
                int lineStyle = lineStyles.get(i);
                int fillStyle0 = fillStyles0.get(i);
                int fillStyle1 = fillStyles1.get(i);
                if (fillStyle0 == 0 && fillStyle1 == 0 && lineStyle != 0 && lineStyle == prevLineStyle) {
                    if (prevList.size() >= list.size()) {
                        isPrefix = true;
                        for (j = 0; j < list.size(); ++j) {
                            if (prevList.get(j).equals(list.get(j))) continue;
                            isPrefix = false;
                            break;
                        }
                        if (isPrefix) {
                            shapes.get(i).clear();
                            continue;
                        }
                    }
                } else if (prevFillStyle0 == 0 && prevFillStyle1 == 0 && prevLineStyle != 0 && lineStyle == prevLineStyle && list.size() >= prevList.size()) {
                    isPrefix = true;
                    for (j = 0; j < prevList.size(); ++j) {
                        if (prevList.get(j).equals(list.get(j))) continue;
                        isPrefix = false;
                        break;
                    }
                    if (isPrefix) {
                        shapes.get(prevI).clear();
                    }
                }
            }
            prevI = i;
            prevList = list;
        }
    }

    private void mergeSimilar(int shapeNum, List<List<BezierEdge>> shapes, List<Integer> fillStyles0, List<Integer> lineStyles, List<Integer> layers, FILLSTYLEARRAY baseFillStyles, LINESTYLEARRAY baseLineStyles, List<FILLSTYLEARRAY> fillStyleLayers, List<LINESTYLEARRAY> lineStyleLayers) {
        int i;
        ArrayList closedShapes = new ArrayList();
        ArrayList<Integer> closedFillStyle = new ArrayList<Integer>();
        ArrayList<Integer> closedLineStyle = new ArrayList<Integer>();
        ArrayList<Integer> closedLayers = new ArrayList<Integer>();
        ArrayList<Integer> closedShapesI = new ArrayList<Integer>();
        ArrayList<Integer> closedShapesJ = new ArrayList<Integer>();
        LinkedHashMap<Integer, Integer> replacements = new LinkedHashMap<Integer, Integer>();
        for (int i2 = 0; i2 < shapes.size(); ++i2) {
            Point2D lastMoveTo = null;
            BezierEdge lastEdge = null;
            int moveToIndex = 0;
            ArrayList<BezierEdge> batch = new ArrayList<BezierEdge>();
            for (int j = 0; j < shapes.get(i2).size(); ++j) {
                BezierEdge be = shapes.get(i2).get(j);
                batch.add(be);
                if (lastMoveTo != null && be.getEndPoint().equals(lastMoveTo)) {
                    closedFillStyle.add(fillStyles0.get(i2));
                    closedLineStyle.add(lineStyles.get(i2));
                    closedShapes.add(batch);
                    closedLayers.add(layers.get(i2));
                    closedShapesI.add(i2);
                    closedShapesJ.add(moveToIndex);
                    moveToIndex = j + 1;
                    lastMoveTo = be.getEndPoint();
                    batch = new ArrayList();
                }
                if (lastEdge != null) {
                    if (!lastEdge.getEndPoint().equals(be.getBeginPoint())) {
                        lastMoveTo = be.getBeginPoint();
                        moveToIndex = j;
                    }
                } else {
                    lastMoveTo = be.getBeginPoint();
                }
                lastEdge = be;
            }
        }
        HashSet<Integer> removedShapes = new HashSet<Integer>();
        for (int i1 = 0; i1 < closedShapes.size(); ++i1) {
            if (replacements.containsKey(i1)) continue;
            for (int i2 = 0; i2 < closedShapes.size(); ++i2) {
                double dist;
                if (i1 == i2 || replacements.containsKey(i2) || closedLayers.get(i1) != closedLayers.get(i2)) continue;
                if ((Integer)closedFillStyle.get(i1) > 0 && (Integer)closedFillStyle.get(i2) > 0 && closedFillStyle.get(i1) != closedFillStyle.get(i2)) {
                    FILLSTYLE fs2;
                    FILLSTYLEARRAY fa = (Integer)closedLayers.get(i1) == -1 ? baseFillStyles : fillStyleLayers.get((Integer)closedLayers.get(i1));
                    FILLSTYLE fs1 = fa.fillStyles[(Integer)closedFillStyle.get(i1) - 1];
                    if (!fs1.equals(fs2 = fa.fillStyles[(Integer)closedFillStyle.get(i2) - 1])) continue;
                }
                if ((Integer)closedLineStyle.get(i1) > 0 && (Integer)closedLineStyle.get(i2) > 0 && closedLineStyle.get(i1) != closedLineStyle.get(i2)) {
                    ILINESTYLE ls2;
                    ILINESTYLE ls1;
                    LINESTYLEARRAY lsa;
                    LINESTYLEARRAY lINESTYLEARRAY = lsa = (Integer)closedLayers.get(i1) == -1 ? baseLineStyles : lineStyleLayers.get((Integer)closedLayers.get(i1));
                    if (shapeNum > 3 ? !((LINESTYLE2)(ls1 = lsa.lineStyles2[(Integer)closedLineStyle.get(i1) - 1])).equals(ls2 = lsa.lineStyles2[(Integer)closedLineStyle.get(i2) - 1]) : !((LINESTYLE)(ls1 = lsa.lineStyles[(Integer)closedLineStyle.get(i1) - 1])).equals(ls2 = lsa.lineStyles[(Integer)closedLineStyle.get(i2) - 1])) continue;
                }
                if (((List)closedShapes.get(i1)).size() <= 1 || ((List)closedShapes.get(i2)).size() <= 1 || (Integer)closedLineStyle.get(i1) > 0 && (Integer)closedLineStyle.get(i2) == 0 || this.isEmptyPath((List)closedShapes.get(i1)) || this.isEmptyPath((List)closedShapes.get(i2)) || !((dist = Distances.getBatchDistance((List)closedShapes.get(i1), (List)closedShapes.get(i2))) <= 10.0)) continue;
                replacements.put(i2, i1);
                removedShapes.add(i2);
            }
        }
        for (i = 0; i < closedShapes.size(); ++i) {
            int repI = replacements.containsKey(i) ? (Integer)replacements.get(i) : i;
            List listI = (List)closedShapes.get(repI);
            for (int j = i + 1; j < closedShapes.size(); ++j) {
                if (removedShapes.contains(j) && !replacements.containsKey(j)) continue;
                int repJ = replacements.containsKey(j) ? (Integer)replacements.get(j) : j;
                List listJ = (List)closedShapes.get(repJ);
                if (closedFillStyle.get(i) != closedFillStyle.get(j) || closedLineStyle.get(i) != closedLineStyle.get(j) || !listI.equals(listJ)) continue;
                replacements.remove(j);
                removedShapes.add(j);
            }
        }
        for (i = closedShapes.size() - 1; i >= 0; --i) {
            int j;
            int to = (Integer)closedShapesJ.get(i) + ((List)closedShapes.get(i)).size() - 1;
            int from = (Integer)closedShapesJ.get(i);
            List<BezierEdge> list = shapes.get((Integer)closedShapesI.get(i));
            if (removedShapes.contains(i)) {
                for (j = to; j >= from; --j) {
                    list.remove(j);
                }
            }
            if (replacements.containsKey(i)) {
                list.addAll(from, (Collection)closedShapes.get((Integer)replacements.get(i)));
            }
            if (removedShapes.contains(i)) continue;
            for (j = to; j >= from; --j) {
                if (!list.get(j).isEmpty()) continue;
                list.remove(j);
            }
        }
    }

    private void removeEmptyEdges(List<List<BezierEdge>> shapes) {
        for (int i = 0; i < shapes.size(); ++i) {
            List<BezierEdge> list = shapes.get(i);
            for (int j = 0; j < list.size(); ++j) {
                if (!list.get(j).isEmpty()) continue;
                list.remove(j);
                --j;
            }
        }
    }
}

