/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.helpers.Reference;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;

public final class PathArea {
    public static void orientations(Shape shape, List<Orientation> result, List<Double> areas) {
        double flatness = 0.5;
        int limit = 10;
        PathIterator pathIterator = shape.getPathIterator(null);
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(pathIterator, 0.5, 10);
        double[] coords = new double[6];
        ArrayList<double[]> current = new ArrayList<double[]>();
        double startX = 0.0;
        double startY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean hasOpen = false;
        while (!flatteningPathIterator.isDone()) {
            int seg = flatteningPathIterator.currentSegment(coords);
            switch (seg) {
                case 0: {
                    if (!current.isEmpty()) {
                        result.add(Orientation.OPEN_CONTOUR);
                        areas.add(0.0);
                        hasOpen = true;
                        current.clear();
                    }
                    startX = lastX = coords[0];
                    startY = lastY = coords[1];
                    current.add(new double[]{lastX, lastY});
                    break;
                }
                case 1: {
                    lastX = coords[0];
                    lastY = coords[1];
                    current.add(new double[]{lastX, lastY});
                    break;
                }
                case 4: {
                    if (!current.isEmpty()) {
                        Reference<Object> orientationRef = new Reference<Object>(null);
                        Reference<Double> areaRef = new Reference<Double>(0.0);
                        PathArea.orientationOfClosedRing(current, areaRef, orientationRef);
                        result.add(orientationRef.getVal());
                        areas.add(areaRef.getVal());
                        current.clear();
                    }
                    lastX = startX;
                    lastY = startY;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected segment type: " + seg);
                }
            }
            flatteningPathIterator.next();
        }
        if (!current.isEmpty()) {
            result.add(Orientation.OPEN_CONTOUR);
            areas.add(0.0);
            hasOpen = true;
        }
    }

    private static void orientationOfClosedRing(List<double[]> pts, Reference<Double> areaRef, Reference<Orientation> resultRef) {
        if (pts.size() < 3) {
            resultRef.setVal(Orientation.DEGENERATE);
            areaRef.setVal(0.0);
            return;
        }
        double area2 = 0.0;
        int n = pts.size();
        for (int i = 0; i < n; ++i) {
            double[] a = pts.get(i);
            double[] b = pts.get((i + 1) % n);
            area2 += a[0] * b[1] - b[0] * a[1];
        }
        double eps = 1.0E-9;
        if (Math.abs(area2) <= eps) {
            resultRef.setVal(Orientation.DEGENERATE);
            areaRef.setVal(0.0);
            return;
        }
        resultRef.setVal(area2 > 0.0 ? Orientation.CLOCKWISE : Orientation.COUNTER_CLOCKWISE);
        areaRef.setVal(Math.abs(area2 / 2.0));
    }

    public static void orientationSingleClosed(Shape shape, Reference<Orientation> orientationRef, Reference<Double> areaRef) {
        ArrayList<Orientation> result = new ArrayList<Orientation>();
        ArrayList<Double> areas = new ArrayList<Double>();
        PathArea.orientations(shape, result, areas);
        if (result.isEmpty()) {
            orientationRef.setVal(Orientation.DEGENERATE);
            areaRef.setVal(0.0);
            return;
        }
        for (int i = 0; i < result.size(); ++i) {
            Orientation o = (Orientation)((Object)result.get(i));
            if (o == Orientation.OPEN_CONTOUR) continue;
            orientationRef.setVal(o);
            areaRef.setVal((Double)areas.get(i));
            return;
        }
        orientationRef.setVal(Orientation.OPEN_CONTOUR);
        areaRef.setVal(0.0);
    }

    public static enum Orientation {
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        DEGENERATE,
        OPEN_CONTOUR;

    }
}

