/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import java.awt.Container;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PathConverterApp {
    private static boolean updating = false;

    public static void main(String[] args) {
        JFrame fr = new JFrame();
        fr.setDefaultCloseOperation(3);
        fr.setSize(800, 800);
        Container cnt = fr.getContentPane();
        cnt.setLayout(new FlowLayout());
        final JTextArea t1 = new JTextArea(20, 50);
        final JTextArea t2 = new JTextArea(20, 50);
        t1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (updating) {
                    return;
                }
                updating = true;
                String newText = t1.getText();
                newText = newText.replaceAll(" *<Edge .* edges=\"", "");
                newText = newText.replaceAll("\"/>", "");
                StringBuffer resultString = new StringBuffer();
                Pattern regex = Pattern.compile("#([A-F0-9]+)\\.([A-F0-9]+)");
                Matcher m = regex.matcher(newText);
                while (m.find()) {
                    int p1 = Integer.parseInt(m.group(1), 16);
                    int p2 = Integer.parseInt(m.group(2), 16);
                    if ((p1 & 0x800000) > 0) {
                        p1 = 0xFF000000 | p1;
                    }
                    DecimalFormat df = new DecimalFormat("0.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                    df.setGroupingUsed(false);
                    String strValue = "" + df.format((double)p1 + (double)p2 / 256.0);
                    m.appendReplacement(resultString, strValue);
                }
                m.appendTail(resultString);
                newText = resultString.toString();
                t2.setText(newText.replace("!", "M").replace("|", "L").replace("[", "Q"));
                updating = false;
            }
        });
        t2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (updating) {
                    return;
                }
                updating = true;
                t1.setText(t2.getText().replace("M", "!").replace("L", "|").replace("Q", "["));
                updating = false;
            }
        });
        cnt.add(new JScrollPane(t1));
        cnt.add(new JScrollPane(t2));
        fr.setVisible(true);
    }
}

