/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GraphPath
implements Serializable {
    private final List<Integer> branchIps = new ArrayList<Integer>();
    private final List<Integer> branchIndices = new ArrayList<Integer>();
    public final String rootName;

    public GraphPath(String rootName, List<Integer> branchIps, List<Integer> branchIndices) {
        this.rootName = rootName;
        this.branchIps.addAll(branchIps);
        this.branchIndices.addAll(branchIndices);
    }

    public GraphPath(List<Integer> branchIps, List<Integer> branchIndices) {
        this.rootName = "";
        this.branchIps.addAll(branchIps);
        this.branchIndices.addAll(branchIndices);
    }

    public GraphPath() {
        this.rootName = "";
    }

    public boolean startsWith(GraphPath p) {
        if (p.length() > this.length()) {
            return false;
        }
        ArrayList<Integer> otherKeys = new ArrayList<Integer>(p.branchIps);
        ArrayList<Integer> otherVals = new ArrayList<Integer>(p.branchIndices);
        for (int i = 0; i < p.length(); ++i) {
            if (!Objects.equals(this.branchIps.get(i), otherKeys.get(i))) {
                return false;
            }
            if (Objects.equals(this.branchIndices.get(i), otherVals.get(i))) continue;
            return false;
        }
        return true;
    }

    public GraphPath parent(int len) {
        GraphPath par = new GraphPath(this.rootName);
        for (int i = 0; i < len; ++i) {
            par.branchIps.add(this.branchIps.get(i));
            par.branchIndices.add(this.branchIndices.get(i));
        }
        return par;
    }

    public GraphPath sub(int branchIndex, int codePos) {
        GraphPath next = new GraphPath(this.rootName, this.branchIps, this.branchIndices);
        next.branchIps.add(codePos);
        next.branchIndices.add(branchIndex);
        return next;
    }

    public GraphPath(String rootName) {
        this.rootName = rootName;
    }

    public int length() {
        return this.branchIndices.size();
    }

    public int get(int index) {
        return this.branchIndices.get(index);
    }

    public int getKey(int index) {
        return this.branchIps.get(index);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + GraphPath.arrHashCode(this.branchIps);
        hash = 23 * hash + GraphPath.arrHashCode(this.branchIndices);
        hash = 23 * hash + Objects.hashCode(this.rootName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphPath other = (GraphPath)obj;
        if (this.rootName == null != (other.rootName == null)) {
            return false;
        }
        if (!Objects.equals(this.rootName, other.rootName)) {
            return false;
        }
        if (!GraphPath.arrMatch(this.branchIps, other.branchIps)) {
            return false;
        }
        return GraphPath.arrMatch(this.branchIndices, other.branchIndices);
    }

    private static int arrHashCode(List<Integer> arr) {
        if (arr == null || arr.isEmpty()) {
            return 0;
        }
        int hash = 5;
        for (Integer i : arr) {
            hash = 23 * hash + Objects.hashCode(i);
        }
        return hash;
    }

    private static boolean arrMatch(List<Integer> arr, List<Integer> arr2) {
        if (arr.size() != arr2.size()) {
            return false;
        }
        for (int i = 0; i < arr.size(); ++i) {
            if (Objects.equals(arr.get(i), arr2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = this.rootName;
        for (int i = 0; i < this.branchIps.size(); ++i) {
            ret = ret + "/" + this.branchIps.get(i) + ":" + this.branchIndices.get(i);
        }
        return ret;
    }
}

