/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.BranchStackResistant;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.DuplicateSourceItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import com.jpexs.decompiler.graph.model.TemporaryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TranslateStack
extends Stack<GraphTargetItem> {
    private PopItem pop;
    private final String path;
    private List<GraphTargetItem> connectedOutput = null;
    private int prevOutputSize = 0;
    private Map<String, GraphTargetItem> marks = new HashMap<String, GraphTargetItem>();
    public List<GraphTargetItem> outputQueue = new ArrayList<GraphTargetItem>();
    public BaseLocalData localData = null;

    @Override
    public synchronized Object clone() {
        TranslateStack st = (TranslateStack)super.clone();
        st.outputQueue = new ArrayList<GraphTargetItem>(this.outputQueue);
        return st;
    }

    @Override
    public void clear() {
        super.clear();
        this.outputQueue.clear();
    }

    public void setConnectedOutput(int prevOutputSize, List<GraphTargetItem> connectedOutput, BaseLocalData localData) {
        this.prevOutputSize = prevOutputSize;
        this.connectedOutput = connectedOutput;
        this.localData = localData;
    }

    @Override
    public GraphTargetItem push(GraphTargetItem item) {
        if (!this.outputQueue.isEmpty()) {
            if (item instanceof FindPropertyAVM2Item || this.isDupsOnly()) {
                this.finishBlock(this.connectedOutput);
            } else {
                this.outputQueue.add(item);
                item = new CommaExpressionItem(item.dialect, null, item.lineStartItem, this.outputQueue);
                this.outputQueue = new ArrayList<GraphTargetItem>();
            }
        }
        if (this.connectedOutput != null && item != null) {
            item.outputPos = this.prevOutputSize + this.connectedOutput.size();
        }
        return super.push(item);
    }

    private boolean isDupsOnly() {
        for (GraphTargetItem item : this) {
            if (item instanceof DuplicateItem || item instanceof DuplicateSourceItem) continue;
            return false;
        }
        return true;
    }

    public void setMark(String name, GraphTargetItem value) {
        this.marks.put(name, value);
    }

    public GraphTargetItem getMark(String name) {
        return this.marks.get(name);
    }

    public void simplify() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i).simplify(""));
        }
    }

    public TranslateStack(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    private PopItem getPop() {
        if (this.pop == null) {
            this.pop = new PopItem(null, null, null);
        }
        return this.pop;
    }

    @Override
    public synchronized GraphTargetItem get(int index) {
        if (this.path != null && (index >= this.size() || index < 0)) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attempt to Get item outside of bounds of stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.get(index);
    }

    @Override
    public synchronized GraphTargetItem peek() {
        if (this.path != null && this.isEmpty()) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attempt to Peek empty stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.peek();
    }

    public synchronized GraphTargetItem peek(int index) {
        if (this.path != null && index > this.size()) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attempt to Peek item from stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.get(this.size() - index);
    }

    @Override
    public synchronized GraphTargetItem pop() {
        if (!this.outputQueue.isEmpty()) {
            List<GraphTargetItem> oldQueue = this.outputQueue;
            this.outputQueue = new ArrayList<GraphTargetItem>();
            this.finishBlock(this.connectedOutput);
            this.connectedOutput.addAll(oldQueue);
        }
        if (this.isEmpty() && this.connectedOutput != null) {
            GraphTargetItem item;
            this.moveToStack(this.connectedOutput);
            if (!this.isEmpty()) {
                return this.pop();
            }
            for (int i = this.connectedOutput.size() - 1; i >= 0 && !((item = this.connectedOutput.get(i)) instanceof Block); --i) {
                if (!(item instanceof PushItem)) continue;
                PushItem pi = (PushItem)item;
                if (pi.value instanceof SetTemporaryItem) {
                    SetTemporaryItem st = (SetTemporaryItem)pi.value;
                    this.connectedOutput.set(i, st);
                    return new TemporaryItem(pi.dialect, pi.value.getSrc(), pi.value.getLineStartItem(), pi.value, st.tempIndex);
                }
                if (pi.value instanceof DuplicateSourceItem) {
                    DuplicateSourceItem ds = (DuplicateSourceItem)pi.value;
                    this.connectedOutput.remove(i);
                    return ds;
                }
                if (pi.value instanceof DuplicateItem) {
                    DuplicateItem d = (DuplicateItem)pi.value;
                    this.connectedOutput.remove(i);
                    return new TemporaryItem(pi.dialect, pi.value.getSrc(), pi.value.getLineStartItem(), pi.value, d.tempIndex);
                }
                if (pi.value instanceof TemporaryItem) {
                    this.connectedOutput.remove(i);
                    return pi.value;
                }
                int temp = this.localData.maxTempIndex.getVal() + 1;
                this.localData.maxTempIndex.setVal(temp);
                this.connectedOutput.set(i, new SetTemporaryItem(pi.dialect, pi.value.getSrc(), pi.value.getLineStartItem(), pi.value, temp, "push", 1));
                return new TemporaryItem(pi.dialect, pi.value.getSrc(), pi.value.getLineStartItem(), pi.value, temp);
            }
        }
        if (this.path != null && this.isEmpty()) {
            PopItem oldpop = this.getPop();
            this.pop = null;
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attempt to Pop empty stack", this.path);
            return oldpop;
        }
        return (GraphTargetItem)super.pop();
    }

    public void moveToStack(List<GraphTargetItem> output) {
        int i;
        if (!this.isEmpty()) {
            return;
        }
        for (i = output.size() - 1; i >= 0 && output.get(i) instanceof PushItem; --i) {
        }
        ++i;
        while (i < output.size()) {
            PushItem pi = (PushItem)output.remove(i);
            this.push(pi.value);
        }
    }

    private boolean isAllTemp() {
        for (int i = 0; i < this.size(); ++i) {
            GraphTargetItem item = this.get(i);
            if (item instanceof TemporaryItem || item instanceof DuplicateItem) continue;
            return false;
        }
        return true;
    }

    public void addToOutput(GraphTargetItem item) {
        if (this.isEmpty() || this.peek() instanceof ExceptionAVM2Item || this.peek() instanceof NewActivationAVM2Item) {
            this.connectedOutput.add(item);
            return;
        }
        this.outputQueue.add(item);
        if (item instanceof ExitItem) {
            this.finishBlock(this.connectedOutput);
        }
    }

    public void finishBlock(List<GraphTargetItem> output) {
        if (this.connectedOutput == null) {
            return;
        }
        int clen = output.size();
        boolean isExit = false;
        if (!this.outputQueue.isEmpty() && this.outputQueue.get(this.outputQueue.size() - 1) instanceof ExitItem) {
            isExit = true;
        }
        if (clen > 0 && output.get(clen - 1) instanceof ScriptEndItem) {
            --clen;
            isExit = true;
        }
        if (clen > 0 && output.get(clen - 1) instanceof ExitItem) {
            isExit = true;
            --clen;
        }
        if (clen > 0 && output.get(clen - 1) instanceof BreakItem) {
            --clen;
        }
        if (clen > 0 && output.get(clen - 1) instanceof ContinueItem) {
            --clen;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            GraphTargetItem p = this.get(i);
            if (p instanceof BranchStackResistant) continue;
            this.remove(i);
            if (p instanceof PopItem) continue;
            if (isExit) {
                output.add(clen, p);
                continue;
            }
            output.add(clen, new PushItem(p));
        }
        output.addAll(this.outputQueue);
        this.outputQueue.clear();
    }

    public void allowSwap(List<GraphTargetItem> output) {
        if (!this.isEmpty()) {
            return;
        }
        if (output.size() < 3) {
            return;
        }
        if (!(output.get(output.size() - 1) instanceof PushItem)) {
            return;
        }
        if (!(output.get(output.size() - 2) instanceof PushItem)) {
            return;
        }
        if (!(output.get(output.size() - 3) instanceof SetTemporaryItem)) {
            return;
        }
        PushItem pi1 = (PushItem)output.get(output.size() - 1);
        if (!(pi1.value instanceof TemporaryItem)) {
            return;
        }
        TemporaryItem ti = (TemporaryItem)pi1.value;
        SetTemporaryItem st = (SetTemporaryItem)output.get(output.size() - 3);
        if (!"swap".equals(st.getSuffix())) {
            return;
        }
        if (st.getTempIndex() != ti.getTempIndex()) {
            return;
        }
        PushItem pi2 = (PushItem)output.get(output.size() - 2);
        output.remove(output.size() - 1);
        output.remove(output.size() - 1);
        output.remove(output.size() - 1);
        this.push(pi2.value);
        this.push(ti.value);
    }
}

