/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnaryOp;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class UnaryOpItem
extends GraphTargetItem
implements UnaryOp {
    public String operator;
    protected String coerce;

    public UnaryOpItem(GraphTargetDialect dialect, GraphSourceItem instruction, GraphSourceItem lineStartItem, int precedence, GraphTargetItem value, String operator, String coerce) {
        super(dialect, instruction, lineStartItem, precedence, value);
        this.operator = operator;
        this.coerce = coerce;
    }

    @Override
    public GraphTargetItem simplify(String implicitCoerce) {
        GraphTargetItem r = this.clone();
        r.value = r.value.simplify(this.coerce);
        if (r.value == this.value) {
            r = this;
        }
        return UnaryOpItem.simplifySomething(r, implicitCoerce);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append(this.operator);
        if (this.value != null) {
            if (this.value.getPrecedence() > this.precedence) {
                writer.append("(");
                this.operandToString(this.value, writer, localData);
                writer.append(")");
            } else {
                this.operandToString(this.value, writer, localData);
            }
        } else {
            writer.append("null");
        }
        return writer;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isConvertedCompileTime(dependencies);
    }

    @Override
    public boolean isVariableComputed() {
        return this.value.isVariableComputed();
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public boolean hasSideEffect() {
        return this.value.hasSideEffect();
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphTargetItem other = (GraphTargetItem)obj;
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphTargetItem other = obj;
        return GraphTargetItem.objectsValueEquals(this.value, other.value);
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    protected void operandToString(GraphTargetItem operand, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        operand.toString(writer, localData, "", false);
    }
}

