/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.helpers.Freed;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileHashMap<K, V>
extends AbstractMap<K, V>
implements Freed {
    private static final Logger logger = Logger.getLogger(FileHashMap.class.getName());
    private final Map<K, Integer> lengths = new HashMap<K, Integer>();
    private final Map<K, Long> offsets = new HashMap<K, Long>();
    private long fileLen = 0L;
    private final RandomAccessFile file;
    private final File fileName;
    private final Set<Gap> gaps = new TreeSet<Gap>();
    private int maxGapLen = 0;
    private boolean deleted = false;

    public FileHashMap(File file) throws IOException {
        this.file = new RandomAccessFile(file, "rw");
        this.file.setLength(0L);
        this.fileName = file;
        file.deleteOnExit();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.deleted) {
            throw new NullPointerException();
        }
        return this.offsets.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        if (this.deleted) {
            throw new NullPointerException();
        }
        return this.offsets.keySet();
    }

    @Override
    public V get(Object key) {
        if (this.deleted) {
            throw new NullPointerException();
        }
        try {
            if (!this.offsets.containsKey(key)) {
                return null;
            }
            long ofs = this.offsets.get(key);
            int len = this.lengths.get(key);
            this.file.seek(ofs);
            byte[] data = new byte[len];
            this.file.readFully(data);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            try {
                Object ret = ois.readObject();
                return (V)ret;
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
                return null;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized V put(K key, V value) {
        Iterator<Gap> i;
        byte[] data;
        if (this.deleted) {
            throw new NullPointerException();
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            data = baos.toByteArray();
            if (this.offsets.containsKey(key)) {
                long origOffset = this.offsets.get(key);
                int origLen = this.lengths.get(key);
                if (data.length <= origLen) {
                    this.file.seek(origOffset);
                    this.file.write(data);
                    this.lengths.put(key, data.length);
                    if (data.length < origLen) {
                        Gap g = new Gap(origOffset + (long)data.length, origLen - data.length);
                        if (g.length > this.maxGapLen) {
                            this.maxGapLen = g.length;
                        }
                        this.gaps.add(g);
                    }
                    V v = value;
                    return v;
                }
            }
            if (data.length > this.maxGapLen) {
                this.file.seek(this.fileLen);
                this.file.write(data);
                this.offsets.put(key, this.fileLen);
                this.lengths.put(key, data.length);
                this.fileLen += (long)data.length;
                return value;
            }
            i = this.gaps.iterator();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return value;
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
        while (i.hasNext()) {
            Gap g = i.next();
            if (g.length < data.length) continue;
            this.file.seek(g.offset);
            this.file.write(data);
            this.offsets.put(key, g.offset);
            this.lengths.put(key, g.length);
            if (g.length > data.length) {
                g.offset += (long)data.length;
                g.length -= data.length;
                continue;
            }
            i.remove();
        }
        return value;
    }

    @Override
    public V remove(Object objKey) {
        if (this.deleted) {
            throw new NullPointerException();
        }
        Object key = objKey;
        if (!this.containsKey(key)) {
            return null;
        }
        V val = this.get(key);
        Gap g = new Gap(this.offsets.get(key), this.lengths.get(key));
        this.offsets.remove(key);
        this.lengths.remove(key);
        if (g.offset + (long)g.length == this.fileLen) {
            this.fileLen -= (long)g.length;
        } else {
            if (g.length > this.maxGapLen) {
                this.maxGapLen = g.length;
            }
            this.gaps.add(g);
        }
        return val;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.deleted) {
            throw new NullPointerException();
        }
        HashSet<Map.Entry<K, V>> ret = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keySet()) {
            ret.add(new FileEntry(this, key));
        }
        return ret;
    }

    @Override
    public void clear() {
        if (this.deleted) {
            throw new NullPointerException();
        }
        this.offsets.clear();
        this.lengths.clear();
        this.fileLen = 0L;
        this.maxGapLen = 0;
        try {
            this.file.setLength(0L);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void delete() {
        if (this.deleted) {
            throw new NullPointerException();
        }
        try {
            this.file.close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.fileName.delete();
        this.deleted = true;
    }

    @Override
    public boolean isFreeing() {
        return !this.deleted;
    }

    @Override
    public void free() {
        if (!this.deleted) {
            this.delete();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.offsets.isEmpty();
    }

    @Override
    public int size() {
        return this.offsets.size();
    }

    public static class FileEntry<K, V>
    implements Map.Entry<K, V> {
        private final FileHashMap<K, V> parent;
        private final K key;

        public FileEntry(FileHashMap<K, V> parent, K key) {
            this.parent = parent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.parent.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return this.parent.put(this.key, value);
        }
    }

    private static class Gap
    implements Comparable<Gap> {
        public long offset;
        public int length;

        public Gap(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int compareTo(Gap o) {
            return o.length - this.length;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (int)(this.offset ^ this.offset >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Gap other = (Gap)obj;
            return this.offset == other.offset;
        }
    }
}

