/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers.stat;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.helpers.Stopwatch;
import com.jpexs.helpers.stat.StatisticData;
import java.util.HashMap;
import java.util.Map;

public class Statistics
implements AutoCloseable {
    private static final Map<String, StatisticData> map = new HashMap<String, StatisticData>();
    private final String name;
    private final Stopwatch sw;

    private static synchronized void addTime(String name, long duration) {
        StatisticData s = map.get(name);
        if (s == null) {
            s = new StatisticData();
            map.put(name, s);
        }
        s.value += duration;
        if (duration > s.max) {
            s.max = duration;
        }
        if (duration < s.min) {
            s.min = duration;
        }
        ++s.count;
    }

    public static synchronized void addToMap(Map<String, StatisticData> targetMap) {
        for (Map.Entry<String, StatisticData> e : map.entrySet()) {
            String name = e.getKey();
            StatisticData d = e.getValue();
            StatisticData d2 = targetMap.get(name);
            if (d2 == null) {
                d2 = new StatisticData();
                targetMap.put(name, d2);
            }
            d2.value += d.value;
            d2.count += d.count;
            if (d.max > d2.max) {
                d2.max = d.max;
            }
            if (d.min >= d2.min) continue;
            d2.min = d.min;
        }
    }

    public static synchronized void print() {
        Statistics.print(map);
    }

    public static synchronized void print(Map<String, StatisticData> map) {
        for (Map.Entry<String, StatisticData> e : map.entrySet()) {
            String name = e.getKey();
            StatisticData d = e.getValue();
            System.out.println(name + ": count: " + d.count + " / total: " + d.value / 1000000L + "ms / min: " + d.min / 1000L + "us / max: " + d.max / 1000L + "us / avg: " + d.value / (long)d.count / 1000L + "us");
        }
    }

    public static synchronized void clear() {
        map.clear();
    }

    public Statistics(String name) {
        this.name = name;
        this.sw = Configuration.showStat ? Stopwatch.startNew() : null;
    }

    @Override
    public void close() {
        if (this.sw != null) {
            this.sw.stop();
            Statistics.addTime(this.name, this.sw.getElapsedNanoseconds());
        }
    }
}

