/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers.utf8.charset;

import com.jpexs.helpers.utf8.charset.AbstractCharsetConverter;
import java.nio.charset.Charset;

public class ShiftJis
extends AbstractCharsetConverter {
    private static final Charset SHIFT_JIS_ENCODING = Charset.forName("Shift_JIS");

    @Override
    public int toUnicode(int codePoint) {
        byte[] b = codePoint > 255 ? new byte[]{(byte)(codePoint >> 8 & 0xFF), (byte)(codePoint & 0xFF)} : new byte[]{(byte)codePoint};
        return new String(b, SHIFT_JIS_ENCODING).charAt(0);
    }

    @Override
    public int fromUnicode(int codePoint) {
        byte[] b = ("" + (char)codePoint).getBytes(SHIFT_JIS_ENCODING);
        int r = 0;
        for (int i = 0; i < b.length; ++i) {
            int v = b[b.length - 1 - i] & 0xFF;
            r += v << 8 * i;
        }
        return r;
    }
}

