/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.text.LockBorder;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;

public class SubstanceTextUtilities {
    public static final String ENFORCE_FG_COLOR = "substancelaf.internal.textUtilities.enforceFgColor";

    public static void paintTextWithDropShadow(JComponent c, Graphics g, Color foregroundColor, String text, int width, int height, int xOffset, int yOffset) {
        Graphics2D graphics = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics, (Component)c);
        AffineTransform t = graphics.getTransform();
        if (t == null) {
            t = new AffineTransform();
        }
        Point2D.Double p = new Point2D.Double(width, height);
        Point2D.Double p2 = new Point2D.Double();
        t.transform(p, p2);
        if (((Point2D)p2).getX() <= 0.0 || ((Point2D)p2).getY() <= 0.0) {
            return;
        }
        BufferedImage blurred = SubstanceCoreUtilities.getBlankImage((int)((int)Math.round(((Point2D)p2).getX())), (int)((int)Math.round(((Point2D)p2).getY())));
        Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
        gBlurred.setTransform(graphics.getTransform());
        gBlurred.setFont(graphics.getFont());
        gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float luminFactor = SubstanceColorUtilities.getColorStrength((Color)foregroundColor);
        gBlurred.setColor(SubstanceColorUtilities.getNegativeColor((Color)foregroundColor));
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.02f, 0.05f, 0.02f, 0.05f, 0.02f, 0.05f, 0.02f, 0.05f, 0.02f}), 1, null);
        gBlurred.drawString(text, xOffset, yOffset - 1);
        blurred = convolve.filter(blurred, null);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, (float)luminFactor, (Graphics)g));
        AffineTransform ot = graphics.getTransform();
        graphics.setTransform(new AffineTransform());
        graphics.drawImage((Image)blurred, 0, 0, null);
        graphics.setTransform(ot);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, (Graphics)g));
        FontMetrics fm = graphics.getFontMetrics();
        SubstanceTextUtilities.paintText(graphics, c, new Rectangle(xOffset, yOffset - fm.getAscent(), width - xOffset, fm.getHeight()), text, -1, graphics.getFont(), foregroundColor, graphics.getClipBounds());
        graphics.dispose();
    }

    private static void paintText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, AffineTransform transform) {
        if (text == null || text.length() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(font);
        g2d.setColor(color);
        if (clip != null) {
            g2d.clip(clip);
        }
        if (transform != null) {
            g2d.transform(transform);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, textRect.x, textRect.y + g2d.getFontMetrics().getAscent());
        g2d.dispose();
    }

    public static void paintText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip) {
        SubstanceTextUtilities.paintText(g, comp, textRect, text, mnemonicIndex, font, color, clip, null);
    }

    public static void paintVerticalText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, boolean isFromBottomToTop) {
        if (text == null || text.length() == 0) {
            return;
        }
        AffineTransform at = null;
        if (!isFromBottomToTop) {
            at = AffineTransform.getTranslateInstance(textRect.x + textRect.width, textRect.y);
            at.rotate(1.5707963267948966);
        } else {
            at = AffineTransform.getTranslateInstance(textRect.x, textRect.y + textRect.height);
            at.rotate(-1.5707963267948966);
        }
        Rectangle newRect = new Rectangle(0, 0, textRect.width, textRect.height);
        SubstanceTextUtilities.paintText(g, comp, newRect, text, mnemonicIndex, font, color, clip, at);
    }

    public static void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text, int mnemonicIndex) {
        SubstanceTextUtilities.paintText(g, button, button.getModel(), textRect, text, mnemonicIndex);
    }

    public static void paintText(Graphics g, AbstractButton button, ButtonModel model, Rectangle textRect, String text, int mnemonicIndex) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)button, (ComponentState)ComponentState.getState((AbstractButton)button));
        if (button instanceof JMenuItem) {
            SubstanceTextUtilities.paintMenuItemText(g, (JMenuItem)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), buttonAlpha);
        } else {
            SubstanceTextUtilities.paintText(g, (JComponent)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), buttonAlpha);
        }
    }

    public static void paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, ComponentState state, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getForegroundColor(component, text, state, textAlpha);
        SubstanceTextUtilities.paintText(g, component, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
    }

    public static void paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getForegroundColor(component, text, modelStateInfo, textAlpha);
        SubstanceTextUtilities.paintText(g, component, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
    }

    public static void paintMenuItemText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getMenuComponentForegroundColor(menuItem, text, modelStateInfo, textAlpha);
        SubstanceTextUtilities.paintText(g, menuItem, textRect, text, mnemonicIndex, menuItem.getFont(), fgColor, null);
    }

    public static Color getForegroundColor(JComponent component, String text, ComponentState state, float textAlpha) {
        Color fgColor;
        if (text == null || text.length() == 0) {
            return null;
        }
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null || Boolean.TRUE.equals(component.getClientProperty(ENFORCE_FG_COLOR));
        Color color = fgColor = toEnforceFgColor ? component.getForeground() : SubstanceColorSchemeUtilities.getColorScheme((Component)component, (ComponentState)state).getForegroundColor();
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)component);
            fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)textAlpha);
        }
        return fgColor;
    }

    public static Color getForegroundColor(JComponent component, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        if (text == null || text.length() == 0) {
            return null;
        }
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null || Boolean.TRUE.equals(component.getClientProperty(ENFORCE_FG_COLOR));
        Color fgColor = null;
        fgColor = toEnforceFgColor ? component.getForeground() : SubstanceColorUtilities.getForegroundColor((Component)component, (StateTransitionTracker.ModelStateInfo)modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)component);
            fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)textAlpha);
        }
        return fgColor;
    }

    public static Color getMenuComponentForegroundColor(Component menuComponent, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Color fgColor = SubstanceColorUtilities.getMenuComponentForegroundColor((Component)menuComponent, (StateTransitionTracker.ModelStateInfo)modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)menuComponent);
            fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)textAlpha);
        }
        return fgColor;
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp) {
        Color backgroundFillColor = SubstanceTextUtilities.getTextBackgroundFillColor(comp);
        boolean toPaintWatermark = SubstanceLookAndFeel.getCurrentSkin((Component)comp).getWatermark() != null && (SubstanceCoreUtilities.toDrawWatermark((Component)comp) || !comp.isOpaque());
        SubstanceTextUtilities.paintTextCompBackground(g, comp, backgroundFillColor, toPaintWatermark);
    }

    public static Color getTextBackgroundFillColor(JComponent comp) {
        TextUI ui;
        Color backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)comp);
        JTextComponent componentForTransitions = SubstanceCoreUtilities.getTextComponentForTransitions((Component)comp);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)ui;
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            Color outerTextComponentBorderColor = SubstanceColorUtilities.getOuterTextComponentBorderColor((Color)backgroundFillColor);
            outerTextComponentBorderColor = SubstanceColorUtilities.getInterpolatedColor((Color)outerTextComponentBorderColor, (Color)backgroundFillColor, (double)0.6);
            float selectionStrength = stateTransitionTracker.getFacetStrength(ComponentStateFacet.SELECTION);
            float rolloverStrength = stateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER);
            backgroundFillColor = SubstanceColorUtilities.getInterpolatedColor((Color)outerTextComponentBorderColor, (Color)backgroundFillColor, (double)Math.max(selectionStrength, rolloverStrength));
        }
        return backgroundFillColor;
    }

    private static void paintTextCompBackground(Graphics g, JComponent comp, Color backgr, boolean toOverlayWatermark) {
        boolean isSubstanceBorder;
        Graphics2D g2d = (Graphics2D)g.create();
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize((Component)comp);
        int borderDelta = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth((int)componentFontSize));
        Border compBorder = comp.getBorder();
        if (compBorder instanceof LockBorder) {
            compBorder = ((LockBorder)compBorder).getOriginalBorder();
        }
        if (!(isSubstanceBorder = compBorder instanceof SubstanceTextComponentBorder)) {
            Border border = compBorder;
            while (border instanceof CompoundBorder) {
                Border outer = ((CompoundBorder)border).getOutsideBorder();
                if (outer instanceof SubstanceTextComponentBorder) {
                    isSubstanceBorder = true;
                    break;
                }
                Border inner = ((CompoundBorder)border).getInsideBorder();
                if (inner instanceof SubstanceTextComponentBorder) {
                    isSubstanceBorder = true;
                    break;
                }
                border = inner;
            }
        }
        Rectangle contour = isSubstanceBorder ? SubstanceOutlineUtilities.getBaseOutline((int)comp.getWidth(), (int)comp.getHeight(), (float)Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius((int)componentFontSize) - (float)borderDelta), null, (int)borderDelta) : new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
        BackgroundPaintingUtils.update((Graphics)g, (Component)comp, (boolean)false);
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin((Component)comp).getWatermark();
        if (watermark != null) {
            watermark.drawWatermarkImage((Graphics)g2d, (Component)comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.setColor(backgr);
        g2d.fill(contour);
        if (toOverlayWatermark && watermark != null) {
            g2d.clip(contour);
            watermark.drawWatermarkImage((Graphics)g2d, (Component)comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.dispose();
    }
}

