/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.cfb;

public class RedBlackTree<T extends Comparable<T>> {
    private Node<T> root;
    private final Node<T> TNULL = new Node<Object>(null);

    public RedBlackTree() {
        this.TNULL.color = Color.BLACK;
        this.root = this.TNULL;
    }

    private void preOrderHelper(Node<T> node) {
        if (node != this.TNULL) {
            System.out.print(node.data + " ");
            this.preOrderHelper(node.left);
            this.preOrderHelper(node.right);
        }
    }

    public void preorder() {
        this.preOrderHelper(this.root);
    }

    private void inOrderHelper(Node<T> node) {
        if (node != this.TNULL) {
            this.inOrderHelper(node.left);
            System.out.print(node.data + " ");
            this.inOrderHelper(node.right);
        }
    }

    public void inorder() {
        this.inOrderHelper(this.root);
    }

    private void postOrderHelper(Node<T> node) {
        if (node != this.TNULL) {
            this.postOrderHelper(node.left);
            this.postOrderHelper(node.right);
            System.out.print(node.data + " ");
        }
    }

    public void postorder() {
        this.postOrderHelper(this.root);
    }

    private void leftRotate(Node<T> x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.TNULL) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    private void rightRotate(Node<T> x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.TNULL) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.right) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
    }

    public void insert(T key) {
        Node<T> node = new Node<T>(key);
        node.parent = null;
        node.left = this.TNULL;
        node.right = this.TNULL;
        node.color = Color.RED;
        Node<T> y = null;
        Node<Object> x = this.root;
        while (x != this.TNULL) {
            y = x;
            if (node.data.compareTo(x.data) < 0) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        node.parent = y;
        if (y == null) {
            this.root = node;
        } else if (node.data.compareTo(y.data) < 0) {
            y.left = node;
        } else {
            y.right = node;
        }
        if (node.parent == null) {
            node.color = Color.BLACK;
            return;
        }
        if (node.parent.parent == null) {
            return;
        }
        this.fixInsert(node);
    }

    private void fixInsert(Node<T> k) {
        while (k.parent.color == Color.RED) {
            Node u;
            if (k.parent == k.parent.parent.right) {
                u = k.parent.parent.left;
                if (u.color == Color.RED) {
                    u.color = Color.BLACK;
                    k.parent.color = Color.BLACK;
                    k.parent.parent.color = Color.RED;
                    k = k.parent.parent;
                } else {
                    if (k == k.parent.left) {
                        k = k.parent;
                        this.rightRotate(k);
                    }
                    k.parent.color = Color.BLACK;
                    k.parent.parent.color = Color.RED;
                    this.leftRotate(k.parent.parent);
                }
            } else {
                u = k.parent.parent.right;
                if (u.color == Color.RED) {
                    u.color = Color.BLACK;
                    k.parent.color = Color.BLACK;
                    k.parent.parent.color = Color.RED;
                    k = k.parent.parent;
                } else {
                    if (k == k.parent.right) {
                        k = k.parent;
                        this.leftRotate(k);
                    }
                    k.parent.color = Color.BLACK;
                    k.parent.parent.color = Color.RED;
                    this.rightRotate(k.parent.parent);
                }
            }
            if (k != this.root) continue;
        }
        this.root.color = Color.BLACK;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public static void main(String[] args) {
        RedBlackTree<Integer> tree = new RedBlackTree<Integer>();
        tree.insert(55);
        tree.insert(40);
        tree.insert(65);
        tree.insert(60);
        tree.insert(75);
        tree.insert(57);
        System.out.println("Preorder traversal:");
        tree.preorder();
        System.out.println("\nInorder traversal:");
        tree.inorder();
        System.out.println("\nPostorder traversal:");
        tree.postorder();
    }

    public static class Node<N extends Comparable<N>> {
        N data;
        Node<N> left;
        Node<N> right;
        Node<N> parent;
        Color color;

        public Node(N data) {
            this.data = data;
            this.color = Color.RED;
            this.left = null;
            this.right = null;
            this.parent = null;
        }
    }

    public static enum Color {
        RED,
        BLACK;

    }
}

