/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter;

import com.jpexs.flash.fla.converter.FlaFormatVersion;
import com.jpexs.flash.fla.converter.Matrix;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlaWriter {
    public static int EDGESELECTION_FILL0 = 1;
    public static int EDGESELECTION_FILL1 = 2;
    public static int EDGESELECTION_STROKE = 4;
    public static int FLAG_EDGE_NO_SELECTION = 128;
    public static int FLAG_EDGE_HAS_STYLES = 64;
    public static int FLAG_EDGE_FROM_FLOAT = 2;
    public static int FLAG_EDGE_FROM_SHORT = 3;
    public static int FLAG_EDGE_FROM_BYTE = 1;
    public static int FLAG_EDGE_FROM_MASK = FLAG_EDGE_FROM_SHORT;
    public static int FLAG_EDGE_CONTROL_FLOAT = 8;
    public static int FLAG_EDGE_CONTROL_SHORT = 12;
    public static int FLAG_EDGE_CONTROL_BYTE = 4;
    public static int FLAG_EDGE_TO_FLOAT = 32;
    public static int FLAG_EDGE_TO_SHORT = 48;
    public static int FLAG_EDGE_TO_BYTE = 16;
    public static int FLAG_EDGE_TO_MASK = FLAG_EDGE_TO_SHORT;
    public static int KEYMODE_STANDARD = 9728;
    public static int SCALEMODE_NORMAL = 0;
    public static int SCALEMODE_HORIZONTAL = 1;
    public static int SCALEMODE_VERTICAL = 2;
    public static int SCALEMODE_NONE = 3;
    public static int CAPSTYLE_NONE = 0;
    public static int CAPSTYLE_ROUND = 1;
    public static int CAPSTYLE_SQUARE = 2;
    public static int JOINSTYLE_MITER = 0;
    public static int JOINSTYLE_ROUND = 1;
    public static int JOINSTYLE_BEVEL = 2;
    public static final int FLOW_EXTEND = 0;
    public static final int FLOW_REFLECT = 4;
    public static final int FLOW_REPEAT = 8;
    public static final int FILLTYPE_LINEAR_GRADIENT = 16;
    public static final int FILLTYPE_RADIAL_GRADIENT = 18;
    public static final int FILLTYPE_BITMAP = 64;
    public static final int FILLTYPE_CLIPPED_BITMAP = 65;
    public static final int FILLTYPE_NON_SMOOTHED_BITMAP = 66;
    public static final int FILLTYPE_NON_SMOOTHED_CLIPPED_BITMAP = 67;
    public static final int SYMBOLTYPE_MOVIE_CLIP = 0;
    public static final int SYMBOLTYPE_BUTTON = 1;
    public static final int SYMBOLTYPE_GRAPHIC = 2;
    public static final int LOOPMODE_LOOP = 1;
    public static final int LOOPMODE_PLAY_ONCE = 2;
    public static final int LOOPMODE_SINGLE_FRAME = 3;
    public static final int LAYERTYPE_LAYER = 0;
    public static final int LAYERTYPE_GUIDE = 1;
    public static final int LAYERTYPE_GUIDED = 2;
    public static final int LAYERTYPE_FOLDER = 3;
    public static final int LAYERTYPE_MASK = 4;
    private String x = "0";
    private String y = "0";
    private int strokeStyle = 0;
    private int fillStyle0 = 0;
    private int fillStyle1 = 0;
    private boolean stylesChanged = false;
    private boolean moved = false;
    private String moveX = null;
    private String moveY = null;
    private int edgeSelection = 0;
    private static final Logger logger = Logger.getLogger(FlaWriter.class.getName());
    private OutputStream os;
    private boolean debugRandom = false;
    private final FlaFormatVersion flaFormatVersion;
    private long pos = 0L;
    private String title = "";
    private final String charset;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDebugRandom(boolean debugRandom) {
        this.debugRandom = debugRandom;
    }

    public boolean isDebugRandom() {
        return this.debugRandom;
    }

    public FlaWriter(OutputStream os, FlaFormatVersion flaFormatVersion, String charset) {
        this.os = os;
        this.flaFormatVersion = flaFormatVersion;
        this.charset = charset;
    }

    public void writeFloat(float val) throws IOException {
        this.writeUI32(Float.floatToIntBits(val));
    }

    public void writeDouble(double val) throws IOException {
        this.writeUI64(Double.doubleToLongBits(val));
    }

    public void beginShape() {
        this.stylesChanged = true;
        this.moved = false;
        this.x = "0";
        this.y = "0";
        this.edgeSelection = 0;
    }

    public void setStrokeStyle(int strokeStyle) {
        if (this.strokeStyle != strokeStyle) {
            this.stylesChanged = true;
        }
        this.strokeStyle = strokeStyle;
    }

    public void setFillStyle0(int fillStyle0) {
        if (this.fillStyle0 != fillStyle0) {
            this.stylesChanged = true;
        }
        this.fillStyle0 = fillStyle0;
    }

    public void setFillStyle1(int fillStyle1) {
        if (this.fillStyle1 != fillStyle1) {
            this.stylesChanged = true;
        }
        this.fillStyle1 = fillStyle1;
    }

    public static int getEdgesCount(String edges) throws IOException {
        edges = edges.replaceAll("[ \r\n\t\f]+", " ");
        edges = edges.replaceAll("([^ ])([!\\[\\|/])", "$1 $2");
        edges = edges.replaceAll("([!\\[\\|/])([^ ])", "$1 $2");
        if ((edges = edges.trim()).isEmpty()) {
            return 0;
        }
        if (!edges.startsWith("!")) {
            throw new IllegalArgumentException("edges must start with !");
        }
        String[] moveToParts = edges.split("!", -1);
        int totalEdges = 0;
        for (int m = 1; m < moveToParts.length; ++m) {
            String moveToPart = moveToParts[m].trim();
            String[] parts = moveToPart.split(" ", -1);
            if (1 >= parts.length) {
                throw new IllegalArgumentException("! requires two arguments");
            }
            block10: for (int i = 2; i < parts.length; ++i) {
                switch (parts[i]) {
                    case "|": 
                    case "/": {
                        if (i + 2 >= parts.length) {
                            throw new IllegalArgumentException(parts[i] + " requires two arguments");
                        }
                        i += 2;
                        ++totalEdges;
                        continue block10;
                    }
                    case "[": {
                        if (i + 4 >= parts.length) {
                            throw new IllegalArgumentException("[ requires four arguments");
                        }
                        i += 4;
                        ++totalEdges;
                    }
                }
            }
        }
        return totalEdges;
    }

    public void writeEdges(String edges, int strokeStyle, int fillStyle0, int fillStyle1) throws IOException {
        this.setStrokeStyle(strokeStyle);
        this.setFillStyle0(fillStyle0);
        this.setFillStyle1(fillStyle1);
        edges = edges.replaceAll("[ \r\n\t\f]+", " ");
        edges = edges.replaceAll("([^ ])([!\\[\\|/])", "$1 $2");
        edges = edges.replaceAll("([!\\[\\|/])([^ ])", "$1 $2");
        edges = edges.trim();
        if (edges.isEmpty()) {
            return;
        }
        if (!edges.startsWith("!")) {
            throw new IllegalArgumentException("edges must start with !");
        }
        String[] moveToParts = edges.split("!", -1);
        for (int m = 1; m < moveToParts.length; ++m) {
            String moveToPart = moveToParts[m].trim();
            String[] parts = moveToPart.split(" ", -1);
            if (1 >= parts.length) {
                throw new IllegalArgumentException("! requires two arguments");
            }
            int selection = 0;
            if (parts[1].contains("S")) {
                selection = Integer.parseInt(parts[1].substring(parts[1].indexOf("S") + 1));
                parts[1] = parts[1].substring(0, parts[1].indexOf("S"));
            }
            try {
                this.moveTo(selection, parts[0], parts[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("! has invalid arguments: " + parts[0] + ", " + parts[1]);
            }
            block16: for (int i = 2; i < parts.length; ++i) {
                switch (parts[i]) {
                    case "|": 
                    case "/": {
                        if (i + 2 >= parts.length) {
                            throw new IllegalArgumentException(parts[i] + " requires two arguments");
                        }
                        try {
                            this.lineTo(parts[i + 1], parts[i + 2], parts[i].equals("/"));
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException(parts[i] + " has invalid arguments: " + parts[i + 1] + ", " + parts[i + 2]);
                        }
                        i += 2;
                        continue block16;
                    }
                    case "[": {
                        if (i + 4 >= parts.length) {
                            throw new IllegalArgumentException("[ requires four arguments");
                        }
                        try {
                            this.curveTo(parts[i + 1], parts[i + 2], parts[i + 3], parts[i + 4]);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("[ has invalid arguments: " + parts[i + 1] + ", " + parts[i + 2] + ", " + parts[i + 3] + ", " + parts[i + 4]);
                        }
                        i += 4;
                    }
                }
            }
        }
    }

    public void writeEdge(int selection, String fromX, String fromY, String toX, String toY, String controlX, String controlY, boolean generalLine) throws IOException {
        int type = 0;
        if (controlX != null && controlY != null) {
            type = this.fitsXYByte(controlX, controlY) ? (type |= FLAG_EDGE_CONTROL_BYTE) : (this.fitsXYShort(controlX, controlY) ? (type |= FLAG_EDGE_CONTROL_SHORT) : (type |= FLAG_EDGE_CONTROL_FLOAT));
        }
        if (!(fromX == null || fromY == null || fromX.equals("0") && fromY.equals("0"))) {
            type = this.fitsXYByte(fromX, fromY) ? (type |= FLAG_EDGE_FROM_BYTE) : (this.fitsXYShort(fromX, fromY) ? (type |= FLAG_EDGE_FROM_SHORT) : (type |= FLAG_EDGE_FROM_FLOAT));
        }
        type = this.fitsXYByte(toX, toY) ? (type |= FLAG_EDGE_TO_BYTE) : (this.fitsXYShort(toX, toY) ? (type |= FLAG_EDGE_TO_SHORT) : (type |= FLAG_EDGE_TO_FLOAT));
        if (this.stylesChanged) {
            type |= FLAG_EDGE_HAS_STYLES;
            if (selection == 0) {
                type |= FLAG_EDGE_NO_SELECTION;
            }
        }
        logger.log(Level.FINE, "writing type 0x{0} ({1}{2}{3})", new Object[]{String.format("%02X", type), this.stylesChanged ? "style + " : "", fromX != null && fromY != null && (!fromX.equals("0") || !fromY.equals("0")) ? "move + " : "", controlX != null ? "curve" : "straight"});
        this.write(type);
        if (this.stylesChanged) {
            logger.log(Level.FINE, "writing style 0x{0} 0x{1} 0x{2}", new Object[]{String.format("%02X", this.strokeStyle), String.format("%02X", this.fillStyle0), String.format("%02X", this.fillStyle1)});
            this.write(this.strokeStyle);
            if (selection != 0) {
                if ((selection & EDGESELECTION_STROKE) == EDGESELECTION_STROKE) {
                    this.write(128);
                } else {
                    this.write(0);
                }
            }
            this.write(this.fillStyle0);
            if (selection != 0) {
                if ((selection & EDGESELECTION_FILL0) == EDGESELECTION_FILL0) {
                    this.write(128);
                } else {
                    this.write(0);
                }
            }
            this.write(this.fillStyle1);
            if (selection != 0) {
                if ((selection & EDGESELECTION_FILL1) == EDGESELECTION_FILL1) {
                    this.write(128);
                } else {
                    this.write(0);
                }
            }
            this.stylesChanged = false;
        }
        if (!(fromX == null || fromY == null || fromX.equals("0") && fromY.equals("0"))) {
            this.writeXY(fromX, fromY);
        }
        if (controlX != null && controlY != null) {
            this.writeXY(controlX, controlY);
        }
        if (toX != null && toY != null) {
            this.writeXY(toX, toY);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal() && controlX == null) {
            logger.log(Level.FINE, "writing generalLineFlag {0}", generalLine ? 1 : 0);
            this.write(generalLine ? 1 : 0);
        }
        this.moved = false;
    }

    public boolean fitsXYByte(String x, String y) {
        double vx = this.parseEdge(x);
        double vy = this.parseEdge(y);
        long integerX = (long)Math.floor(vx);
        long integerY = (long)Math.floor(vy);
        int fractX = (int)Math.floor((vx - (double)integerX) * 256.0);
        int fractY = (int)Math.floor((vy - (double)integerY) * 256.0);
        return integerX >= -128L && integerX <= 127L && integerY >= -128L && integerY <= 127L;
    }

    public boolean fitsXYShort(String x, String y) {
        double vx = this.parseEdge(x);
        double vy = this.parseEdge(y);
        long integerX = (long)Math.floor(vx);
        long integerY = (long)Math.floor(vy);
        int fractX = (int)Math.floor((vx - (double)integerX) * 256.0);
        int fractY = (int)Math.floor((vy - (double)integerY) * 256.0);
        try {
            int nBits = 15;
            int min = -(1 << nBits - 1);
            int max = (1 << nBits - 1) - 1;
            if (!(integerX < (long)min || integerX > (long)max || integerY < (long)min || integerY > (long)max || fractX != 0 && fractX != 128 || fractY != 0 && fractY != 128)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void writeXY(String x, String y) throws IOException {
        double vx = this.parseEdge(x);
        double vy = this.parseEdge(y);
        int integerX = (int)Math.floor(vx);
        int integerY = (int)Math.floor(vy);
        int fractX = (int)Math.floor((vx - (double)integerX) * 256.0);
        int fractY = (int)Math.floor((vy - (double)integerY) * 256.0);
        if (integerX >= -128 && integerX <= 127 && integerY >= -128 && integerY <= 127) {
            logger.log(Level.FINE, "writing as byte 0x00 0X{0} 0x00 0x{1} ({2,number,#}, {3,number,#})", new Object[]{String.format("%02X", integerX & 0xFF), String.format("%02X", integerY & 0xFF), integerX, integerY});
            this.write(fractX);
            this.write(integerX);
            this.write(fractY);
            this.write(integerY);
            return;
        }
        int shortNBits = 15;
        int minShort = -(1 << shortNBits - 1);
        int maxShort = (1 << shortNBits - 1) - 1;
        if (!(integerX < minShort || integerX > maxShort || integerY < minShort || integerY > maxShort || fractX != 0 && fractX != 128 || fractY != 0 && fractY != 128)) {
            logger.log(Level.FINE, "writing as short 0x{0} 0x{1} 0x{2} 0x{3} ({4,number,#}, {5,number,#})", new Object[]{String.format("%02X", integerX << 1 & 0xFF), String.format("%02X", integerX >> 7 & 0xFF), String.format("%02X", integerY << 1 & 0xFF), String.format("%02X", integerY >> 7 & 0xFF), integerX, integerY});
            integerX = (int)Math.floor(vx * 2.0);
            integerY = (int)Math.floor(vy * 2.0);
            this.write(integerX & 0xFF);
            this.write(integerX >> 8 & 0xFF);
            this.write(integerY & 0xFF);
            this.write(integerY >> 8 & 0xFF);
            return;
        }
        int intNBits = 24;
        int minInt = -(1 << intNBits - 1);
        int maxInt = (1 << intNBits - 1) - 1;
        if (integerX < minInt || integerX > maxInt || integerY < minInt || integerY > maxInt) {
            throw new NumberFormatException("cannot store XY values: " + x + ", " + y);
        }
        logger.log(Level.FINE, "writing as fract 0x{0} 0x{1} 0x{2} 0x{3} 0x{4} 0x{5} 0x{6} 0x{7} ({8,number,#}.{9,number,#},{10,number,#}.{11,number,#} )", new Object[]{String.format("%02X", fractX), String.format("%02X", integerX & 0xFF), String.format("%02X", integerX >> 8 & 0xFF), String.format("%02X", integerX >> 16 & 0xFF), String.format("%02X", fractY), String.format("%02X", integerY & 0xFF), String.format("%02X", integerY >> 8 & 0xFF), String.format("%02X", integerY >> 16 & 0xFF), integerX, fractX, integerY, fractY});
        this.write(fractX);
        this.write(integerX & 0xFF);
        this.write(integerX >> 8 & 0xFF);
        this.write(integerX >> 16 & 0xFF);
        this.write(fractY);
        this.write(integerY & 0xFF);
        this.write(integerY >> 8 & 0xFF);
        this.write(integerY >> 16 & 0xFF);
    }

    public void moveTo(int selection, String x, String y) {
        this.moved = true;
        this.moveX = x;
        this.moveY = y;
        this.edgeSelection = selection;
    }

    public Point2D parsePoint(String pointData) {
        if (pointData.isEmpty()) {
            return new Point2D.Double(0.0, 0.0);
        }
        String[] parts = pointData.split(",", -1);
        if (parts.length != 2) {
            return null;
        }
        return new Point2D.Double(this.parseEdge(parts[0].trim()), this.parseEdge(parts[1].trim()));
    }

    private double parseEdge(String edge) {
        Pattern doubleHexPattern = Pattern.compile("#(?<before>[a-fA-F0-9]+){1,6}(\\.(?<after>[0-9a-fA-F]{1,2}))?");
        Matcher m = doubleHexPattern.matcher(edge);
        if (m.matches()) {
            String before = m.group("before");
            String after = m.group("after");
            int afterInt = 0;
            if (after != null) {
                if (after.length() == 1) {
                    after = after + "0";
                }
                afterInt = Integer.parseInt(after, 16);
            }
            int beforeInt = Integer.parseInt(before, 16);
            beforeInt = beforeInt << 8 >> 8;
            return (double)beforeInt + (double)afterInt / 256.0;
        }
        return Double.parseDouble(edge);
    }

    private String numEdgeToString(double value) {
        if (value == Math.floor(value)) {
            long lval = (long)value;
            return "" + lval;
        }
        long integerPart = (long)Math.floor(value);
        double fractionalPart = value - (double)integerPart;
        int fractionalPart256 = (int)Math.floor(fractionalPart * 256.0);
        String h = Long.toHexString(integerPart).toUpperCase();
        if (h.length() > 6) {
            h = h.substring(h.length() - 6, h.length());
        }
        return "#" + h + "." + String.format("%02X", fractionalPart256);
    }

    private String deltaEdge(String v1, String v2) {
        return this.numEdgeToString(this.parseEdge(v1) - this.parseEdge(v2));
    }

    public void lineTo(String x2, String y2, boolean generalLine) throws IOException {
        String newX = this.moved ? this.moveX : this.x;
        String newY = this.moved ? this.moveY : this.y;
        this.writeEdge(this.moved ? this.edgeSelection : 0, this.moved ? this.deltaEdge(this.moveX, this.x) : null, this.moved ? this.deltaEdge(this.moveY, this.y) : null, this.deltaEdge(x2, newX), this.deltaEdge(y2, newY), null, null, generalLine);
        this.x = x2;
        this.y = y2;
    }

    public void curveTo(String controlX, String controlY, String anchorX, String anchorY) throws IOException {
        String newX = this.moved ? this.moveX : this.x;
        String newY = this.moved ? this.moveY : this.y;
        this.writeEdge(this.moved ? this.edgeSelection : 0, this.moved ? this.deltaEdge(this.moveX, this.x) : null, this.moved ? this.deltaEdge(this.moveY, this.y) : null, this.deltaEdge(anchorX, newX), this.deltaEdge(anchorY, newY), this.deltaEdge(controlX, newX), this.deltaEdge(controlY, newY), false);
        this.x = anchorX;
        this.y = anchorY;
    }

    public void writeMatrix(Matrix v) throws IOException {
        this.writeMatrix(v.a, v.b, v.c, v.d, v.tx, v.ty);
    }

    public void writeMatrix(double a, double b, double c, double d, double tx, double ty) throws IOException {
        double multiplier = 1.52587890625E-5;
        a /= multiplier;
        b /= multiplier;
        c /= multiplier;
        d /= multiplier;
        tx *= 20.0;
        ty *= 20.0;
        long aLong = Math.round(a);
        long bLong = Math.round(b);
        long cLong = Math.round(c);
        long dLong = Math.round(d);
        long txLong = Math.round(tx);
        long tyLong = Math.round(ty);
        if (this.debugRandom) {
            for (int i = 0; i < 24; ++i) {
                this.write(88);
            }
            return;
        }
        this.write((int)(aLong & 0xFFL), (int)(aLong >> 8 & 0xFFL), (int)(aLong >> 16 & 0xFFL), (int)(aLong >> 24 & 0xFFL), (int)(bLong & 0xFFL), (int)(bLong >> 8 & 0xFFL), (int)(bLong >> 16 & 0xFFL), (int)(bLong >> 24 & 0xFFL), (int)(cLong & 0xFFL), (int)(cLong >> 8 & 0xFFL), (int)(cLong >> 16 & 0xFFL), (int)(cLong >> 24 & 0xFFL), (int)(dLong & 0xFFL), (int)(dLong >> 8 & 0xFFL), (int)(dLong >> 16 & 0xFFL), (int)(dLong >> 24 & 0xFFL), (int)(txLong & 0xFFL), (int)(txLong >> 8 & 0xFFL), (int)(txLong >> 16 & 0xFFL), (int)(txLong >> 24 & 0xFFL), (int)(tyLong & 0xFFL), (int)(tyLong >> 8 & 0xFFL), (int)(tyLong >> 16 & 0xFFL), (int)(tyLong >> 24 & 0xFFL));
    }

    public void writeBitmapFill(int type, Matrix bitmapMatrix, int bitmapId) throws IOException {
        this.write(255, 0, 0, 255, type, 0);
        this.writeMatrix(bitmapMatrix);
        if (this.debugRandom) {
            this.write(88, 88);
        } else {
            this.writeUI16(bitmapId);
        }
    }

    public void writeGradientFill(Color[] colors, double[] stopPos, int type, boolean linearRgb, int flow, Matrix gradientMatrix, double focalRatio) throws IOException {
        this.write(0, 0, 0, this.debugRandom ? 85 : 0);
        this.write(type, 0);
        this.writeMatrix(gradientMatrix);
        this.write(colors.length);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            this.write((int)Math.round(focalRatio * 255.0), 0, 0, 0, flow + (linearRgb ? 1 : 0), 0, 0, 0);
        }
        for (int i = 0; i < colors.length; ++i) {
            this.write((int)Math.round(stopPos[i] * 255.0), colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), this.debugRandom ? 88 : colors[i].getAlpha());
        }
    }

    public void writeSolidFill(Color fillColor) throws IOException {
        this.write(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillColor.getAlpha());
        this.write(0);
        this.write(0);
    }

    public void writeSolidStroke(Color lineColor, int strokeWidthTwips) throws IOException {
        this.writeSolidStroke(lineColor, strokeWidthTwips, false, SCALEMODE_NORMAL, CAPSTYLE_ROUND, JOINSTYLE_ROUND, 3.0f, 0, 0);
    }

    public void writeStrokeBegin(Color lineColor, double strokeWidth, boolean pixelHinting, int scaleMode, int capStyle, int joinStyle, float miter, int styleParam1, int styleParam2) throws IOException {
        int strokeWidthTwips = (int)Math.round(strokeWidth * 20.0);
        this.write(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), lineColor.getAlpha());
        this.write(strokeWidthTwips & 0xFF, strokeWidthTwips >> 8 & 0xFF);
        this.write(styleParam1 & 0xFF, styleParam1 >> 8 & 0xFF, styleParam2 & 0xFF, styleParam2 >> 8 & 0xFF);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            this.write(pixelHinting ? 1 : 0, scaleMode, capStyle, joinStyle, (int)(((double)miter - Math.floor(miter)) * 256.0), (int)Math.floor(miter));
        }
    }

    public void writeSolidStroke(Color lineColor, double strokeWidth, boolean pixelHinting, int scaleMode, int capStyle, int joinStyle, float miter, int styleParam1, int styleParam2) throws IOException {
        this.writeStrokeBegin(lineColor, strokeWidth, pixelHinting, scaleMode, capStyle, joinStyle, miter, styleParam1, styleParam2);
        this.writeSolidFill(lineColor);
    }

    public void writeKeyFrameMiddle() throws IOException {
        this.write(0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 6, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5);
    }

    public int generateRandomId() {
        if (this.debugRandom) {
            return 22616;
        }
        Random rnd = new Random();
        return rnd.nextInt(65536);
    }

    public void writeBomString(String s) throws IOException {
        if (this.flaFormatVersion.isUnicode()) {
            this.write(255, 254, 255);
        }
        this.writeString(s);
    }

    public void writeString(String s) throws IOException {
        int len;
        byte[] b = s.getBytes(this.charset);
        int n = len = this.flaFormatVersion.isUnicode() ? s.length() : b.length;
        if (len < 255) {
            this.write(len);
        } else if (len < 65535) {
            this.write(255);
            this.writeUI16(len);
        } else {
            this.write(255);
            this.write(255);
            this.write(255);
            this.writeUI32(len);
        }
        if (this.flaFormatVersion.isUnicode()) {
            this.write(s.getBytes("UTF-16LE"));
        } else {
            this.write(b);
        }
    }

    public void writeEndParentLayer(int parentLayerIndex) throws IOException {
        this.write(parentLayerIndex);
        this.write(0);
    }

    public void write(byte[] bytes) throws IOException {
        this.os.write(bytes);
        this.pos += (long)bytes.length;
    }

    public void write(int ... values) throws IOException {
        for (int i : values) {
            if (i > 255) {
                throw new IllegalArgumentException("Attempt to write larger value than 255 as byte");
            }
            this.os.write(i);
            ++this.pos;
        }
    }

    public void writeEncodedUI(int value) throws IOException {
        if (value >= Short.MAX_VALUE) {
            this.write(255, 127);
            this.writeUI32(value);
            return;
        }
        this.writeUI16(value);
    }

    public void writeUI16(int value) throws IOException {
        if (value > 65535) {
            throw new IllegalArgumentException("Attempt to write larger value than 0xFFFF as UI16");
        }
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public void writeItemID(String itemID) throws IOException {
        if (this.debugRandom) {
            this.write(88, 88, 88, 88, 88, 88, 88, 88);
            return;
        }
        Pattern itemIdPattern = Pattern.compile("^(?<hi>[a-f0-9]{8})-(?<lo>[a-f0-9]{8})$");
        Matcher m = itemIdPattern.matcher(itemID);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid itemID supplied: " + itemID);
        }
        Long itemIDHigh = Long.parseLong(m.group("hi"), 16);
        Long itemIDLow = Long.parseLong(m.group("lo"), 16);
        this.writeUI32(itemIDHigh);
        this.writeUI32(itemIDLow);
    }

    public void writeUI32(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
    }

    public void writeUI64(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
        this.write((int)(value >> 32 & 0xFFL));
        this.write((int)(value >> 40 & 0xFFL));
        this.write((int)(value >> 48 & 0xFFL));
        this.write((int)(value >> 56 & 0xFFL));
    }

    private void writePointPart(double val) throws IOException {
        int fullPart = (int)Math.floor(val);
        int fraction = (int)Math.round((val - (double)fullPart) * 256.0);
        this.write(fraction);
        this.write(fullPart & 0xFF);
        this.write(fullPart >> 8 & 0xFF);
        this.write(fullPart >> 16 & 0xFF);
    }

    public void writePoint(Point2D point) throws IOException {
        this.writePointPart(point.getX());
        this.writePointPart(point.getY());
    }

    public long getPos() {
        return this.pos;
    }

    public void writeDebugNote(String note) throws IOException {
        this.write(33);
        this.write(note.getBytes("UTF-8"));
    }
}

