/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.filters;

import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.filters.FilterInterface;
import java.awt.Color;
import java.io.IOException;

public class DropShadowFilter
implements FilterInterface {
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private float angle = 45.0f;
    private float distance = 5.0f;
    private boolean knockout = false;
    private boolean inner = false;
    private boolean hideObject = false;
    private Color color = Color.black;
    private boolean enabled = true;

    public DropShadowFilter() {
    }

    public DropShadowFilter(float blurX, float blurY, float strength, int quality, float angle, float distance, boolean knockout, boolean inner, boolean hideObject, Color color, boolean enabled) {
        this.blurX = blurX;
        this.blurY = blurY;
        this.strength = strength;
        this.quality = quality;
        this.angle = angle;
        this.distance = distance;
        this.knockout = knockout;
        this.inner = inner;
        this.hideObject = hideObject;
        this.color = color;
        this.enabled = enabled;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public float getStrength() {
        return this.strength;
    }

    public int getQuality() {
        return this.quality;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public boolean isInner() {
        return this.inner;
    }

    public boolean isHideObject() {
        return this.hideObject;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void write(FlaWriter os) throws IOException {
        os.write(new byte[]{0, 4, 1, (byte)(this.enabled ? 1 : 0), 0, 0, 0, (byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha()});
        os.writeFloat(this.distance);
        os.writeFloat(this.blurX);
        os.writeFloat(this.blurY);
        os.writeFloat((float)((double)this.angle * 3.1415927410125732 / 180.0));
        os.write(new byte[]{(byte)(this.inner ? 1 : 0), 0, 0, 0, (byte)(this.knockout ? 1 : 0), 0, 0, 0, (byte)this.quality, 0, 0, 0});
        int strengthPercent = Math.round(this.strength * 100.0f);
        os.write(new byte[]{(byte)(strengthPercent & 0xFF), (byte)(strengthPercent >> 8 & 0xFF), 0, 0, (byte)(this.hideObject ? 1 : 0), 0, 0, 0});
    }
}

