/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFrame;

public class HexPrint
extends JFrame {
    public static void printHex(File file) throws IOException {
        int i;
        String addrStr;
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dais = new DataInputStream(fis);
        byte[] buf = new byte[16];
        long addr = 0L;
        int len = 16;
        while (fis.available() >= 16) {
            dais.readFully(buf);
            addrStr = String.format("%1$04X", addr);
            System.out.print(addrStr + ": ");
            for (i = 0; i < len; ++i) {
                if (i == 8) {
                    System.out.print("| ");
                }
                System.out.print(String.format("%1$02X", buf[i] & 0xFF) + " ");
            }
            System.out.print("| ");
            for (i = 0; i < len; ++i) {
                if ((buf[i] & 0xFF) < 32) {
                    System.out.print(" ");
                    continue;
                }
                System.out.print("" + (char)(buf[i] & 0xFF));
            }
            System.out.println();
            addr += 16L;
        }
        if (fis.available() > 0) {
            len = fis.available();
            dais.readFully(buf, 0, len);
            addrStr = String.format("%1$04X", addr);
            System.out.print(addrStr + ": ");
            for (i = 0; i < len; ++i) {
                if (i == 8) {
                    System.out.print("| ");
                }
                System.out.print(String.format("%1$02X", buf[i] & 0xFF) + " ");
            }
            for (i = len; i < 16; ++i) {
                if (i == 8) {
                    System.out.print("| ");
                }
                System.out.print("   ");
            }
            System.out.print("| ");
            for (i = 0; i < len; ++i) {
                if ((buf[i] & 0xFF) < 32) {
                    System.out.print(" ");
                    continue;
                }
                System.out.print("" + (char)(buf[i] & 0xFF));
            }
            System.out.println();
        }
        fis.close();
    }

    private static void convert(String s) {
        s = s.replace(" | ", " ").replace("(", "").replace(")", "").replace(" # ", " ").replace("#", "");
        String[] parts = s.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            int val = Integer.parseInt(p, 16);
            if (val > 127) {
                sb.append("(byte) ");
            }
            sb.append("0x").append(p).append(", ");
        }
        System.out.println(sb);
    }

    private static void convert2(String s) {
        s = s.replaceAll("[\r\n ]+", "");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i += 2) {
            String v = s.substring(i, i + 2);
            int val = Integer.parseInt(v, 16);
            if (val > 127) {
                sb.append("(byte) ");
            }
            sb.append("0x").append(v).append(",");
            if (i <= 0 || i % 32 != 0) continue;
            sb.append("\r\n");
        }
        System.out.println(sb);
    }

    public static void main(String[] args) {
        String t = "12 34 56";
        HexPrint.convert2(t);
    }
}

