/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.ResizableIconUIResource;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.animation.effects.GhostingListener;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.flamingo.common.TransitionAwareResizableIcon;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.flamingo.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.substance.flamingo.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.substance.flamingo.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

public class SubstanceCommandButtonUI
extends BasicCommandButtonUI
implements ActionPopupTransitionAwareUI {
    protected Set lafWidgets;
    protected ButtonBackgroundDelegate backgroundDelegate = new ButtonBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    protected CommandButtonVisualStateTracker substanceVisualStateTracker;
    private ButtonModel overallRolloverModel = new DefaultButtonModel();
    protected RolloverControlListener substanceOverallRolloverListener;
    protected StateTransitionTracker overallStateTransitionTracker;

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installComponents() {
        super.installComponents();
    }

    protected void installComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void installListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void installDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallComponents() {
        super.uninstallComponents();
    }

    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandButtonUI((JCommandButton)comp);
    }

    public SubstanceCommandButtonUI(JCommandButton button) {
        this.overallRolloverModel.setArmed(false);
        this.overallRolloverModel.setSelected(false);
        this.overallRolloverModel.setPressed(false);
        this.overallRolloverModel.setRollover(false);
        this.overallRolloverModel.setEnabled(button.isEnabled());
        this.overallStateTransitionTracker = new StateTransitionTracker((JComponent)button, this.overallRolloverModel);
        this.substanceVisualStateTracker = new CommandButtonVisualStateTracker();
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installDefaults() {
        super.installDefaults();
        this.commandButton.putClientProperty((Object)"substancelaf.buttonShaper", (Object)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder((Border)new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("actionModel".equals(evt.getPropertyName())) {
                    if (SubstanceCommandButtonUI.this.substanceModelChangeListener != null) {
                        SubstanceCommandButtonUI.this.substanceModelChangeListener.unregisterListeners();
                    }
                    SubstanceCommandButtonUI.this.substanceModelChangeListener = new GhostingListener((JComponent)SubstanceCommandButtonUI.this.commandButton, (ButtonModel)SubstanceCommandButtonUI.this.commandButton.getActionModel());
                    SubstanceCommandButtonUI.this.substanceModelChangeListener.registerListeners();
                }
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceCommandButtonUI.this.overallRolloverModel.setEnabled(SubstanceCommandButtonUI.this.commandButton.isEnabled());
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
        this.substanceOverallRolloverListener = new RolloverControlListener((TransitionAwareUI)this, this.overallRolloverModel);
        this.commandButton.addMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.addMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.overallStateTransitionTracker.registerModelListeners();
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandButtonUI__uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        this.commandButton.removeMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.removeMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.substanceOverallRolloverListener = null;
        this.overallStateTransitionTracker.unregisterModelListeners();
        super.uninstallListeners();
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        if (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        PopupButtonModel popupModel = ((JCommandButton)this.commandButton).getPopupModel();
        Rectangle actionArea = this.getLayoutInfo().actionClickArea;
        Rectangle popupArea = this.getLayoutInfo().popupClickArea;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getCombinedCommandButtonBackground(this.commandButton, (ButtonModel)actionModel, actionArea, popupModel, popupArea);
        boolean isFlat = this.commandButton.isFlat() && !((JCommandButton)this.commandButton).getPopupModel().isPopupShowing();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                float extraActionAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getActionTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraActionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                float extraPopupAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getPopupTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraPopupAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                extraAlpha = Math.max(extraActionAlpha, extraPopupAlpha);
            } else {
                ComponentState actionAreaState = ComponentState.getState((ButtonModel)actionModel, (JComponent)this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.commandButton, (float)extraAlpha, (Graphics)graphics));
            g2d.drawImage((Image)fullAlphaBackground, 0, 0, null);
            g2d.dispose();
        }
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        JCommandButton jcb = (JCommandButton)this.commandButton;
        ResizableIcon regular = jcb.getIcon();
        if (this.toUseDisabledIcon() && jcb.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = jcb.getDisabledIcon();
        }
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        boolean useThemed = SubstanceCoreUtilities.useThemedDefaultIcon((JComponent)this.commandButton);
        if (regular != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)jcb, (Icon)regular, (Rectangle)iconRect);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jcb, (Graphics)g));
            if (!useThemed) {
                regular.paintIcon((Component)jcb, g2d, iconRect.x, iconRect.y);
            } else {
                StateTransitionTracker tracker = this.substanceVisualStateTracker.getActionStateTransitionTracker();
                ActionButtonModel model = this.commandButton.getActionModel();
                if (jcb.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
                    tracker = this.substanceVisualStateTracker.getPopupStateTransitionTracker();
                    model = jcb.getPopupModel();
                }
                CommandButtonBackgroundDelegate.paintThemedCommandButtonIcon(g2d, iconRect, (AbstractCommandButton)jcb, (Icon)regular, (ButtonModel)model, tracker);
            }
            g2d.dispose();
        }
    }

    protected void paintButtonHorizontalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(0, separatorArea.y);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)this.commandButton.getWidth(), (int)1, (int)0, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    protected void paintButtonVerticalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(separatorArea.x, 0);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)1, (int)this.commandButton.getHeight(), (int)1, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    protected boolean isPaintingBackground() {
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.overallStateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    protected boolean isPaintingSeparators() {
        if (super.isPaintingSeparators()) {
            return true;
        }
        boolean hasIcon = this.commandButton.getIcon() != null;
        return hasIcon && this.overallStateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    protected ResizableIcon createPopupActionIcon() {
        final int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton);
        int arrowIconHeight = (int)SubstanceSizeUtils.getArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon icon = new TransitionAwareResizableIcon(this.commandButton, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return SubstanceCommandButtonUI.this.getPopupTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                JCommandButton.CommandButtonPopupOrientationKind orientation = ((JCommandButton)SubstanceCommandButtonUI.this.commandButton).getPopupOrientationKind();
                int direction = orientation == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD ? 5 : (SubstanceCommandButtonUI.this.commandButton.getComponentOrientation().isLeftToRight() ? 3 : 7);
                Icon result = SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)(SubstanceSizeUtils.getArrowStrokeWidth((int)fontSize) - 0.5f), (int)direction, (SubstanceColorScheme)scheme);
                return result;
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        return icon;
    }

    public void paint(Graphics g, JComponent c) {
        boolean useActionAreaForFg;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(FlamingoUtilities.getFont((Component)this.commandButton, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty((Object)"icon.bounds", (Object)this.layoutInfo.iconRect);
        this.commandButton.putClientProperty((Object)"icon", (Object)this.commandButton.getIcon());
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        }
        StateTransitionTracker transitionTrackerForFg = (useActionAreaForFg = this.layoutInfo.isTextInActionArea) ? this.getActionTransitionTracker() : this.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfoForFg = transitionTrackerForFg.getModelStateInfo();
        ComponentState currStateForFg = modelStateInfoForFg.getCurrModelState();
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)currStateForFg);
            fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfoForFg, (float)buttonAlpha);
        }
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            Color disabledFgColor = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED).getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (currStateForFg.isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)SubstanceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        }
        if (this.layoutInfo.popupActionRect.getWidth() > 0.0) {
            this.paintPopupActionIcon(g2d, this.layoutInfo.popupActionRect);
        }
        if (this.isPaintingSeparators() && this.layoutInfo.separatorArea != null) {
            if (this.layoutInfo.separatorOrientation == CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL) {
                this.paintButtonHorizontalSeparator(g2d, this.layoutInfo.separatorArea);
            } else {
                this.paintButtonVerticalSeparator(g2d, this.layoutInfo.separatorArea);
            }
        }
        g2d.dispose();
    }

    protected void paintPopupActionIcon(Graphics g, Rectangle popupActionRect) {
        int width = popupActionRect.width;
        int height = popupActionRect.height;
        if (((JCommandButton)this.commandButton).getPopupOrientationKind() == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD) {
            if ((width += 2) % 2 == 0) {
                ++width;
            }
            height = height / 2 - 1;
        } else {
            height /= 2;
            if (++width % 2 == 0) {
                ++width;
            }
        }
        this.popupActionIcon.setDimension(new Dimension(width, height));
        this.popupActionIcon.paintIcon((Component)this.commandButton, g, popupActionRect.x + (popupActionRect.width - width) / 2, popupActionRect.y + (popupActionRect.height - height) / 2);
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize((JComponent)button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getDisplayState() == CommandButtonDisplayState.MEDIUM && SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, (Component)button) == null && SwingUtilities.getAncestorOfClass(JBreadcrumbBar.class, (Component)button) == null && SwingUtilities.getAncestorOfClass(JCommandPopupMenu.class, (Component)button) == null) {
            JButton dummy = new JButton(button.getText(), (Icon)button.getIcon());
            Dimension result = shaper.getPreferredSize((AbstractButton)dummy, superPref);
            if (FlamingoUtilities.hasPopupAction((AbstractCommandButton)button)) {
                result.width = superPref.width;
            }
            return result;
        }
        return superPref;
    }

    private float getSeparatorAlpha() {
        ComponentState actionAreaState = this.getActionTransitionTracker().getModelStateInfo().getCurrModelState();
        if (!actionAreaState.isFacetActive(ComponentStateFacet.SELECTION) && !actionAreaState.isDisabled()) {
            float actionRolloverCycle = this.getActionTransitionTracker().getFacetStrength(ComponentStateFacet.ROLLOVER);
            float popupRolloverCycle = this.getPopupTransitionTracker().getFacetStrength(ComponentStateFacet.ROLLOVER);
            return Math.min(1.0f, actionRolloverCycle + popupRolloverCycle);
        }
        return 1.0f;
    }

    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon((ResizableIcon)new ResizableIconUIResource((ResizableIcon)new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.overallStateTransitionTracker;
    }

    public boolean isInside(MouseEvent me) {
        boolean inAction = this.layoutInfo.actionClickArea != null && this.layoutInfo.actionClickArea.contains(me.getPoint());
        boolean inPopup = this.layoutInfo.popupClickArea != null && this.layoutInfo.popupClickArea.contains(me.getPoint());
        return inAction || inPopup;
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }
}

