; FSG v2 module for HzorInline v1.x by arnix
; Module engine: v3
; Please read readme.txt file of the program for more information
; Copyright (C) arnix, 2005-2006
; E-mail: arnix@freenet.am

format PE GUI 4.0 DLL
entry DllEntryPoint

include '%fasminc%/win32a.inc'

section '.i' import data readable writeable

   library kernel32,	'KERNEL32.DLL',\
	   user32,	'USER32.DLL'

	   include	'%fasminc%/apia/kernel32.inc'
	   include	'%fasminc%/apia/user32.inc'


section '.d' data readable writeable

wMZ		    dw 'MZ'
dwPE		    dd 00004550h
dwSectNumber	    dw 0
dwImageBase	    dd 0
dwFileAlignment     dd 0
dwSectionsAddr	    dd 0
dwVOffset	    dd 0
dwRSize 	    dd 0
dwVSize 	    dd 0
dwROffset	    dd 0

dwFileName	    dd 0
dwFile		    dd 0
dwFileSize	    dd 0
dwIdScript	    dd 0
dwMemptr	    dd 0
dwRead		    dd 0

Fsg2Sig 	    db 4Ch,01h,02h,00h,46h,53h,47h,21h
Fsg2SigSize	    dd $-Fsg2Sig

Fsg2ID		    db 61h,94h,55h,0A4h,0B6h,80h,0FFh,13h,73h,0F9h,33h,0C9h,0FFh,13h,73h,16h,33h,0C0h,0FFh,13h,73h,1Fh,0B6h,80h,41h,0B0h,10h,0FFh,13h,12h,0C0h,73h,0FAh,75h
Fsg2IDSize	    dd $-Fsg2ID

szAboutCap	    db 'About',0
szAboutMes	    db 'FSG v2 module',13,10,\
		       'Designed for use with [HzorInline v1.x by arnix]',13,10,'Module engine: v3',13,10,'Coded by arnix',13,10,'Source is available',13,10,\
		       'E-mail: arnix@freenet.am',13,10,'URL: http://arnix.at.googlepages.com',0
szModuleName	    db 'FSG 2.0 -> bart/xt',0
dwModuleNameSz	    dd $-szModuleName
szErrorCap	    db 'Error',0
szMainProcComm	    db ';MAIN PROCEDURE START',13,10
dwMainProcCommSz    dd $-szMainProcComm
szProc		    db 'PROC',13,10
dwProcSz	    dd $-szProc
szEndp		    db 'ENDP',13,10
dwEndpSz	    dd $-szEndp
szMainProcEndComm   db ';MAIN PROCEDURE END',13,10
dwMainProcEndCommSz dd $-szMainProcEndComm
szNop		    db 'NOP',13,10
dwNopSz 	    dd $-szNop
szPushad	    db 'PUSHAD',13,10
dwPushadSz	    dd $-szPushad
szAddHereYrPatch    db ';ADD HERE YOUR PATCH STRINGS',13,10
dwAddHereYrPatchSz  dd $-szAddHereYrPatch
szRest		    db 'REST',13,10
dwRestSz	    dd $-szRest
szPushOEP	    db 'PUSH OEP',13,10
dwPushOEPSz	    dd $-szPushOEP
szPushOUT	    db 'PUSH OUT',13,10
dwPushOUTSz	    dd $-szPushOUT
szRetn		    db 'RETN',13,10
dwRetnSz	    dd $-szRetn
szPopad 	    db 'POPAD',13,10
dwPopadSz	    dd $-szPopad
szNewLine	    db 13,10
dwNewLineSz	    dd $-szNewLine
szOUT		    db 'OUT='
dwOUTSz 	    dd $-szOUT
szOEP		    db 'OEP='
dwOEPSz 	    dd $-szOEP
szFREE		    db 'FREE='
dwFREESz	    dd $-szFREE
szFREEAUTO	    db 'FREE=AUTO'
dwFREEAUTOSz	    dd $-szFREEAUTO
szFREEAPPEND	    db 'FREE=APPEND'
dwFREEAPPENDSz	    dd $-szFREEAPPEND

dwFREEVABuffer	    dd 0

szFileOpenError     db 'FSG_V2.DLL Module: Can not open file!',0
szAllocError	    db 'FSG_V2.DLL Module: Can not allocate memory!',0
szInvalidPEError    db 'FSG_V2.DLL Module: The file is not a valid win32 PE file!',0
szCantFindAddrError db 'FSG_V2.DLL Module: Can not find the address! Maybe the file is not packed with FSG v2?',0
szUnknownError	    db 'FSG_V2.DLL Module: Unknown error!',0
szCantFindFreeSpace db 'FSG_V2.DLL Module: Can not find free space for patch!',0

szBuffer	    rb 800h
szOEPBuffer	    rb 0Ch
szOUTBuffer	    rb 0Ch
szFREEBuffer	    rb 0Ch
szPATCHBuffer	    rb 0Ch

section '.c' code readable executable

proc DllEntryPoint, hinstDLL,fdwReason,lpvReserved
   or	   eax,-1
   ret
endp

proc HzorInit ;Here we get the address of the string with filename of packed exe in EAX register
   mov	  [dwFileName],eax
   ;We can do here some other initializations if we need.. Return 0 in EAX if any error occures.
   or eax,-1
   retn
endp


proc HzorDoJob ;Here we get the handle of script window in EAX register
   mov	  [dwIdScript],eax
  ;=============================================================================
  ;If we want we can add there any lines, e.g. for patching CRC check of a packer
  ;szString db 'P,004050AB,EB',13,10,'P,004050BB,90',0
  ;...
  ;invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szString
  ;=============================================================================
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   invoke MessageBox,NULL,szFileOpenError,szErrorCap,MB_OK
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szAllocError,szErrorCap,MB_OK
   invoke CloseHandle,[dwFile]
   xor	  eax,eax
   jmp	  exit
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  exit
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   invoke MessageBox,NULL,szInvalidPEError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  exit
@@:
   mov	  ecx,edi
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
@@:
   mov	  edi,ecx
   add	  edi,4
   push   esi
   push   edi
   mov	  esi,Fsg2Sig
   mov	  ecx,[Fsg2SigSize]
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   pop	  edi
   pop	  esi
   invoke MessageBox,NULL,szCantFindAddrError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  exit
@@:
   pop	  edi
   pop	  esi

   mov	  edi,[dwMemptr]
   add	  edi,[dwFileSize]
   sub	  edi,2Dh
   mov	  eax,[edi]
   push   edi
   mov	  edi,szOEPBuffer
   call   dword2hex
   pop	  eax
   sub	  eax,[dwMemptr]
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  exit
@@:
   mov	  edi,szPATCHBuffer
   call   dword2hex
   mov	  eax,[dwFileSize]
   call   raw2va
   test   eax,eax
   jnz	  @f
   invoke MessageBox,NULL,szUnknownError,szErrorCap,MB_OK
   xor	  eax,eax
   jmp	  exit
@@:
   mov	  [dwFREEVABuffer],eax

   mov	  edi,szBuffer

   mov	  esi,szOEP
   mov	  ecx,[dwOEPSz]
   rep	  movsb

   mov	  esi,szOEPBuffer
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szFREEAPPEND
   mov	  ecx,[dwFREEAPPENDSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  al,'P'
   stosb
   mov	  al,','
   stosb
   mov	  esi,szPATCHBuffer
   call   str_len
   dec	  eax
@@:
   inc	  eax
   cmp	  eax,8
   jz	  @f
   mov	  byte [edi],'0'
   inc	  edi
   jmp	  @b
@@:
   mov	  esi,szPATCHBuffer
   call   str_len
   mov	  ecx,eax
   rep	  movsb

   mov	  esi,dwFREEVABuffer
   mov	  ecx,5
   dec	  esi
_next:
   inc	  esi
   dec	  ecx
   jz	  _finish
   mov	  al,','
   stosb
   xor	  eax,eax
   mov	  al,byte [esi]
   test   eax,eax
   jnz	  @f
   push   eax
   mov	  al,'0'
   stosb
   pop	  eax
@@:
   call   dword2hex
   dec	  edi
@@:
   inc	  edi
   cmp	  byte [edi],0
   jnz	  @b
   jmp	  _next

_finish:
   mov	  al,0Dh
   stosb
   mov	  al,0Ah
   stosb

   mov	  esi,szMainProcComm
   mov	  ecx,[dwMainProcCommSz]
   rep	  movsb

   mov	  esi,szProc
   mov	  ecx,[dwProcSz]
   rep	  movsb

   mov	  esi,szPushad
   mov	  ecx,[dwPushadSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szAddHereYrPatch
   mov	  ecx,[dwAddHereYrPatchSz]
   rep	  movsb

   mov	  esi,szNewLine
   mov	  ecx,[dwNewLineSz]
   rep	  movsb

   mov	  esi,szPopad
   mov	  ecx,[dwPopadSz]
   rep	  movsb

   mov	  esi,szPushOEP
   mov	  ecx,[dwPushOEPSz]
   rep	  movsb

   mov	  esi,szRetn
   mov	  ecx,[dwRetnSz]
   rep	  movsb

   mov	  esi,szEndp
   mov	  ecx,[dwEndpSz]
   rep	  movsb

   mov	  esi,szMainProcEndComm
   mov	  ecx,[dwMainProcEndCommSz]
   rep	  movsb

   mov	  al,0
   stosb

   invoke  SendMessage,[dwIdScript],WM_SETTEXT,NULL,szBuffer
   or	   eax,-1 ; mov eax,-1

exit:
   push   eax
   invoke GlobalFree, [dwMemptr]
   pop	  eax
   retn
endp

proc HzorPluginInfo
   invoke MessageBox,NULL,szAboutMes,szAboutCap,MB_OK
   retn
endp

proc HzorIdentify
   invoke SetFileAttributes,[dwFileName],0080h
   invoke CreateFile,[dwFileName],80000000h,0,0,3,0080h,0
   mov	  [dwFile],eax
   cmp	  eax,-1
   jnz	  @f
   xor	  eax,eax
   retn
@@:
   invoke GetFileSize,[dwFile],0
   mov	  [dwFileSize],eax
   invoke GlobalAlloc,0000h,[dwFileSize]
   mov	  [dwMemptr],eax
   test   eax,eax
   jnz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   invoke ReadFile,[dwFile],[dwMemptr],[dwFileSize],dwRead,0
   invoke CloseHandle,[dwFile]
   mov	  edi,[dwMemptr]
   mov	  esi,edi
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  ax,word [edi]
   cmp	  ax,[wMZ]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   add	  edi,3Ch
   mov	  eax,[edi]
   mov	  edi,[dwMemptr]
   add	  edi,eax
   mov	  eax,[edi]
   cmp	  eax,[dwPE]
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   push   edi
   add	  edi,06h
   mov	  ax,word [edi]
   mov	  [dwSectNumber],ax
   add	  edi,2Eh
   push   dword [edi]
   pop	  [dwImageBase]
   pop	  edi
   push   edi
   add	  edi,03Ch
   push   dword [edi]
   pop	  [dwFileAlignment]
   pop	  edi
   mov	  eax,edi
   add	  eax,14h
   movzx  eax,word [eax]
   add	  eax,18h ;Size of PE Header
   mov	  [dwSectionsAddr],edi
   add	  [dwSectionsAddr],eax
   add	  edi,28h
   mov	  edi,[edi] ;Entry point RVA
   mov	  eax,edi
   call   rva2raw
   test   eax,eax
   jnz	  @f
   mov	  eax,edi
@@:
   mov	  edi,eax
   add	  edi,[dwMemptr]
   mov	  esi,[dwMemptr]
   add	  esi,[dwFileSize]
   dec	  esi
   mov	  al,61h
@@:
   inc	  edi
   cmp	  byte [edi],al
   je	  .found_61
.continue_search_61:
   cmp	  edi,esi
   jb	  @b
;not found
   xor	  eax,eax
   jmp	  _ret
.found_61:
   cmp	  byte [edi+1],94h
   jnz	  .continue_search_61

   mov	  esi,Fsg2ID
   mov	  ecx,[Fsg2IDSize]
   repz   cmpsb
   test   ecx,ecx
   jz	  @f
   xor	  eax,eax
   jmp	  _ret
@@:
   or	  eax,-1
_ret:
   retn
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc raw2va
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax

   push   dword [edi+0Ch]
   pop	  [dwVOffset]

   push   dword [edi+10h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   add	  eax,[dwFileAlignment]
   mov	  [dwRSize],eax

   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax

   pop	  eax

   cmp	  eax,[dwROffset]
   jna	  @f
   mov	  esi,[dwRSize]
   add	  esi,[dwROffset]
   cmp	  eax,esi
   ja	  @f
   mov	  esi,[dwVOffset]
   add	  esi,eax
   mov	  eax,esi
   add	  eax,[dwImageBase]
   sub	  eax,[dwROffset]
   jmp	  .exit
@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
proc rva2raw
   push   esi
   push   edi
   push   ecx

   xor	  ecx,ecx
   mov	  cx,[dwSectNumber]
   mov	  edi,[dwSectionsAddr]
.next_section:
   push   eax
   push   dword [edi+08h]
   pop	  [dwVSize]
   push   dword [edi+0Ch]
   pop	  [dwVOffset]
   push   dword [edi+14h]
   pop	  eax
   xor	  edx,edx
   div	  [dwFileAlignment]
   mul	  [dwFileAlignment]
   mov	  [dwROffset],eax
   pop	  eax

   cmp	  eax,[dwVOffset]
   jl	  @f
   mov	  esi,[dwVSize]
   add	  esi,[dwVOffset]
   cmp	  eax,esi
   jge	  @f
   sub	  eax,[dwVOffset]
   mov	  esi,[dwROffset]
   add	  esi,eax
   mov	  eax,esi
   jmp	  .exit

@@:
   add	  edi,28h
   dec	  ecx
   jnz	  .next_section
;cant calculate
   xor	  eax,eax
.exit:
   pop	  ecx
   pop	  edi
   pop	  esi
retn
endp


; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the dword value in EAX register and an address to a buffer to write the string in EDI (need max. 9 byte-length)
; Returns nothing, but the result is the zero-terminated string in address of EDI
proc dword2hex
   push    eax
   push    ecx
   push    edi

   push    10h
   pop	   ecx
   push    -30h
@@:
   xor	   edx,edx
   div	   ecx
   push    edx
   test    eax,eax
   jnz	   @b
.next:
   pop	   eax
   add	   al,30h
   cmp	   al,3Ah
   jb	   @f
   add	   al,07h
@@:
   stosb
   test    al,al
   jnz	   .next

   pop	   edi
   pop	   ecx
   pop	   eax
ret
endp

; =========================================================================================
; (C) arnix [arnix@freenet.am]
; Gets the address of zero terminated string in ESI register
; Returns the length in EAX register
proc str_len
   push    esi
   push    ecx

   or	   ecx,-1
@@:
   inc	   ecx
   lodsb
   test    al,al
   jnz	   @b

   push    ecx
   pop	   eax
   pop	   ecx
   pop	   esi
retn
endp


section '.e' export data readable

  export 'FSG_V2.DLL',\
	 HzorInit,'HzorInit',\
	 HzorDoJob,'HzorDoJob',\
	 HzorPluginInfo,'HzorPluginInfo',\
	 HzorIdentify,'HzorIdentify'

section '.r' fixups data discardable